/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.IJavaCellEditor;
import org.eclipse.ve.internal.jfc.core.IconDialog;
import org.eclipse.ve.internal.propertysheet.INeedData;

public class ImageCellEditor
extends DialogCellEditor
implements IJavaCellEditor,
INeedData {
    protected EditDomain fEditDomain;
    private String path = "";
    private static final String IMAGE_INITSTRING_START = "java.awt.Toolkit.getDefaultToolkit().getImage(";

    public ImageCellEditor(Composite parent) {
        super(parent);
    }

    private Object createValue(String path) {
        if (path == null || path.equals("")) {
            return null;
        }
        this.path = path;
        return BeanUtilities.createJavaObject((String)"java.awt.Image", (ResourceSet)EMFEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain), (String)this.getJavaInitializationString());
    }

    protected String getPathFromInitializationString(String initStr) {
        if (initStr == null || !initStr.startsWith(IMAGE_INITSTRING_START)) {
            return "";
        }
        int lastParen = initStr.lastIndexOf(41);
        if (lastParen == -1) {
            return "";
        }
        return initStr.substring(IMAGE_INITSTRING_START.length(), lastParen).trim();
    }

    public String getJavaInitializationString() {
        return IMAGE_INITSTRING_START + this.path + ")";
    }

    protected void updateContents(Object aValue) {
        String initString;
        Label lbl = this.getDefaultLabel();
        if (lbl == null) {
            return;
        }
        String text = "";
        if (aValue != null && (initString = this.getPathFromInitializationString(((IJavaObjectInstance)aValue).getInitializationString())) != "") {
            text = initString;
        }
        lbl.setText(text);
    }

    public Object openDialogBox(Control cellEditorWindow) {
        int returnCode;
        IconDialog iconDialog = new IconDialog(cellEditorWindow.getShell(), ((IFileEditorInput)this.fEditDomain.getEditorPart().getEditorInput()).getFile().getProject());
        IJavaObjectInstance aValue = (IJavaObjectInstance)this.getValue();
        if (aValue != null) {
            this.path = this.getPathFromInitializationString(aValue.getInitializationString());
            if (this.path != "") {
                iconDialog.setValue(this.path);
            }
        }
        if ((returnCode = iconDialog.open()) == 0) {
            return this.createValue(iconDialog.getValue());
        }
        return null;
    }

    public void setData(Object data) {
        this.fEditDomain = (EditDomain)data;
    }
}

