/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.beaninfo.adapters.Utilities;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyDomain;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.jfc.core.BeanAwtUtilities;
import org.eclipse.ve.internal.jfc.core.ComponentProxyAdapter;
import org.eclipse.ve.internal.jfc.core.IComponentProxyHost;

public class JMenuProxyAdapter
extends ComponentProxyAdapter {
    protected EStructuralFeature sfItems;
    protected JavaClass classComponent;
    protected JavaClass classAction;
    protected JavaClass classString;
    protected IMethodProxy fAddActionMethodProxy;
    protected IMethodProxy fAddStringMethodProxy;

    public JMenuProxyAdapter(IBeanProxyDomain domain) {
        super(domain);
        ResourceSet rset = EMFEditDomainHelper.getResourceSet((EditDomain)domain.getEditDomain());
        this.classComponent = (JavaClass)Utilities.getJavaClass((String)"java.awt.Component", (ResourceSet)rset);
        this.classAction = (JavaClass)Utilities.getJavaClass((String)"javax.swing.Action", (ResourceSet)rset);
        this.classString = (JavaClass)Utilities.getJavaClass((String)"java.lang.String", (ResourceSet)rset);
    }

    protected void applied(EStructuralFeature as, Object newValue, int position) {
        if (as == this.getSFItems()) {
            this.addComponent((EObject)newValue, position);
        } else {
            super.applied(as, newValue, position);
        }
    }

    protected void canceled(EStructuralFeature sf, Object oldValue, int position) {
        if (sf == this.getSFItems()) {
            this.removeComponent((EObject)oldValue);
        } else {
            super.canceled(sf, oldValue, position);
        }
    }

    private void addComponent(EObject aComponent, int position) {
        IBeanProxyHost componentProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaInstance)aComponent));
        componentProxyHost.instantiateBeanProxy();
        if (componentProxyHost.getErrorStatus() == 3 || this.getErrorStatus() == 3) {
            return;
        }
        IBeanProxy componentBeanProxy = componentProxyHost.getBeanProxy();
        IBeanProxy beforeBeanProxy = null;
        if (position != -1) {
            beforeBeanProxy = this.getBeanProxyAt(position + 1);
        }
        try {
            IMethodProxy addStringMethodProxy;
            if (this.classComponent.isInstance((Object)aComponent)) {
                if (beforeBeanProxy != null) {
                    BeanAwtUtilities.invoke_add_Component_before(this.getBeanProxy(), componentBeanProxy, beforeBeanProxy);
                } else {
                    BeanAwtUtilities.invoke_add_Component(this.getBeanProxy(), componentBeanProxy);
                }
            } else if (this.classAction.isInstance((Object)aComponent)) {
                IMethodProxy addActionMethodProxy = this.getAddActionMethodProxy();
                if (addActionMethodProxy != null) {
                    addActionMethodProxy.invoke(this.getBeanProxy(), componentBeanProxy);
                }
            } else if (this.classString.isInstance((Object)aComponent) && (addStringMethodProxy = this.getAddStringMethodProxy()) != null) {
                addStringMethodProxy.invoke(this.getBeanProxy(), componentBeanProxy);
            }
        }
        catch (ThrowableProxy e) {
            this.processError(this.sfItems, e, aComponent);
        }
        if (this.classComponent.isInstance((Object)aComponent)) {
            IComponentProxyHost componentAdapter = (IComponentProxyHost)componentProxyHost;
            componentAdapter.setParentComponentProxyHost(this);
        }
        this.revalidateBeanProxy();
        this.clearError(this.sfItems, aComponent);
    }

    protected IBeanProxy getBeanProxyAt(int position) {
        List menuitems = (List)((EObject)this.getTarget()).eGet(this.getSFItems());
        int i = position;
        while (i < menuitems.size()) {
            EObject menuitem = (EObject)menuitems.get(i);
            IBeanProxyHost componentProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaInstance)menuitem));
            if (componentProxyHost.isBeanProxyInstantiated()) {
                return componentProxyHost.getBeanProxy();
            }
            ++i;
        }
        return null;
    }

    protected EStructuralFeature getSFItems() {
        if (this.sfItems == null) {
            JavaClass modelType = (JavaClass)((EObject)this.getTarget()).eClass();
            this.sfItems = modelType.getEStructuralFeature("items");
        }
        return this.sfItems;
    }

    protected void removeComponent(EObject aComponent) {
        this.clearError(this.getSFItems(), aComponent);
        IBeanProxyHost aComponentBeanProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaInstance)aComponent));
        if (aComponentBeanProxyHost.getErrorStatus() != 3 && this.getErrorStatus() != 3) {
            if (this.classComponent.isInstance((Object)aComponent)) {
                BeanAwtUtilities.invoke_remove_Component(this.getBeanProxy(), aComponentBeanProxyHost.getBeanProxy());
            } else if (this.classString.isInstance((Object)aComponent)) {
                BeanAwtUtilities.invoke_jmenu_remove_jmenuitem_string(this.getBeanProxy(), (IStringBeanProxy)aComponentBeanProxyHost.getBeanProxy());
            } else if (this.classAction.isInstance((Object)aComponent)) {
                BeanAwtUtilities.invoke_jmenu_remove_jmenuitem_action(this.getBeanProxy(), aComponentBeanProxyHost.getBeanProxy());
            }
            aComponentBeanProxyHost.releaseBeanProxy();
            this.revalidateBeanProxy();
        }
    }

    protected IMethodProxy getAddActionMethodProxy() {
        if (this.fAddActionMethodProxy == null) {
            this.fAddActionMethodProxy = this.getBeanProxy().getTypeProxy().getMethodProxy("add", "javax.swing.Action");
        }
        return this.fAddActionMethodProxy;
    }

    protected IMethodProxy getAddStringMethodProxy() {
        if (this.fAddStringMethodProxy == null) {
            this.fAddStringMethodProxy = this.getBeanProxy().getTypeProxy().getMethodProxy("add", "java.lang.String");
        }
        return this.fAddStringMethodProxy;
    }

    public void releaseBeanProxy() {
        super.releaseBeanProxy();
        if (this.fAddActionMethodProxy != null) {
            this.fAddActionMethodProxy.getProxyFactoryRegistry().releaseProxy((IBeanProxy)this.fAddActionMethodProxy);
            this.fAddActionMethodProxy = null;
        }
        if (this.fAddStringMethodProxy != null) {
            this.fAddStringMethodProxy.getProxyFactoryRegistry().releaseProxy((IBeanProxy)this.fAddStringMethodProxy);
            this.fAddStringMethodProxy = null;
        }
    }
}

