/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.beaninfo.PropertyDecorator;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyDomain;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.jcm.BeanFeatureDecorator;
import org.eclipse.ve.internal.jfc.core.ContainerProxyAdapter;
import org.eclipse.ve.internal.jfc.core.IComponentProxyHost;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.jfc.core.JSplitPaneManager;

public class JSplitPaneProxyAdapter
extends ContainerProxyAdapter {
    protected EStructuralFeature sfLeftComponent;
    protected EStructuralFeature sfRightComponent;
    protected EStructuralFeature sfTopComponent;
    protected EStructuralFeature sfBottomComponent;
    protected EStructuralFeature sfDividerLocation;
    protected JSplitPaneManager splitPaneManager;
    protected boolean dividerSet;

    public JSplitPaneProxyAdapter(IBeanProxyDomain domain) {
        super(domain);
        ResourceSet rset = EMFEditDomainHelper.getResourceSet((EditDomain)domain.getEditDomain());
        this.sfLeftComponent = JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_LEFTCOMPONENT);
        this.sfRightComponent = JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_RIGHTCOMPONENT);
        this.sfBottomComponent = JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_BOTTOMCOMPONENT);
        this.sfTopComponent = JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_TOPCOMPONENT);
        this.sfDividerLocation = JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_DIVIDERLOCATION);
        this.getOriginalSettingsTable().put(this.sfDividerLocation, domain.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(-1));
    }

    protected void applied(EStructuralFeature as, Object newValue, int position) {
        super.applied(as, newValue, position);
        if ((as == this.sfLeftComponent || as == this.sfRightComponent || as == this.sfTopComponent || as == this.sfBottomComponent) && newValue != null) {
            IBeanProxyHost componentProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaInstance)newValue));
            IComponentProxyHost componentAdapter = (IComponentProxyHost)componentProxyHost;
            componentAdapter.setParentComponentProxyHost(this);
        }
    }

    protected void setupBeanProxy(IBeanProxy beanProxy) {
        super.setupBeanProxy(beanProxy);
        if (beanProxy != null) {
            if (this.splitPaneManager == null) {
                this.splitPaneManager = new JSplitPaneManager();
            }
            this.splitPaneManager.setJSplitPaneBeanProxy(this, beanProxy);
        }
    }

    public void releaseBeanProxy() {
        super.releaseBeanProxy();
        if (this.splitPaneManager != null) {
            this.splitPaneManager.dispose();
            this.splitPaneManager = null;
        }
    }

    protected void primApplyBeanFeature(EStructuralFeature sf, PropertyDecorator propDecor, BeanFeatureDecorator featureDecor, IBeanProxy settingBeanProxy) throws Exception {
        if (sf != this.sfDividerLocation || this.splitPaneManager == null) {
            super.primApplyBeanFeature(sf, propDecor, featureDecor, settingBeanProxy);
        } else {
            this.splitPaneManager.setDividerLocation(settingBeanProxy);
            this.dividerSet = ((IIntegerBeanProxy)settingBeanProxy).intValue() != -1;
        }
    }

    public void childInvalidated(IComponentProxyHost childProxy) {
        if (!this.dividerSet && this.splitPaneManager != null) {
            this.splitPaneManager.resetToPreferredSizes();
        }
        super.childInvalidated(childProxy);
    }

    protected void canceled(EStructuralFeature sf, Object oldValue, int position) {
        if ((sf == this.sfLeftComponent || sf == this.sfRightComponent || sf == this.sfTopComponent || sf == this.sfBottomComponent) && oldValue != null) {
            IBeanProxyHost componentProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaInstance)oldValue));
            IComponentProxyHost componentAdapter = (IComponentProxyHost)componentProxyHost;
            componentAdapter.setParentComponentProxyHost(null);
            super.canceled(sf, oldValue, position);
            componentProxyHost.releaseBeanProxy();
        }
        super.canceled(sf, oldValue, position);
    }
}

