/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyDomain;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jfc.core.ComponentProxyAdapter;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.jfc.core.VisualMessages;

public class JTableProxyAdapter
extends ComponentProxyAdapter {
    protected IMethodProxy fAddColumnMethodProxy;
    protected IMethodProxy fRemoveAllColumnsMethodProxy;
    protected EStructuralFeature sfColumns;
    protected EStructuralFeature sfAutoCreateColumns;

    public JTableProxyAdapter(IBeanProxyDomain domain) {
        super(domain);
        this.sfColumns = JavaInstantiation.getSFeature((ResourceSet)EMFEditDomainHelper.getResourceSet((EditDomain)domain.getEditDomain()), (URI)JFCConstants.SF_JTABLE_COLUMNS);
        this.sfAutoCreateColumns = JavaInstantiation.getSFeature((ResourceSet)EMFEditDomainHelper.getResourceSet((EditDomain)domain.getEditDomain()), (URI)JFCConstants.SF_JTABLE_AUTOCREATECOLUMNSFROMMODEL);
    }

    protected void primInstantiateBeanProxy() {
        IBeanProxy tableModelProxy;
        super.primInstantiateBeanProxy();
        if (this.isBeanProxyInstantiated() && (tableModelProxy = this.getBeanProxy().getTypeProxy().getMethodProxy("getModel").invokeCatchThrowableExceptions(this.getBeanProxy())).getTypeProxy().getTypeName().equals("javax.swing.table.DefaultTableModel")) {
            IBeanTypeProxy previewTypeProxy = this.getBeanProxy().getProxyFactoryRegistry().getBeanTypeProxyFactory().getBeanTypeProxy("org.eclipse.ve.internal.jfc.vm.PreviewTableModel");
            IMethodProxy setModelProxy = this.getBeanProxy().getTypeProxy().getMethodProxy("setModel", "javax.swing.table.TableModel");
            try {
                setModelProxy.invoke(this.getBeanProxy(), previewTypeProxy.newInstance());
            }
            catch (ThrowableProxy exc) {
                JavaVEPlugin.log((Throwable)exc, (int)5);
            }
        }
    }

    protected void applied(EStructuralFeature as, Object newValue, int position) {
        if (!this.isBeanProxyInstantiated()) {
            return;
        }
        if (as == this.sfColumns) {
            this.reapplyColumns();
        } else {
            IBeanProxy newProxy;
            super.applied(as, newValue, position);
            if (this.getErrorStatus() != 3 && as == this.sfAutoCreateColumns && (newProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaInstance)newValue))) instanceof IBooleanBeanProxy) {
                if (!((IBooleanBeanProxy)newProxy).booleanValue()) {
                    this.reapplyColumns();
                } else {
                    if (!((List)this.getEObject().eGet(this.sfColumns)).isEmpty()) {
                        this.processError(this.sfAutoCreateColumns, new IllegalArgumentException(VisualMessages.getString("JTable_ShouldnotSet_EXC_")));
                    }
                    this.revalidateBeanProxy();
                }
            }
        }
    }

    public void reapplyColumns() {
        this.removeColumns();
        this.applyColumns();
        this.revalidateBeanProxy();
    }

    protected void canceled(EStructuralFeature sf, Object oldValue, int position) {
        if (!this.isBeanProxyInstantiated()) {
            return;
        }
        if (sf == this.sfColumns) {
            if (!this.isValidFeature(this.sfAutoCreateColumns) && ((List)this.getEObject().eGet(this.sfColumns)).isEmpty()) {
                this.clearError(this.sfAutoCreateColumns);
                this.reinstantiateBeanProxy();
            } else {
                this.reapplyColumns();
            }
            IBeanProxyHost oldHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaInstance)oldValue));
            if (oldHost != null) {
                oldHost.releaseBeanProxy();
            }
        } else {
            super.canceled(sf, oldValue, position);
            if (this.getErrorStatus() != 3 && sf == this.sfAutoCreateColumns) {
                if (!((List)this.getEObject().eGet(this.sfColumns)).isEmpty()) {
                    this.processError(this.sfAutoCreateColumns, new IllegalArgumentException(VisualMessages.getString("JTable_ShouldnotSet_EXC_")));
                }
                this.revalidateBeanProxy();
            }
        }
    }

    protected void appliedList(EStructuralFeature as, List newValues, int position, boolean testValidity) {
        if (as == this.sfColumns) {
            this.reapplyColumns();
        } else {
            super.appliedList(as, newValues, position, testValidity);
        }
    }

    protected void canceledList(EStructuralFeature as, List oldValues, int position) {
        if (as == this.sfColumns) {
            this.reapplyColumns();
            Iterator itr = oldValues.iterator();
            while (itr.hasNext()) {
                IBeanProxyHost oldHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaInstance)itr.next()));
                if (oldHost == null) continue;
                oldHost.releaseBeanProxy();
            }
        } else {
            super.canceledList(as, oldValues, position);
        }
    }

    protected void applyColumns() {
        boolean apply = this.getErrorStatus() != 3;
        List columns = (List)((EObject)this.getTarget()).eGet(this.sfColumns);
        Iterator iter = columns.iterator();
        while (iter.hasNext()) {
            IJavaObjectInstance column = (IJavaObjectInstance)iter.next();
            IBeanProxyHost columnBeanProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)column);
            columnBeanProxyHost.instantiateBeanProxy();
            if (!apply || columnBeanProxyHost.getErrorStatus() == 3) continue;
            this.getAddColumnMethodProxy().invokeCatchThrowableExceptions(this.getBeanProxy(), columnBeanProxyHost.getBeanProxy());
        }
    }

    protected void removeColumns() {
        if (this.getErrorStatus() == 3) {
            return;
        }
        this.getRemoveAllColumnsMethodProxy().invokeCatchThrowableExceptions(null, this.getBeanProxy());
    }

    protected IMethodProxy getAddColumnMethodProxy() {
        if (this.fAddColumnMethodProxy == null) {
            this.fAddColumnMethodProxy = this.getBeanProxy().getTypeProxy().getMethodProxy("addColumn", "javax.swing.table.TableColumn");
        }
        return this.fAddColumnMethodProxy;
    }

    protected IMethodProxy getRemoveAllColumnsMethodProxy() {
        if (this.fRemoveAllColumnsMethodProxy == null) {
            this.fRemoveAllColumnsMethodProxy = this.getBeanProxy().getProxyFactoryRegistry().getBeanTypeProxyFactory().getBeanTypeProxy("org.eclipse.ve.internal.jfc.vm.JTableManager").getMethodProxy("removeAllColumns", "javax.swing.JTable");
        }
        return this.fRemoveAllColumnsMethodProxy;
    }

    public void releaseBeanProxy() {
        super.releaseBeanProxy();
        if (this.fRemoveAllColumnsMethodProxy != null) {
            this.fRemoveAllColumnsMethodProxy.getProxyFactoryRegistry().releaseProxy((IBeanProxy)this.fRemoveAllColumnsMethodProxy);
            this.fRemoveAllColumnsMethodProxy = null;
        }
        if (this.fAddColumnMethodProxy != null) {
            this.fAddColumnMethodProxy.getProxyFactoryRegistry().releaseProxy((IBeanProxy)this.fAddColumnMethodProxy);
            this.fAddColumnMethodProxy = null;
        }
    }
}

