/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class JVESpinner
extends Composite {
    static final int BUTTON_WIDTH = 16;
    protected Text text;
    protected Button up;
    protected Button down;
    protected int minimum;
    protected int maximum;
    protected int fValue = 0;
    protected boolean commandInProcess = false;
    private boolean settingText = false;

    public JVESpinner(Composite parent, int style, int initialValue) {
        super(parent, style);
        this.text = new Text((Composite)this, style | 4 | 0x800);
        this.up = new Button((Composite)this, style | 4 | 0x80);
        this.down = new Button((Composite)this, style | 4 | 0x400);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    JVESpinner.this.setValue(Integer.parseInt(JVESpinner.this.text.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    JVESpinner.this.setTextField();
                }
            }
        });
        this.text.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                JVESpinner.this.traverse(e);
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                JVESpinner.this.text.selectAll();
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                JVESpinner.this.text.selectAll();
            }
        });
        this.up.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JVESpinner.this.up();
            }
        });
        this.down.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JVESpinner.this.down();
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                JVESpinner.this.resize();
            }
        });
        this.minimum = 0;
        this.maximum = 999;
        this.text.setFont(this.getFont());
        this.fValue = initialValue;
        this.setTextField();
    }

    void traverse(Event e) {
        switch (e.detail) {
            case 32: {
                if (e.keyCode != 0x1000001) break;
                e.doit = true;
                e.detail = 0;
                this.up();
                break;
            }
            case 64: {
                if (e.keyCode != 0x1000002) break;
                e.doit = true;
                e.detail = 0;
                this.down();
            }
        }
    }

    void up() {
        this.setValue(this.getValue() + 1);
    }

    void down() {
        this.setValue(this.getValue() - 1);
    }

    void focusIn() {
        this.text.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.text.setFont(font);
    }

    public void setValue(int value) {
        if (this.commandInProcess) {
            return;
        }
        try {
            Integer.parseInt(String.valueOf(value));
            if (value < this.minimum || value > this.maximum) {
                this.setTextField();
                return;
            }
            if (this.fValue == value) {
                return;
            }
            this.fValue = value;
            this.setTextField();
            this.commandInProcess = true;
            this.notifyListeners(24, new Event());
        }
        catch (NumberFormatException numberFormatException) {
            this.setTextField();
        }
    }

    public int getValue() {
        return Integer.parseInt(this.text.getText());
    }

    protected void setTextField() {
        if (!this.settingText) {
            this.settingText = true;
            String valueString = String.valueOf(this.fValue);
            this.text.setText(valueString);
            this.text.setSelection(valueString.length());
            this.settingText = false;
        }
    }

    public void setMaximum(int maximum) {
        this.checkWidget();
        this.maximum = maximum;
        this.resize();
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    void resize() {
        Point pt = this.computeSize(-1, -1);
        int textWidth = pt.x - 16;
        int buttonHeight = pt.y / 2;
        this.text.setBounds(0, 0, textWidth, pt.y);
        this.up.setBounds(textWidth, 0, 16, buttonHeight);
        this.down.setBounds(textWidth, pt.y - buttonHeight, 16, buttonHeight);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        GC gc = new GC((Drawable)this.text);
        Point textExtent = gc.textExtent(String.valueOf(this.maximum));
        gc.dispose();
        Point pt = this.text.computeSize(textExtent.x, textExtent.y);
        int width = pt.x + 16;
        int height = pt.y;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    public void addModifyListener(Listener listener) {
        if (listener != null) {
            this.addListener(24, listener);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.text != null && this.text.getEnabled() != enabled) {
            this.text.setEnabled(enabled);
        }
        if (this.up != null && this.up.getEnabled() != enabled) {
            this.up.setEnabled(enabled);
        }
        if (this.down != null && this.down.getEnabled() != enabled) {
            this.down.setEnabled(enabled);
        }
        if (enabled) {
            this.commandInProcess = false;
        }
    }
}

