/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.adapters;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoClassAdapter;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoSuperAdapter;
import org.eclipse.jem.internal.beaninfo.adapters.IBeaninfoSupplier;
import org.eclipse.jem.internal.java.beaninfo.IIntrospectionAdapter;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;

public class BeaninfoAdapterFactory
extends AdapterFactoryImpl {
    protected IBeaninfoSupplier fInfoSupplier;
    private Map fIntrospected = new HashMap();
    private ReferenceQueue fRefQ = new ReferenceQueue();

    public BeaninfoAdapterFactory(IBeaninfoSupplier supplier) {
        this.fInfoSupplier = supplier;
    }

    public Adapter createAdapter(Notifier target, Object type) {
        if (type == IIntrospectionAdapter.ADAPTER_KEY) {
            return new BeaninfoClassAdapter(this);
        }
        return new BeaninfoSuperAdapter();
    }

    public boolean isFactoryForType(Object type) {
        return IIntrospectionAdapter.ADAPTER_KEY == type || BeaninfoSuperAdapter.ADAPTER_KEY == type;
    }

    public ProxyFactoryRegistry getRegistry() {
        return this.fInfoSupplier.getRegistry();
    }

    public boolean isRegistryCreated() {
        return this.fInfoSupplier.isRegistryCreated();
    }

    public ProxyFactoryRegistry recycleRegistry() {
        this.markAllStale();
        return this.getRegistry();
    }

    public void closeAll(boolean clearResults) {
        this.processQueue();
        BeaninfoAdapterFactory beaninfoAdapterFactory = this;
        synchronized (beaninfoAdapterFactory) {
            Map intr = this.fIntrospected;
            this.fIntrospected = Collections.EMPTY_MAP;
            Iterator i = intr.values().iterator();
            while (i.hasNext()) {
                Notifier notifier;
                BeaninfoClassAdapter a = (BeaninfoClassAdapter)((Object)((WeakValue)i.next()).get());
                if (a == null) continue;
                if (clearResults) {
                    a.clearIntrospection();
                }
                if ((notifier = a.getTarget()) == null) continue;
                notifier.eAdapters().remove((Object)a);
            }
        }
    }

    public void markAllStale() {
        ProxyFactoryRegistry fact = this.isRegistryCreated() ? this.getRegistry() : null;
        this.processQueue();
        BeaninfoAdapterFactory beaninfoAdapterFactory = this;
        synchronized (beaninfoAdapterFactory) {
            Iterator i = this.fIntrospected.values().iterator();
            while (i.hasNext()) {
                BeaninfoClassAdapter a = (BeaninfoClassAdapter)((Object)((WeakValue)i.next()).get());
                if (a == null) continue;
                a.markStaleFactory(fact);
            }
            this.fInfoSupplier.closeRegistry();
        }
    }

    public void markStaleIntrospection(String sourceName, boolean clearResults) {
        this.processQueue();
        BeaninfoAdapterFactory beaninfoAdapterFactory = this;
        synchronized (beaninfoAdapterFactory) {
            BeaninfoClassAdapter a;
            WeakValue ref = (WeakValue)this.fIntrospected.get(sourceName);
            if (ref != null && (a = (BeaninfoClassAdapter)((Object)ref.get())) != null) {
                if (clearResults) {
                    a.clearIntrospection();
                }
                a.markStaleFactory(this.isRegistryCreated() ? this.getRegistry() : null);
            }
        }
    }

    public void registerIntrospection(String sourceName, BeaninfoClassAdapter adapter) {
        this.processQueue();
        BeaninfoAdapterFactory beaninfoAdapterFactory = this;
        synchronized (beaninfoAdapterFactory) {
            this.fIntrospected.put(sourceName, new WeakValue(sourceName, (Object)adapter, this.fRefQ));
        }
    }

    public void unregisterIntrospection(String sourceName) {
        this.processQueue();
        BeaninfoAdapterFactory beaninfoAdapterFactory = this;
        synchronized (beaninfoAdapterFactory) {
            WeakValue ref = (WeakValue)this.fIntrospected.remove(sourceName);
            if (ref != null) {
                BeaninfoClassAdapter a = (BeaninfoClassAdapter)((Object)ref.get());
                a.clearIntrospection();
                a.getTarget().eAdapters().remove((Object)a);
            }
        }
    }

    public void unregisterIntrospectionPlusInner(String sourceName) {
        this.processQueue();
        String sourceNameForInner = String.valueOf(sourceName) + '$';
        BeaninfoAdapterFactory beaninfoAdapterFactory = this;
        synchronized (beaninfoAdapterFactory) {
            Iterator itr = this.fIntrospected.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                String entryName = (String)entry.getKey();
                if (!entryName.equals(sourceName) && !entryName.startsWith(sourceNameForInner)) continue;
                WeakValue ref = (WeakValue)entry.getValue();
                itr.remove();
                BeaninfoClassAdapter a = (BeaninfoClassAdapter)((Object)ref.get());
                a.clearIntrospection();
                a.getTarget().eAdapters().remove((Object)a);
            }
        }
    }

    public synchronized void removeAdapter(BeaninfoClassAdapter a) {
        this.fIntrospected.remove(a.getJavaClass().getQualifiedNameForReflection());
    }

    private synchronized void processQueue() {
        WeakValue wv;
        while ((wv = (WeakValue)this.fRefQ.poll()) != null) {
            this.fIntrospected.remove(wv.getKey());
        }
    }

    private static class WeakValue
    extends WeakReference {
        private Object key;

        public WeakValue(Object aKey, Object value, ReferenceQueue que) {
            super(value, que);
            this.key = aKey;
        }

        public Object getKey() {
            return this.key;
        }
    }
}

