/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.adapters;

import com.ibm.etools.emf.event.EventFactory;
import com.ibm.etools.emf.event.EventUtil;
import java.beans.Introspector;
import java.io.FileNotFoundException;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.ESuperAdapter;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jem.internal.beaninfo.BeanDecorator;
import org.eclipse.jem.internal.beaninfo.BeanEvent;
import org.eclipse.jem.internal.beaninfo.BeaninfoFactory;
import org.eclipse.jem.internal.beaninfo.BeaninfoPackage;
import org.eclipse.jem.internal.beaninfo.EventSetDecorator;
import org.eclipse.jem.internal.beaninfo.FeatureDecorator;
import org.eclipse.jem.internal.beaninfo.IndexedPropertyDecorator;
import org.eclipse.jem.internal.beaninfo.MethodDecorator;
import org.eclipse.jem.internal.beaninfo.MethodProxy;
import org.eclipse.jem.internal.beaninfo.PropertyDecorator;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoAdapterFactory;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoPlugin;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoProxyConstants;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoSuperAdapter;
import org.eclipse.jem.internal.beaninfo.adapters.Utilities;
import org.eclipse.jem.internal.java.ArrayType;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.jem.internal.java.JavaEvent;
import org.eclipse.jem.internal.java.JavaHelpers;
import org.eclipse.jem.internal.java.JavaParameter;
import org.eclipse.jem.internal.java.JavaRefFactory;
import org.eclipse.jem.internal.java.JavaRefPackage;
import org.eclipse.jem.internal.java.Method;
import org.eclipse.jem.internal.java.TypeKind;
import org.eclipse.jem.internal.java.beaninfo.IIntrospectionAdapter;
import org.eclipse.jem.internal.java.impl.JavaClassImpl;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;

public class BeaninfoClassAdapter
extends AdapterImpl
implements IIntrospectionAdapter {
    protected static final URI BAD_URI = URI.createURI((String)"baduri");
    protected boolean hasIntrospected;
    protected boolean isIntrospecting;
    protected boolean hasIntrospectedProperties;
    protected boolean isIntrospectingProperties;
    protected boolean isDoingAllProperties;
    protected boolean hasIntrospectedOperations;
    protected boolean isIntrospectingOperations;
    protected boolean isDoingAllOperations;
    protected boolean hasIntrospectedEvents;
    protected boolean isIntrospectingEvents;
    protected boolean isDoingAllEvents;
    protected static final int NEVER_RETRIEVED_EXTENSION_DOCUMENT = 0;
    protected static final int RETRIEVED_ROOT_ONLY = 1;
    protected static final int RETRIEVED_FULL_DOCUMENT = 2;
    protected int retrievedExtensionDocument = 0;
    protected IBeanProxy beaninfo;
    protected BeaninfoAdapterFactory adapterFactory;
    private WeakReference staleFactory;
    private HashMap propertiesMap;
    private List attributesRealList;
    private List referencesRealList;
    private HashMap operationsMap;
    private EList operationsRealList;
    private HashSet newoperations;
    private HashMap eventsMap;
    private EList eventsRealList;
    private Boolean defaultBound;
    private static final String OVERRIDE_EXTENSION = ".override";
    private static final String ROOT = "..ROOT..";
    private static final String ROOT_OVERRIDE = "..ROOT...override";
    private JavaClass eventListenerClass;
    private JavaClass tooManyExceptionClass;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void clearIntrospection() {
        EAnnotation dec;
        if (this.beaninfo != null) {
            this.beaninfo = null;
        }
        if (this.hasIntrospected) {
            Iterator beanItr = this.getJavaClass().getEAnnotations().iterator();
            while (beanItr.hasNext()) {
                EAnnotation dec2 = (EAnnotation)beanItr.next();
                if (!(dec2 instanceof BeanDecorator)) continue;
                BeanDecorator decor = (BeanDecorator)dec2;
                decor.setDescriptorProxy(null);
                decor.setDecoratorProxy(null);
                if (decor.isImplicitlyCreated() != 1) continue;
                beanItr.remove();
                ((InternalEObject)decor).eSetProxyURI(BAD_URI);
                break;
            }
        }
        if (this.hasIntrospectedProperties) {
            PropertyDecorator pd;
            Iterator pdItr;
            EAttribute prop;
            Iterator propItr = this.getJavaClass().getEAttributesGen().iterator();
            block1: while (propItr.hasNext()) {
                prop = (EAttribute)propItr.next();
                pdItr = prop.getEAnnotations().iterator();
                while (pdItr.hasNext()) {
                    dec = (EAnnotation)pdItr.next();
                    if (!(dec instanceof PropertyDecorator)) continue;
                    pd = (PropertyDecorator)dec;
                    pd.setDescriptorProxy(null);
                    pd.setDecoratorProxy(null);
                    if (pd.isImplicitlyCreated() != 0) {
                        pdItr.remove();
                        ((InternalEObject)pd).eSetProxyURI(BAD_URI);
                    }
                    if (pd.isImplicitlyCreated() != 3) continue block1;
                    propItr.remove();
                    ((InternalEObject)prop).eSetProxyURI(BAD_URI);
                    continue block1;
                }
            }
            propItr = this.getJavaClass().getEReferencesGen().iterator();
            block3: while (propItr.hasNext()) {
                prop = (EReference)propItr.next();
                pdItr = prop.getEAnnotations().iterator();
                while (pdItr.hasNext()) {
                    dec = (EAnnotation)pdItr.next();
                    if (!(dec instanceof PropertyDecorator)) continue;
                    pd = (PropertyDecorator)dec;
                    pd.setDescriptorProxy(null);
                    pd.setDecoratorProxy(null);
                    if (pd.isImplicitlyCreated() != 0) {
                        pdItr.remove();
                        ((InternalEObject)pd).eSetProxyURI(BAD_URI);
                    }
                    if (pd.isImplicitlyCreated() != 3) continue block3;
                    propItr.remove();
                    ((InternalEObject)prop).eSetProxyURI(BAD_URI);
                    continue block3;
                }
            }
            this.hasIntrospectedProperties = false;
        }
        if (this.hasIntrospectedOperations) {
            Iterator operItr = this.getJavaClass().getEOperationsGen().iterator();
            block5: while (operItr.hasNext()) {
                EOperation oper = (EOperation)operItr.next();
                Iterator mdItr = oper.getEAnnotations().iterator();
                while (mdItr.hasNext()) {
                    dec = (EAnnotation)mdItr.next();
                    if (!(dec instanceof MethodDecorator)) continue;
                    MethodDecorator md = (MethodDecorator)dec;
                    md.setDescriptorProxy(null);
                    md.setDecoratorProxy(null);
                    if (md.isImplicitlyCreated() != 0) {
                        mdItr.remove();
                        ((InternalEObject)md).eSetProxyURI(BAD_URI);
                    }
                    if (md.isImplicitlyCreated() != 3) continue block5;
                    operItr.remove();
                    ((InternalEObject)oper).eSetProxyURI(BAD_URI);
                    continue block5;
                }
            }
            this.hasIntrospectedOperations = false;
        }
        if (this.hasIntrospectedEvents) {
            Iterator evtItr = this.getJavaClass().getEventsGen().iterator();
            block7: while (evtItr.hasNext()) {
                JavaEvent evt = (JavaEvent)evtItr.next();
                Iterator edItr = evt.getEAnnotations().iterator();
                while (edItr.hasNext()) {
                    dec = (EAnnotation)edItr.next();
                    if (!(dec instanceof EventSetDecorator)) continue;
                    EventSetDecorator ed = (EventSetDecorator)dec;
                    ed.setDescriptorProxy(null);
                    ed.setDecoratorProxy(null);
                    if (ed.isImplicitlyCreated() != 0) {
                        edItr.remove();
                        ((InternalEObject)ed).eSetProxyURI(BAD_URI);
                    }
                    if (ed.isImplicitlyCreated() != 3) continue block7;
                    evtItr.remove();
                    ((InternalEObject)evt).eSetProxyURI(BAD_URI);
                    continue block7;
                }
            }
            this.hasIntrospectedEvents = false;
        }
    }

    private void clearAll() {
        if (this.beaninfo != null) {
            this.beaninfo = null;
        }
        this.getJavaClass().getEAnnotations().clear();
        this.getJavaClass().getEAttributesGen().clear();
        this.getJavaClass().getEReferencesGen().clear();
        this.getJavaClass().getEOperationsGen().clear();
        this.getJavaClass().getEventsGen().clear();
    }

    public BeaninfoClassAdapter(BeaninfoAdapterFactory factory) {
        this.adapterFactory = factory;
    }

    protected boolean isResourceConnected() {
        Resource res = this.getJavaClass().eResource();
        return res != null && res.isLoaded();
    }

    protected final ProxyFactoryRegistry getRegistry() {
        ProxyFactoryRegistry factory = this.adapterFactory.getRegistry();
        if (this.staleFactory != null && factory == this.staleFactory.get()) {
            factory = this.adapterFactory.recycleRegistry();
        }
        this.staleFactory = null;
        return factory;
    }

    public boolean isStale() {
        return this.staleFactory != null;
    }

    protected BeaninfoAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public boolean isAdapterForType(Object key) {
        return IIntrospectionAdapter.ADAPTER_KEY.equals(key);
    }

    protected HashMap getPropertiesMap() {
        if (this.propertiesMap == null) {
            List localAttrs = (List)this.getJavaClass().getEAttributesGen();
            List localRefs = (List)this.getJavaClass().getEReferencesGen();
            this.propertiesMap = new HashMap(localAttrs.size() + localRefs.size());
            Iterator itr = localAttrs.iterator();
            while (itr.hasNext()) {
                EAttribute attr = (EAttribute)itr.next();
                this.propertiesMap.put(attr.getName(), attr);
            }
            itr = localRefs.iterator();
            while (itr.hasNext()) {
                EReference ref = (EReference)itr.next();
                this.propertiesMap.put(ref.getName(), ref);
            }
        }
        return this.propertiesMap;
    }

    protected List getAttributesList() {
        if (this.attributesRealList == null) {
            this.attributesRealList = (List)this.getJavaClass().getEAttributesGen();
        }
        return this.attributesRealList;
    }

    protected List getReferencesList() {
        if (this.referencesRealList == null) {
            this.referencesRealList = (List)this.getJavaClass().getEReferencesGen();
        }
        return this.referencesRealList;
    }

    protected HashMap getOperationsMap() {
        if (this.operationsMap == null) {
            List locals = (List)this.getJavaClass().getEOperationsGen();
            int l = locals.size();
            this.operationsMap = new HashMap(l);
            int i = 0;
            while (i < l) {
                EOperation op = (EOperation)locals.get(i);
                this.operationsMap.put(this.formLongName(op), op);
                ++i;
            }
        }
        return this.operationsMap;
    }

    protected EList getOperationsList() {
        if (this.operationsRealList == null) {
            this.operationsRealList = this.getJavaClass().getEOperationsGen();
        }
        return this.operationsRealList;
    }

    protected HashMap getEventsMap() {
        if (this.eventsMap == null) {
            List locals = (List)this.getJavaClass().getEventsGen();
            this.eventsMap = new HashMap(locals.size());
            Iterator itr = locals.iterator();
            while (itr.hasNext()) {
                JavaEvent event = (JavaEvent)itr.next();
                this.eventsMap.put(event.getName(), event);
            }
        }
        return this.eventsMap;
    }

    protected EList getEventsList() {
        if (this.eventsRealList == null) {
            this.eventsRealList = this.getJavaClass().getEventsGen();
        }
        return this.eventsRealList;
    }

    public void introspectIfNecessary() {
        if (!this.hasIntrospected && !this.isIntrospecting) {
            try {
                this.introspect();
            }
            catch (Throwable e) {
                this.hasIntrospected = false;
                BeaninfoPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, BeaninfoPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, MessageFormat.format(BeaninfoPlugin.getPlugin().getDescriptor().getResourceString("%INTROSPECT_FAILED_EXC_ Introspection failed on class \"{0}.\""), this.getJavaClass().getJavaName()), e));
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void introspect() {
        this.isIntrospecting = true;
        try {
            if (this.isResourceConnected()) {
                if (this.getJavaClass().getKind() == TypeKind.UNDEFINED_LITERAL) {
                    if (this.retrievedExtensionDocument == 2) {
                        this.clearAll();
                        this.retrievedExtensionDocument = 0;
                    }
                    if (this.retrievedExtensionDocument == 0) {
                        this.applyExtensionDocument(true);
                    }
                    this.hasIntrospectedEvents = true;
                    this.hasIntrospectedProperties = true;
                    this.hasIntrospectedOperations = true;
                    this.hasIntrospected = true;
                } else {
                    BeanDecorator decor;
                    if (this.retrievedExtensionDocument == 1) {
                        this.clearAll();
                    }
                    if (this.retrievedExtensionDocument != 2) {
                        this.applyExtensionDocument(false);
                    }
                    if ((decor = Utilities.getBeanDecorator((EModelElement)this.getJavaClass())) == null || decor.isDoBeaninfo()) {
                        IBeanTypeProxy targetType = null;
                        ProxyFactoryRegistry registry = this.getRegistry();
                        if (registry != null && registry.isValid()) {
                            targetType = registry.getBeanTypeProxyFactory().getBeanTypeProxy(this.getJavaClass().getQualifiedNameForReflection());
                        }
                        if (targetType != null) {
                            if (targetType.getInitializationError() == null) {
                                try {
                                    this.beaninfo = this.getProxyConstants().getIntrospectProxy().invoke(null, new IBeanProxy[]{targetType, this.getRegistry().getBeanProxyFactory().createBeanProxyWith(false)});
                                }
                                catch (ThrowableProxy e) {
                                    BeaninfoPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, BeaninfoPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, MessageFormat.format(BeaninfoPlugin.getPlugin().getDescriptor().getResourceString("%INTROSPECT_FAILED_EXC_ Introspection failed on class \"{0}.\""), this.getJavaClass().getJavaName()), (Throwable)e));
                                }
                            } else {
                                BeaninfoPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, BeaninfoPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, MessageFormat.format(BeaninfoPlugin.getPlugin().getDescriptor().getResourceString("%INTROSPECT_FAILED_EXC_ Introspection failed on class \"{0}.\""), this.getJavaClass().getJavaName()), (Throwable)new ExceptionInInitializerError(targetType.getInitializationError())));
                            }
                        } else {
                            BeaninfoPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, BeaninfoPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, MessageFormat.format(BeaninfoPlugin.getPlugin().getDescriptor().getResourceString("%INTROSPECT_FAILED_EXC_ Introspection failed on class \"{0}.\""), this.getJavaClass().getJavaName()), null));
                        }
                    }
                    this.calculateBeanDescriptor(decor);
                    this.hasIntrospected = true;
                }
                this.getAdapterFactory().registerIntrospection(this.getJavaClass().getQualifiedNameForReflection(), this);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.isIntrospecting = false;
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.isIntrospecting = false;
            return;
        }
    }

    protected void applyExtensionDocument(boolean rootOnly) {
        boolean alreadyRetrievedRoot = this.retrievedExtensionDocument == 1;
        this.retrievedExtensionDocument = rootOnly ? 1 : 2;
        JavaClassImpl jc = this.getJavaClass();
        Resource mergeIntoResource = jc.eResource();
        ResourceSet rset = mergeIntoResource.getResourceSet();
        if (!alreadyRetrievedRoot && (rootOnly || jc.getSupertype() == null)) {
            BeaninfoPlugin.OverridePathSearch searcher = BeaninfoPlugin.getPlugin().getOverrideSearch(ROOT);
            this.applyExtensionDocTo(rset, (EObject)jc, ROOT_OVERRIDE, searcher);
            if (rootOnly) {
                return;
            }
        }
        String baseOverridefile = String.valueOf(this.getJavaClass().getName()) + OVERRIDE_EXTENSION;
        BeaninfoPlugin.OverridePathSearch searcher = BeaninfoPlugin.getPlugin().getOverrideSearch(this.getJavaClass().getJavaPackage().getPackageName());
        this.applyExtensionDocTo(rset, (EObject)jc, baseOverridefile, searcher);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void applyExtensionDocTo(ResourceSet rset, EObject mergeIntoEObject, String baseOverridefile, BeaninfoPlugin.OverridePathSearch searcher) {
        String[] paths = searcher.getNextPath();
        block6: while (paths != null) {
            String overridepath = searcher.getUnmatchedPath();
            String overridefile = baseOverridefile;
            if (overridepath.length() > 0) {
                overridefile = String.valueOf(overridepath) + '/' + overridefile;
            }
            int i = 0;
            while (true) {
                block13: {
                    Object var13_15;
                    if (i >= paths.length) {
                        paths = searcher.getNextPath();
                        continue block6;
                    }
                    String filename = String.valueOf(paths[i]) + overridefile;
                    Resource overrideRes = null;
                    URI uri = URI.createURI((String)filename);
                    try {
                        try {
                            overrideRes = rset.getResource(uri, true);
                            EventUtil util = EventFactory.eINSTANCE.createEventUtil((Notifier)mergeIntoEObject, rset);
                            util.doForwardEvents((List)overrideRes.getContents());
                        }
                        catch (WrappedException e) {
                            if (!(e.exception() instanceof FileNotFoundException || e.exception() instanceof CoreException && ((CoreException)e.exception()).getStatus().getCode() == 368)) {
                                BeaninfoPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, "org.eclipse.jem.beaninfo", 0, "Error loading file\"" + filename + "\"", (Throwable)e.exception()));
                            }
                            overrideRes = rset.getResource(uri, false);
                        }
                        catch (Exception e) {
                            BeaninfoPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, "org.eclipse.jem.beaninfo", 0, "Error loading file\"" + filename + "\"", (Throwable)e));
                            overrideRes = rset.getResource(uri, false);
                        }
                    }
                    catch (Throwable throwable) {
                        var13_15 = null;
                        if (overrideRes != null) {
                            rset.getResources().remove(overrideRes);
                        }
                        throw throwable;
                    }
                    {
                        var13_15 = null;
                        if (overrideRes == null) break block13;
                        rset.getResources().remove(overrideRes);
                    }
                }
                ++i;
            }
            break;
        }
        return;
    }

    protected JavaClassImpl getJavaClass() {
        return (JavaClassImpl)this.getTarget();
    }

    protected BeaninfoProxyConstants getProxyConstants() {
        return BeaninfoProxyConstants.getConstants(this.getRegistry());
    }

    public EList getEAttributes() {
        this.introspectProperties();
        return this.getJavaClass().getEAttributesGen();
    }

    public EList getEReferences() {
        this.introspectProperties();
        return this.getJavaClass().getEReferencesGen();
    }

    public EList getAllProperties() {
        return this.allProperties();
    }

    public EList getEOperations() {
        return this.introspectOperations();
    }

    public BasicEList getEAllOperations() {
        return this.allOperations();
    }

    public EList getEvents() {
        return this.introspectEvents();
    }

    public EList getAllEvents() {
        return this.allEvents();
    }

    protected void calculateBeanDescriptor(BeanDecorator decor) {
        if (decor == null) {
            decor = BeaninfoFactory.eINSTANCE.createBeanDecorator();
            decor.setImplicitlyCreated(1);
            this.getJavaClass().getEAnnotations().add(decor);
        }
        if (this.beaninfo != null && decor.isMergeIntrospection()) {
            decor.setDescriptorProxy(this.getProxyConstants().getBeanDescriptorProxy().invokeCatchThrowableExceptions(this.beaninfo));
            decor.setMergeSuperPropertiesProxy(((IBooleanBeanProxy)this.getProxyConstants().getIsMergeInheritedPropertiesProxy().invokeCatchThrowableExceptions(this.beaninfo)).getBooleanValue());
            decor.setMergeSuperBehaviorsProxy(((IBooleanBeanProxy)this.getProxyConstants().getIsMergeInheritedMethodsProxy().invokeCatchThrowableExceptions(this.beaninfo)).getBooleanValue());
            decor.setMergeSuperEventsProxy(((IBooleanBeanProxy)this.getProxyConstants().getIsMergeInheritedEventsProxy().invokeCatchThrowableExceptions(this.beaninfo)).getBooleanValue());
        } else {
            decor.setDescriptorProxy(null);
            decor.setMergeSuperEventsProxy(null);
            decor.setMergeSuperPropertiesProxy(null);
            decor.setMergeSuperBehaviorsProxy(null);
        }
        decor.setDecoratorProxy(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void introspectProperties() {
        this.introspectIfNecessary();
        if (this.isIntrospecting) return;
        if (this.isIntrospectingProperties) return;
        if (this.hasIntrospectedProperties) return;
        this.isIntrospectingProperties = true;
        try {
            if (this.isResourceConnected()) {
                int implicit;
                Object aOld;
                PropertyDecorator p;
                BeanDecorator bd = Utilities.getBeanDecorator((EModelElement)this.getJavaClass());
                if (bd == null || bd.isIntrospectProperties()) {
                    if (this.beaninfo != null) {
                        IArrayBeanProxy props = (IArrayBeanProxy)this.getProxyConstants().getPropertyDescriptorsProxy().invokeCatchThrowableExceptions(this.beaninfo);
                        if (props != null) {
                            int propSize = props.getLength();
                            int i = 0;
                            while (i < propSize) {
                                this.calculateProperty(props.getCatchThrowableException(i));
                                ++i;
                            }
                        }
                    } else {
                        this.reflectProperties();
                    }
                }
                HashMap oldLocals = this.getPropertiesMap();
                Iterator itr = this.getAttributesList().iterator();
                while (true) {
                    if (!itr.hasNext()) {
                        itr = this.getJavaClass().getEReferencesGen().iterator();
                        break;
                    }
                    EStructuralFeature a = (EStructuralFeature)itr.next();
                    p = Utilities.getPropertyDecorator((EModelElement)a);
                    aOld = oldLocals.get(a.getName());
                    if (aOld == null || aOld == Boolean.FALSE || p == null) continue;
                    implicit = p.isImplicitlyCreated();
                    if (implicit != 0) {
                        p.setEModelElement(null);
                        ((InternalEObject)p).eSetProxyURI(BAD_URI);
                        p = null;
                    }
                    if (implicit != 3) continue;
                    itr.remove();
                    ((InternalEObject)a).eSetProxyURI(BAD_URI);
                }
                while (itr.hasNext()) {
                    EStructuralFeature a = (EStructuralFeature)itr.next();
                    p = Utilities.getPropertyDecorator((EModelElement)a);
                    aOld = oldLocals.get(a.getName());
                    if (aOld == null || aOld == Boolean.FALSE || p == null) continue;
                    implicit = p.isImplicitlyCreated();
                    if (implicit != 0) {
                        p.setEModelElement(null);
                        ((InternalEObject)p).eSetProxyURI(BAD_URI);
                        p = null;
                    }
                    if (implicit != 3) continue;
                    itr.remove();
                    ((InternalEObject)a).eSetProxyURI(BAD_URI);
                }
            }
            this.hasIntrospectedProperties = true;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            this.isIntrospectingProperties = false;
            this.propertiesMap = null;
            this.referencesRealList = null;
            this.attributesRealList = null;
            throw throwable;
        }
        {
            Object var8_13 = null;
            this.isIntrospectingProperties = false;
            this.propertiesMap = null;
            this.referencesRealList = null;
            this.attributesRealList = null;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected EList allProperties() {
        EList jcAllProperties = this.getJavaClass().getAllPropertiesGen();
        JavaClassImpl javaClassImpl = this.getJavaClass();
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("[Lorg.eclipse.jem.internal.beaninfo.adapters.BeaninfoSuperAdapter;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        BeaninfoSuperAdapter superAdapter = (BeaninfoSuperAdapter)EcoreUtil.getRegisteredAdapter((EObject)javaClassImpl, (Object)clazz);
        if (!(jcAllProperties == null || superAdapter != null && superAdapter.isAllPropertiesCollectionModified())) {
            return jcAllProperties;
        }
        UniqueEList allProperties = new UniqueEList(){

            protected Object[] newData(int capacity) {
                return new EStructuralFeature[capacity];
            }

            protected boolean useEquals() {
                return false;
            }
        };
        if (!this.isIntrospecting && !this.isDoingAllProperties && this.isResourceConnected()) {
            this.isDoingAllProperties = true;
            try {
                EList localProperties = this.getJavaClass().getProperties();
                JavaClass superType = this.getJavaClass().getSupertype();
                if (superType != null) {
                    boolean mergeAll;
                    BeanDecorator bd = Utilities.getBeanDecorator((EModelElement)this.getJavaClass());
                    EList supers = superType.getAllProperties();
                    boolean bl = mergeAll = bd == null || bd.isMergeSuperProperties();
                    if (!mergeAll) {
                        int len = supers.size();
                        int i = 0;
                        while (i < len) {
                            EStructuralFeature p = (EStructuralFeature)supers.get(i);
                            PropertyDecorator pd = Utilities.getPropertyDecorator((EModelElement)p);
                            if (pd == null || pd.isImplicitlyCreated() == 0 && !pd.isMergeIntrospection()) {
                                allProperties.add((Object)p);
                            }
                            ++i;
                        }
                    } else if (this.beaninfo != null) {
                        IArrayBeanProxy superNames = (IArrayBeanProxy)this.getProxyConstants().getInheritedPropertyDescriptorsProxy().invokeCatchThrowableExceptions(this.beaninfo);
                        if (superNames != null) {
                            int i;
                            int len;
                            int l = superNames.getLength();
                            HashSet<String> superSet = new HashSet<String>(l);
                            int i2 = 0;
                            while (true) {
                                if (i2 >= l) {
                                    len = supers.size();
                                    i = 0;
                                    break;
                                }
                                superSet.add(((IStringBeanProxy)superNames.getCatchThrowableException(i2)).stringValue());
                                ++i2;
                            }
                            while (i < len) {
                                EStructuralFeature p = (EStructuralFeature)supers.get(i);
                                PropertyDecorator pd = Utilities.getPropertyDecorator((EModelElement)p);
                                if (pd == null || pd.isImplicitlyCreated() == 0 && !pd.isMergeIntrospection() || superSet.contains(pd.getName())) {
                                    allProperties.add((Object)p);
                                }
                                ++i;
                            }
                        } else {
                            allProperties.addAll((Collection)supers);
                        }
                    } else {
                        allProperties.addAll((Collection)supers);
                    }
                }
                allProperties.addAll((Collection)localProperties);
                superAdapter.setAllPropertiesCollectionModified(false);
            }
            catch (Throwable throwable) {
                Object var16_21 = null;
                this.isDoingAllProperties = false;
                throw throwable;
            }
            {
                Object var16_22 = null;
                this.isDoingAllProperties = false;
            }
        }
        allProperties.shrink();
        return new EcoreEList.UnmodifiableEList((InternalEObject)this.getJavaClass(), null, allProperties.size(), allProperties.data());
    }

    protected void calculateProperty(IBeanProxy propDesc) {
        boolean indexed = propDesc.getProxyFactoryRegistry().getBeanTypeProxyFactory().getBeanTypeProxy("java.beans.IndexedPropertyDescriptor").equals((Object)propDesc.getTypeProxy());
        String name = ((IStringBeanProxy)this.getProxyConstants().getNameProxy().invokeCatchThrowableExceptions(propDesc)).stringValue();
        EClassifier type = null;
        boolean changeable = this.getProxyConstants().getWriteMethodProxy().invokeCatchThrowableExceptions(propDesc) != null;
        IBeanTypeProxy typeProxy = (IBeanTypeProxy)this.getProxyConstants().getPropertyTypeProxy().invokeCatchThrowableExceptions(propDesc);
        if (typeProxy != null) {
            type = Utilities.getJavaClass(typeProxy, this.getJavaClass().eResource().getResourceSet());
        }
        if (indexed) {
            if (!changeable) {
                boolean bl = changeable = this.getProxyConstants().getIndexedWriteMethodProxy().invokeCatchThrowableExceptions(propDesc) != null;
            }
            if (typeProxy == null && (typeProxy = (IBeanTypeProxy)this.getProxyConstants().getIndexedPropertyTypeProxy().invokeCatchThrowableExceptions(propDesc)) != null) {
                typeProxy = typeProxy.getProxyFactoryRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(typeProxy.getTypeName(), 1);
                type = Utilities.getJavaClass(typeProxy, this.getJavaClass().eResource().getResourceSet());
            }
        }
        if (type != null) {
            this.createProperty(name, indexed, changeable, type, propDesc);
        }
    }

    public PropertyDecorator createProperty(String name, boolean indexed, boolean changeable, EClassifier type, IBeanProxy propDesc) {
        int implicit;
        HashMap existingLocals = this.getPropertiesMap();
        EStructuralFeature prop = null;
        FeatureDecorator pd = null;
        Object p = existingLocals.get(name);
        if (Boolean.FALSE == p) {
            return null;
        }
        if (p != null) {
            existingLocals.put(name, Boolean.FALSE);
            pd = Utilities.getPropertyDecorator((EModelElement)((EStructuralFeature)p));
            if (pd != null && !pd.isMergeIntrospection()) {
                return null;
            }
            prop = (EStructuralFeature)p;
        }
        if (pd != null && pd.isImplicitlyCreated() == 0) {
            indexed = pd instanceof IndexedPropertyDecorator;
        } else if (pd != null && pd.isImplicitlyCreated() != 0 && (indexed && !(pd instanceof IndexedPropertyDecorator) || !indexed && pd instanceof IndexedPropertyDecorator)) {
            prop.getEAnnotations().remove(pd);
            pd = null;
        }
        int n = implicit = pd == null ? 1 : pd.isImplicitlyCreated();
        if (prop == null) {
            prop = EcoreFactory.eINSTANCE.createEReference();
            this.getReferencesList().add(prop);
            implicit = 3;
        }
        ((XMIResource)prop.eResource()).setID((EObject)prop, String.valueOf(this.getJavaClass().getName()) + "/" + name);
        prop.setName(name);
        prop.setTransient(false);
        prop.setVolatile(false);
        prop.setChangeable(changeable);
        if (implicit == 3) {
            prop.setUnsettable(true);
        }
        prop.setEType(type);
        if (!indexed) {
            prop.setLowerBound(0);
            prop.setUpperBound(1);
        } else {
            prop.setLowerBound(0);
            prop.setUpperBound(-1);
            prop.setUnique(true);
        }
        if (pd == null) {
            pd = !indexed ? BeaninfoFactory.eINSTANCE.createPropertyDecorator() : BeaninfoFactory.eINSTANCE.createIndexedPropertyDecorator();
            pd.setImplicitlyCreated(implicit);
            prop.getEAnnotations().add(pd);
        }
        pd.setDescriptorProxy(propDesc);
        pd.setDecoratorProxy(null);
        return pd;
    }

    protected void reflectProperties() {
        boolean isBound;
        JavaClass superType;
        HashMap<String, EStructuralFeature> supers = new HashMap<String, EStructuralFeature>(50);
        BeanDecorator bd = Utilities.getBeanDecorator((EModelElement)this.getJavaClass());
        if (bd.isMergeSuperProperties() && (superType = this.getJavaClass().getSupertype()) != null) {
            Iterator superAllItr = superType.getAllProperties().iterator();
            while (superAllItr.hasNext()) {
                EStructuralFeature sf = (EStructuralFeature)superAllItr.next();
                supers.put(sf.getName(), sf);
            }
            this.introspectIfNecessary();
        }
        if (!(isBound = this.isDefaultBound())) {
            EList superTypes = this.getJavaClass().getEAllSuperTypes();
            ListIterator sprs = superTypes.listIterator(superTypes.size());
            while (sprs.hasPrevious() && !isBound) {
                JavaClass spr = (JavaClass)sprs.previous();
                BeaninfoClassAdapter bi = (BeaninfoClassAdapter)EcoreUtil.getExistingAdapter((Notifier)spr, (Object)IIntrospectionAdapter.ADAPTER_KEY);
                isBound = bi.isDefaultBound();
            }
        }
        HashMap<String, PropertyInfo> props = new HashMap<String, PropertyInfo>();
        Iterator<Object> itr = this.getJavaClass().getPublicMethods().iterator();
        while (itr.hasNext()) {
            PropertyInfo propInfo;
            String name;
            Method mthd = (Method)itr.next();
            if (mthd.isStatic() || mthd.isConstructor()) continue;
            if (mthd.getName().startsWith("get")) {
                name = Introspector.decapitalize(mthd.getName().substring(3));
                propInfo = (PropertyInfo)props.get(name);
                if (propInfo == null) {
                    propInfo = new PropertyInfo();
                    if (!propInfo.setGetter(mthd, false)) continue;
                    props.put(name, propInfo);
                    continue;
                }
                propInfo.setGetter(mthd, false);
                continue;
            }
            if (mthd.getName().startsWith("is")) {
                name = Introspector.decapitalize(mthd.getName().substring(2));
                propInfo = (PropertyInfo)props.get(name);
                if (propInfo == null) {
                    propInfo = new PropertyInfo();
                    if (!propInfo.setGetter(mthd, true)) continue;
                    props.put(name, propInfo);
                    continue;
                }
                propInfo.setGetter(mthd, true);
                continue;
            }
            if (!mthd.getName().startsWith("set")) continue;
            name = Introspector.decapitalize(mthd.getName().substring(3));
            propInfo = (PropertyInfo)props.get(name);
            if (propInfo == null) {
                propInfo = new PropertyInfo();
                if (!propInfo.setSetter(mthd)) continue;
                props.put(name, propInfo);
                continue;
            }
            propInfo.setSetter(mthd);
        }
        itr = props.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            EStructuralFeature sf = (EStructuralFeature)supers.get(entry.getKey());
            if (sf != null) continue;
            ((PropertyInfo)entry.getValue()).createProperty((String)entry.getKey(), isBound);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected EList introspectOperations() {
        this.introspectIfNecessary();
        if (this.isIntrospecting != false) return this.getJavaClass().getEOperationsGen();
        if (this.isIntrospectingOperations != false) return this.getJavaClass().getEOperationsGen();
        if (this.hasIntrospectedOperations != false) return this.getJavaClass().getEOperationsGen();
        this.isIntrospectingOperations = true;
        try {
            if (!this.isResourceConnected()) ** GOTO lbl-1000
            this.newoperations = new HashSet<E>(50);
            bd = Utilities.getBeanDecorator((EModelElement)this.getJavaClass());
            if (bd == null || bd.isIntrospectBehaviors()) {
                if (this.beaninfo != null) {
                    mthds = (IArrayBeanProxy)this.getProxyConstants().getMethodDescriptorsProxy().invokeCatchThrowableExceptions(this.beaninfo);
                    if (mthds != null) {
                        mthdSize = mthds.getLength();
                        i = 0;
                        while (i < mthdSize) {
                            this.calculateOperation(mthds.getCatchThrowableException(i));
                            ++i;
                        }
                    }
                } else {
                    this.reflectOperations();
                }
            }
            itr = this.getOperationsList().iterator();
            while (true) {
                block10: {
                    if (itr.hasNext()) break block10;
                    this.hasIntrospectedOperations = true;
                    break;
                }
                a = (EOperation)itr.next();
                m = Utilities.getMethodDecorator((EModelElement)a);
                if (this.newoperations.contains(a) || m == null) continue;
                implicit = m.isImplicitlyCreated();
                if (implicit != 0) {
                    m.setEModelElement(null);
                    ((InternalEObject)m).eSetProxyURI(BeaninfoClassAdapter.BAD_URI);
                    m = null;
                }
                if (implicit != 3) continue;
                itr.remove();
                ((InternalEObject)a).eSetProxyURI(BeaninfoClassAdapter.BAD_URI);
                var3_4 = null;
            }
        }
        catch (Throwable var7_8) {
            var6_9 = null;
            this.isIntrospectingOperations = false;
            this.operationsMap = null;
            this.operationsRealList = null;
            this.newoperations = null;
            throw var7_8;
        }
lbl-1000:
        // 2 sources

        {
            var6_10 = null;
            this.isIntrospectingOperations = false;
            this.operationsMap = null;
            this.operationsRealList = null;
            this.newoperations = null;
            return this.getJavaClass().getEOperationsGen();
        }
    }

    protected void calculateOperation(IBeanProxy operDesc) {
        String name = ((IStringBeanProxy)this.getProxyConstants().getNameProxy().invokeCatchThrowableExceptions(operDesc)).stringValue();
        this.createOperation(name, this.formLongName(name, operDesc), null, operDesc);
    }

    public MethodDecorator createOperation(String name, String longName, Method method, IBeanProxy mthdDesc) {
        int implicit;
        HashMap existingLocals = this.getOperationsMap();
        EOperation oper = null;
        MethodDecorator md = null;
        Object b = null;
        b = name != null ? existingLocals.get(longName) : existingLocals.get(longName);
        if (b != null) {
            md = Utilities.getMethodDecorator((EModelElement)((EOperation)b));
            if (md != null && !md.isMergeIntrospection()) {
                return null;
            }
            oper = b;
        }
        if (method == null) {
            method = JavaRefFactory.eINSTANCE.createMethod();
            URI uri = Utilities.getMethodURI((IMethodProxy)this.getProxyConstants().getMethodProxy().invokeCatchThrowableExceptions(mthdDesc));
            ((InternalEObject)method).eSetProxyURI(uri);
        }
        int n = implicit = md == null ? 1 : 0;
        if (oper == null) {
            oper = BeaninfoFactory.eINSTANCE.createMethodProxy();
            this.getOperationsList().add(oper);
            implicit = 3;
        }
        if (name == null) {
            name = method.getName();
        }
        if (oper instanceof MethodProxy) {
            ((MethodProxy)oper).setMethod(method);
        }
        ((XMIResource)oper.eResource()).setID((EObject)oper, String.valueOf(this.getJavaClass().getName()) + "/operation/" + name);
        oper.setName(name);
        this.newoperations.add(oper);
        if (md == null) {
            md = BeaninfoFactory.eINSTANCE.createMethodDecorator();
            md.setImplicitlyCreated(implicit);
            oper.getEAnnotations().add(md);
        }
        md.setDescriptorProxy(mthdDesc);
        md.setDecoratorProxy(null);
        return md;
    }

    protected void reflectOperations() {
        JavaClass superType;
        HashMap<String, EOperation> supers = new HashMap<String, EOperation>(50);
        BeanDecorator bd = Utilities.getBeanDecorator((EModelElement)this.getJavaClass());
        if (bd.isMergeSuperBehaviors() && (superType = this.getJavaClass().getSupertype()) != null) {
            Iterator superAllItr = superType.getEAllOperations().iterator();
            while (superAllItr.hasNext()) {
                EOperation op = (EOperation)superAllItr.next();
                supers.put(this.formLongName(op), op);
            }
            this.introspectIfNecessary();
        }
        Iterator itr = this.getJavaClass().getPublicMethods().iterator();
        while (itr.hasNext()) {
            String longName;
            Method mthd = (Method)itr.next();
            if (mthd.isStatic() || mthd.isConstructor() || supers.get(longName = this.formLongName((EOperation)mthd)) != null) continue;
            this.createOperation(null, longName, mthd, null);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected BasicEList allOperations() {
        UniqueEList allOperations = new UniqueEList(){

            protected Object[] newData(int capacity) {
                return new EOperation[capacity];
            }

            protected boolean useEquals() {
                return false;
            }
        };
        if (!this.isIntrospecting && !this.isDoingAllOperations && this.isResourceConnected()) {
            this.isDoingAllOperations = true;
            try {
                EList localOperations = this.getJavaClass().getEOperations();
                JavaClass superType = this.getJavaClass().getSupertype();
                if (superType != null) {
                    boolean mergeAll;
                    BeanDecorator bd = Utilities.getBeanDecorator((EModelElement)this.getJavaClass());
                    EList supers = superType.getEAllOperations();
                    boolean bl = mergeAll = bd == null || bd.isMergeSuperBehaviors();
                    if (!mergeAll) {
                        int len = supers.size();
                        int i = 0;
                        while (i < len) {
                            EOperation o = (EOperation)supers.get(i);
                            MethodDecorator md = Utilities.getMethodDecorator((EModelElement)o);
                            if (md == null || md.isImplicitlyCreated() == 0 && !md.isMergeIntrospection()) {
                                allOperations.add((Object)o);
                            }
                            ++i;
                        }
                    } else if (this.beaninfo != null) {
                        IArrayBeanProxy superNames = (IArrayBeanProxy)this.getProxyConstants().getInheritedMethodDescriptorsProxy().invokeCatchThrowableExceptions(this.beaninfo);
                        if (superNames != null) {
                            int i;
                            int len;
                            int l = superNames.getLength();
                            HashSet<String> superSet = new HashSet<String>(l);
                            int i2 = 0;
                            while (true) {
                                if (i2 >= l) {
                                    len = supers.size();
                                    i = 0;
                                    break;
                                }
                                superSet.add(((IStringBeanProxy)superNames.getCatchThrowableException(i2)).stringValue());
                                ++i2;
                            }
                            while (i < len) {
                                EOperation o = (EOperation)supers.get(i);
                                MethodDecorator md = Utilities.getMethodDecorator((EModelElement)o);
                                if (md == null || md.isImplicitlyCreated() == 0 && !md.isMergeIntrospection()) {
                                    allOperations.add((Object)o);
                                } else {
                                    String longName = this.formLongName(o);
                                    if (longName == null || superSet.contains(longName)) {
                                        allOperations.add((Object)o);
                                    }
                                }
                                ++i;
                            }
                        } else {
                            allOperations.addAll((Collection)supers);
                        }
                    } else {
                        allOperations.addAll((Collection)supers);
                    }
                }
                allOperations.addAll((Collection)localOperations);
                ESuperAdapter sa = this.getJavaClass().getESuperAdapter();
                sa.setAllOperationsCollectionModified(false);
            }
            catch (Throwable throwable) {
                Object var15_20 = null;
                this.isDoingAllOperations = false;
                throw throwable;
            }
            {
                Object var15_21 = null;
                this.isDoingAllOperations = false;
            }
        }
        allOperations.shrink();
        return new EcoreEList.UnmodifiableEList((InternalEObject)this.getJavaClass(), (EStructuralFeature)EcorePackage.eINSTANCE.getEClass_EAllOperations(), allOperations.size(), allOperations.data());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected EList introspectEvents() {
        this.introspectIfNecessary();
        if (this.isIntrospecting != false) return this.getJavaClass().getEventsGen();
        if (this.isIntrospectingEvents != false) return this.getJavaClass().getEventsGen();
        if (this.hasIntrospectedEvents != false) return this.getJavaClass().getEventsGen();
        this.isIntrospectingEvents = true;
        try {
            if (!this.isResourceConnected()) ** GOTO lbl-1000
            bd = Utilities.getBeanDecorator((EModelElement)this.getJavaClass());
            if (bd == null || bd.isIntrospectEvents()) {
                if (this.beaninfo != null) {
                    events = (IArrayBeanProxy)this.getProxyConstants().getEventSetDescriptorsProxy().invokeCatchThrowableExceptions(this.beaninfo);
                    if (events != null) {
                        eventSize = events.getLength();
                        i = 0;
                        while (i < eventSize) {
                            this.calculateEvent(events.getCatchThrowableException(i));
                            ++i;
                        }
                    }
                } else {
                    this.reflectEvents();
                }
            }
            oldLocals = this.getEventsMap();
            itr = this.getEventsList().iterator();
            while (true) {
                block10: {
                    if (itr.hasNext()) break block10;
                    this.hasIntrospectedEvents = true;
                    break;
                }
                a = (JavaEvent)itr.next();
                e = Utilities.getEventSetDecorator((EModelElement)a);
                aOld = oldLocals.get(a.getName());
                if (aOld == null || aOld == Boolean.FALSE || e == null) continue;
                implicit = e.isImplicitlyCreated();
                if (implicit != 0) {
                    e.setEModelElement(null);
                    ((InternalEObject)e).eSetProxyURI(BeaninfoClassAdapter.BAD_URI);
                    e = null;
                }
                if (implicit != 3) continue;
                itr.remove();
                ((InternalEObject)a).eSetProxyURI(BeaninfoClassAdapter.BAD_URI);
                a = null;
            }
        }
        catch (Throwable var9_10) {
            var8_11 = null;
            this.isIntrospectingEvents = false;
            this.eventsMap = null;
            this.eventsRealList = null;
            throw var9_10;
        }
lbl-1000:
        // 2 sources

        {
            var8_12 = null;
            this.isIntrospectingEvents = false;
            this.eventsMap = null;
            this.eventsRealList = null;
            return this.getJavaClass().getEventsGen();
        }
    }

    protected void calculateEvent(IBeanProxy eventDesc) {
        String name = ((IStringBeanProxy)this.getProxyConstants().getNameProxy().invokeCatchThrowableExceptions(eventDesc)).stringValue();
        this.createEvent(name, eventDesc);
    }

    public EventSetDecorator createEvent(String name, IBeanProxy eventDesc) {
        int implicit;
        HashMap existingLocals = this.getEventsMap();
        BeanEvent event = null;
        EventSetDecorator ed = null;
        Object b = existingLocals.get(name);
        if (Boolean.FALSE == b) {
            return null;
        }
        if (b != null) {
            existingLocals.put(name, Boolean.FALSE);
            ed = Utilities.getEventSetDecorator((EModelElement)((JavaEvent)b));
            if (ed != null && !ed.isMergeIntrospection()) {
                return null;
            }
            event = (JavaEvent)b;
        }
        int n = implicit = ed == null ? 1 : 0;
        if (event == null) {
            event = BeaninfoFactory.eINSTANCE.createBeanEvent();
            this.getEventsList().add(event);
            implicit = 3;
        }
        ((XMIResource)event.eResource()).setID((EObject)event, String.valueOf(this.getJavaClass().getName()) + "/event/" + name);
        event.setName(name);
        if (ed == null) {
            ed = BeaninfoFactory.eINSTANCE.createEventSetDecorator();
            ed.setImplicitlyCreated(implicit);
            event.getEAnnotations().add(ed);
        }
        ed.setDescriptorProxy(eventDesc);
        ed.setDecoratorProxy(null);
        return ed;
    }

    protected void reflectEvents() {
        JavaClass superType;
        HashMap<String, JavaEvent> supers = new HashMap<String, JavaEvent>(50);
        BeanDecorator bd = Utilities.getBeanDecorator((EModelElement)this.getJavaClass());
        if (bd.isMergeSuperEvents() && (superType = this.getJavaClass().getSupertype()) != null) {
            Iterator superAllItr = superType.getAllEvents().iterator();
            while (superAllItr.hasNext()) {
                JavaEvent se = (JavaEvent)superAllItr.next();
                supers.put(se.getName(), se);
            }
            this.introspectIfNecessary();
        }
        HashMap<String, EventInfo> events = new HashMap<String, EventInfo>();
        this.eventListenerClass = (JavaClass)JavaClassImpl.reflect((String)"java.util.EventListener", (EObject)this.getJavaClass());
        this.tooManyExceptionClass = (JavaClass)JavaClassImpl.reflect((String)"java.util.TooManyListenersException", (EObject)this.getJavaClass());
        Iterator itr = this.getJavaClass().getPublicMethods().iterator();
        while (itr.hasNext()) {
            EventInfo eventInfo;
            Method mthd = (Method)itr.next();
            if (mthd.isStatic() || mthd.isConstructor()) continue;
            String key = this.validEventAdder(mthd);
            if (key != null) {
                eventInfo = (EventInfo)events.get(key);
                if (eventInfo == null) {
                    eventInfo = new EventInfo();
                    eventInfo.setAdder(mthd);
                    events.put(key, eventInfo);
                    continue;
                }
                eventInfo.setAdder(mthd);
                continue;
            }
            key = this.validEventRemove(mthd);
            if (key == null) continue;
            eventInfo = (EventInfo)events.get(key);
            if (eventInfo == null) {
                eventInfo = new EventInfo();
                eventInfo.setRemover(mthd);
                events.put(key, eventInfo);
                continue;
            }
            eventInfo.setRemover(mthd);
        }
        this.eventListenerClass = null;
        HashSet<String> eventNames = new HashSet<String>(events.size());
        Iterator evtItr = events.entrySet().iterator();
        while (evtItr.hasNext()) {
            JavaEvent superEvent;
            String eventName;
            Map.Entry eventMap = evtItr.next();
            EventInfo ei = (EventInfo)eventMap.getValue();
            if (!ei.isValidInfo() || eventNames.contains(eventName = this.getEventName((String)eventMap.getKey())) || (superEvent = (JavaEvent)supers.get(eventName)) != null || !ei.createEvent(eventName)) continue;
            eventNames.add(eventName);
        }
        this.tooManyExceptionClass = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected EList allEvents() {
        EList jcAllEvents = this.getJavaClass().getAllEventsGen();
        JavaClassImpl javaClassImpl = this.getJavaClass();
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("[Lorg.eclipse.jem.internal.beaninfo.adapters.BeaninfoSuperAdapter;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        BeaninfoSuperAdapter superAdapter = (BeaninfoSuperAdapter)EcoreUtil.getRegisteredAdapter((EObject)javaClassImpl, (Object)clazz);
        if (!(jcAllEvents == null || superAdapter != null && superAdapter.isAllEventsCollectionModified())) {
            return jcAllEvents;
        }
        UniqueEList allEvents = new UniqueEList(){

            protected Object[] newData(int capacity) {
                return new JavaEvent[capacity];
            }

            protected boolean useEquals() {
                return false;
            }
        };
        if (!this.isIntrospecting && !this.isDoingAllEvents && this.isResourceConnected()) {
            this.isDoingAllEvents = true;
            try {
                EList localEvents = this.getJavaClass().getEvents();
                JavaClass superType = this.getJavaClass().getSupertype();
                if (superType != null) {
                    boolean mergeAll;
                    BeanDecorator bd = Utilities.getBeanDecorator((EModelElement)this.getJavaClass());
                    EList supers = superType.getAllEvents();
                    boolean bl = mergeAll = bd == null || bd.isMergeSuperEvents();
                    if (!mergeAll) {
                        int len = supers.size();
                        int i = 0;
                        while (i < len) {
                            JavaEvent e = (JavaEvent)supers.get(i);
                            EventSetDecorator ed = Utilities.getEventSetDecorator((EModelElement)e);
                            if (ed == null || ed.isImplicitlyCreated() == 0 && !ed.isMergeIntrospection()) {
                                allEvents.add((Object)e);
                            }
                            ++i;
                        }
                    } else if (this.beaninfo != null) {
                        IArrayBeanProxy superNames = (IArrayBeanProxy)this.getProxyConstants().getInheritedEventSetDescriptorsProxy().invokeCatchThrowableExceptions(this.beaninfo);
                        if (superNames != null) {
                            int i;
                            int len;
                            int l = superNames.getLength();
                            HashSet<String> superSet = new HashSet<String>(l);
                            int i2 = 0;
                            while (true) {
                                if (i2 >= l) {
                                    len = supers.size();
                                    i = 0;
                                    break;
                                }
                                superSet.add(((IStringBeanProxy)superNames.getCatchThrowableException(i2)).stringValue());
                                ++i2;
                            }
                            while (i < len) {
                                JavaEvent e = (JavaEvent)supers.get(i);
                                EventSetDecorator ed = Utilities.getEventSetDecorator((EModelElement)e);
                                if (ed == null || ed.isImplicitlyCreated() == 0 && !ed.isMergeIntrospection() || superSet.contains(ed.getName())) {
                                    allEvents.add((Object)e);
                                }
                                ++i;
                            }
                        } else {
                            allEvents.addAll((Collection)supers);
                        }
                    } else {
                        allEvents.addAll((Collection)supers);
                    }
                }
                allEvents.addAll((Collection)localEvents);
                superAdapter.setAllEventsCollectionModified(false);
            }
            catch (Throwable throwable) {
                Object var16_21 = null;
                this.isDoingAllEvents = false;
                throw throwable;
            }
            {
                Object var16_22 = null;
                this.isDoingAllEvents = false;
            }
        }
        allEvents.shrink();
        return new EcoreEList.UnmodifiableEList((InternalEObject)this.getJavaClass(), (EStructuralFeature)JavaRefPackage.eINSTANCE.getJavaClass_AllEvents(), allEvents.size(), allEvents.data());
    }

    protected String getEventName(String key) {
        return key.substring(0, key.indexOf(58));
    }

    protected String validEventAdder(Method method) {
        String name = method.getName();
        if (!name.startsWith("add") || !name.endsWith("Listener")) {
            return null;
        }
        List parms = (List)method.getParameters();
        if (parms.size() != 1) {
            return null;
        }
        JavaHelpers returnType = method.getReturnType();
        if (returnType == null || !returnType.getName().equals("void")) {
            return null;
        }
        EClassifier parmType = ((JavaParameter)parms.get(0)).getEType();
        if (!this.eventListenerClass.isAssignableFrom(parmType)) {
            return null;
        }
        return String.valueOf(Introspector.decapitalize(name.substring(3, name.length() - 8))) + ':' + ((JavaHelpers)parmType).getQualifiedName();
    }

    protected String validEventRemove(Method method) {
        String name = method.getName();
        if (!name.startsWith("remove") || !name.endsWith("Listener")) {
            return null;
        }
        List parms = (List)method.getParameters();
        if (parms.size() != 1) {
            return null;
        }
        JavaHelpers returnType = method.getReturnType();
        if (returnType == null || !returnType.getName().equals("void")) {
            return null;
        }
        EClassifier parmType = ((JavaParameter)parms.get(0)).getEType();
        if (!this.eventListenerClass.isAssignableFrom(parmType)) {
            return null;
        }
        return String.valueOf(Introspector.decapitalize(name.substring(6, name.length() - 8))) + ':' + ((JavaHelpers)parmType).getQualifiedName();
    }

    public boolean isDefaultBound() {
        if (this.defaultBound == null) {
            Iterator methods = this.getJavaClass().getPublicMethods().iterator();
            boolean foundAdd = false;
            boolean foundRemove = false;
            while (!(!methods.hasNext() || foundAdd && foundRemove)) {
                JavaParameter parm;
                EList parms;
                Method method = (Method)methods.next();
                if ("addPropertyChangeListener".equals(method.getName())) {
                    parms = method.getParameters();
                    if (parms.size() != 1 || !"java.beans.PropertyChangeListener".equals(((JavaHelpers)(parm = (JavaParameter)parms.get(0)).getEType()).getQualifiedName())) continue;
                    foundAdd = true;
                    continue;
                }
                if (!"removePropertyChangeListener".equals(method.getName()) || (parms = method.getParameters()).size() != 1 || !"java.beans.PropertyChangeListener".equals(((JavaHelpers)(parm = (JavaParameter)parms.get(0)).getEType()).getQualifiedName())) continue;
                foundRemove = true;
            }
            this.defaultBound = foundAdd && foundRemove ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.defaultBound;
    }

    public void markStaleFactory(ProxyFactoryRegistry stale) {
        if (this.staleFactory == null) {
            this.hasIntrospectedEvents = false;
            this.hasIntrospectedOperations = false;
            this.hasIntrospectedProperties = false;
            this.hasIntrospected = false;
            this.defaultBound = null;
            this.staleFactory = new WeakReference<ProxyFactoryRegistry>(stale);
            if (this.beaninfo != null) {
                this.beaninfo.getProxyFactoryRegistry().releaseProxy(this.beaninfo);
                this.beaninfo = null;
            }
            Notifier notifier = this.getTarget();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("[Lorg.eclipse.emf.ecore.impl.ESuperAdapter;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Adapter a = EcoreUtil.getExistingAdapter((Notifier)notifier, (Object)clazz);
            ENotificationImpl note = new ENotificationImpl((InternalEObject)this.getTarget(), 1, 8, null, null);
            if (a != null) {
                a.notifyChanged((Notification)note);
            }
            if ((a = EcoreUtil.getExistingAdapter((Notifier)this.getTarget(), (Object)BeaninfoSuperAdapter.ADAPTER_KEY)) != null) {
                a.notifyChanged((Notification)note);
            }
        }
    }

    private String formLongName(EOperation feature) {
        Method mthd = null;
        if (feature instanceof Method) {
            mthd = (Method)feature;
        } else if (feature instanceof MethodProxy) {
            mthd = ((MethodProxy)feature).getMethod();
        } else {
            return null;
        }
        StringBuffer longName = new StringBuffer(100);
        longName.append(feature.getName());
        longName.append(':');
        longName.append(mthd.getName());
        longName.append('(');
        EList p = mthd.getParameters();
        int i = 0;
        while (i < p.size()) {
            JavaParameter parm = (JavaParameter)p.get(i);
            if (i > 0) {
                longName.append(',');
            }
            longName.append(parm.getJavaType().getQualifiedName());
            ++i;
        }
        return longName.toString();
    }

    private String formLongName(String name, IBeanProxy methDesc) {
        StringBuffer longName = new StringBuffer(100);
        longName.append(name);
        longName.append(':');
        IMethodProxy mthd = (IMethodProxy)this.getProxyConstants().getMethodProxy().invokeCatchThrowableExceptions(methDesc);
        longName.append(mthd.getName());
        longName.append('(');
        IBeanTypeProxy[] p = mthd.getParameterTypes();
        int i = 0;
        while (i < p.length) {
            IBeanTypeProxy parm = p[i];
            if (i > 0) {
                longName.append(',');
            }
            longName.append(parm.getFormalTypeName());
            ++i;
        }
        return longName.toString();
    }

    public void notifyChanged(Notification msg) {
        if (msg.getEventType() == 8) {
            this.getAdapterFactory().removeAdapter(this);
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + '(' + (this.getJavaClass() != null ? this.getJavaClass().getQualifiedName() : "?") + ')';
    }

    private class PropertyInfo {
        public EClassifier type;
        public EClassifier indexedType;
        public boolean constrained;
        public Method getter;
        public Method setter;
        public Method indexedGetter;
        public Method indexedSetter;

        PropertyInfo() {
        }

        public boolean setGetter(Method get, boolean mustBeBoolean) {
            boolean indexed;
            List parms = (List)get.getParameters();
            if (parms.size() > 1) {
                return false;
            }
            boolean bl = indexed = parms.size() == 1;
            if (indexed && !((JavaParameter)parms.get(0)).getEType().getName().equals("int")) {
                return false;
            }
            JavaHelpers retType = get.getReturnType();
            if (retType == null || retType.getName().equals("void")) {
                return false;
            }
            if (mustBeBoolean && !retType.getName().equals("boolean")) {
                return false;
            }
            if (indexed) {
                if (this.indexedType != null && this.indexedType != retType) {
                    return false;
                }
                if (!(this.type == null || ((JavaHelpers)this.type).isArray() && ((ArrayType)this.type).getComponentType() == retType)) {
                    return false;
                }
            } else {
                if (this.type != null && this.type != retType) {
                    return false;
                }
                if (!(this.indexedType == null || retType.isArray() && ((ArrayType)retType).getComponentType() == this.indexedType)) {
                    if (this.type == null) {
                        this.indexedGetter = null;
                        this.indexedSetter = null;
                        this.indexedType = null;
                    } else {
                        return false;
                    }
                }
            }
            if (indexed) {
                if (this.indexedGetter != null) {
                    return false;
                }
                this.indexedGetter = get;
                this.indexedType = retType;
            } else {
                if (this.getter != null) {
                    return false;
                }
                this.getter = get;
                this.type = retType;
            }
            return true;
        }

        public boolean setSetter(Method set) {
            boolean indexed;
            List parms = (List)set.getParameters();
            if (parms.size() > 2 || parms.size() < 1) {
                return false;
            }
            boolean bl = indexed = parms.size() == 2;
            if (indexed && !((JavaParameter)parms.get(0)).getEType().getName().equals("int")) {
                return false;
            }
            JavaHelpers retType = set.getReturnType();
            if (retType != null && !retType.getName().equals("void")) {
                return false;
            }
            EClassifier propType = null;
            if (indexed) {
                propType = ((JavaParameter)parms.get(1)).getEType();
                if (this.indexedType != null && this.indexedType != propType) {
                    return false;
                }
                if (!(this.type == null || ((JavaHelpers)this.type).isArray() && ((ArrayType)this.type).getComponentType() == propType)) {
                    return false;
                }
            } else {
                propType = ((JavaParameter)parms.get(0)).getEType();
                if (this.type != null && this.type != propType) {
                    return false;
                }
                if (!(this.indexedType == null || ((JavaHelpers)propType).isArray() && ((ArrayType)propType).getComponentType() == this.indexedType)) {
                    if (this.type == null) {
                        this.indexedGetter = null;
                        this.indexedSetter = null;
                        this.indexedType = null;
                    } else {
                        return false;
                    }
                }
            }
            if (indexed) {
                if (this.indexedSetter != null) {
                    return false;
                }
                this.indexedSetter = set;
                this.indexedType = propType;
            } else {
                if (this.setter != null) {
                    return false;
                }
                this.setter = set;
                this.type = propType;
            }
            if (set.getJavaExceptions().contains(Utilities.getJavaClass("java.beans.PropertyVetoException", BeaninfoClassAdapter.this.getJavaClass().eResource().getResourceSet()))) {
                this.constrained = true;
            }
            return true;
        }

        public void createProperty(String name, boolean isBound) {
            boolean indexed;
            boolean bl = indexed = this.indexedType != null;
            if (indexed && this.type == null) {
                return;
            }
            PropertyDecorator prop = BeaninfoClassAdapter.this.createProperty(name, indexed, !indexed ? this.setter != null : this.setter != null || this.indexedSetter != null, this.type, null);
            if (prop == null) {
                return;
            }
            indexed = prop instanceof IndexedPropertyDecorator;
            if (prop.isImplicitlyCreated() == 0) {
                PropertyDecorator propProxy = indexed ? BeaninfoFactory.eINSTANCE.createIndexedPropertyDecorator() : BeaninfoFactory.eINSTANCE.createPropertyDecorator();
                prop.setDecoratorProxy(propProxy);
                prop = propProxy;
            }
            prop.setBound(isBound);
            prop.setConstrained(this.constrained);
            if (this.getter != null) {
                prop.setReadMethod(this.getter);
            } else {
                prop.eUnset((EStructuralFeature)BeaninfoPackage.eINSTANCE.getPropertyDecorator_ReadMethod());
            }
            if (this.setter != null) {
                prop.setWriteMethod(this.setter);
            } else {
                prop.eUnset((EStructuralFeature)BeaninfoPackage.eINSTANCE.getPropertyDecorator_WriteMethod());
            }
            if (indexed) {
                IndexedPropertyDecorator iprop = (IndexedPropertyDecorator)prop;
                if (this.indexedGetter != null) {
                    iprop.setIndexedReadMethod(this.indexedGetter);
                } else {
                    iprop.eUnset((EStructuralFeature)BeaninfoPackage.eINSTANCE.getIndexedPropertyDecorator_IndexedReadMethod());
                }
                if (this.indexedSetter != null) {
                    iprop.setIndexedWriteMethod(this.indexedSetter);
                } else {
                    iprop.eUnset((EStructuralFeature)BeaninfoPackage.eINSTANCE.getIndexedPropertyDecorator_IndexedReadMethod());
                }
            }
        }
    }

    private class EventInfo {
        public Method addListenerMethod;
        public Method removeListenerMethod;

        EventInfo() {
        }

        public void setAdder(Method addMethod) {
            this.addListenerMethod = addMethod;
        }

        public void setRemover(Method removeMethod) {
            this.removeListenerMethod = removeMethod;
        }

        public boolean isValidInfo() {
            return this.addListenerMethod != null && this.removeListenerMethod != null;
        }

        public boolean createEvent(String name) {
            EventSetDecorator ed = BeaninfoClassAdapter.this.createEvent(name, null);
            if (ed == null) {
                return false;
            }
            ed.setAddListenerMethod(this.addListenerMethod);
            ed.setRemoveListenerMethod(this.removeListenerMethod);
            Iterator itr = this.addListenerMethod.getJavaExceptions().iterator();
            while (itr.hasNext()) {
                if (itr.next() != BeaninfoClassAdapter.this.tooManyExceptionClass) continue;
                ed.setUnicast(true);
                break;
            }
            EList parms = this.addListenerMethod.getParameters();
            ed.setListenerType((JavaClass)((JavaParameter)parms.get(0)).getEType());
            return true;
        }
    }
}

