/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.cheatsheets;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public abstract class AbstractWizardInvocationAction
extends Action {
    public static void invoke(String method, Object[] parameters, Object targetObject) {
        Method[] methods = targetObject.getClass().getMethods();
        int mc = 0;
        while (mc < methods.length) {
            Method m = methods[mc];
            if (m.getName().equals(method) && m.getParameterTypes().length == parameters.length) {
                try {
                    m.invoke(targetObject, parameters);
                    return;
                }
                catch (IllegalArgumentException e) {
                    JavaVEPlugin.log((Throwable)e, (int)2);
                }
                catch (IllegalAccessException e) {
                    JavaVEPlugin.log((Throwable)e, (int)2);
                }
                catch (InvocationTargetException e) {
                    JavaVEPlugin.log((Throwable)e, (int)2);
                }
            }
            ++mc;
        }
    }

    public static Object createInstanceOf(String pluginID, String className) {
        try {
            IPluginDescriptor desc = Platform.getPlugin((String)pluginID).getDescriptor();
            return desc.getPluginClassLoader().loadClass(className).newInstance();
        }
        catch (InstantiationException e1) {
            JavaVEPlugin.log((Throwable)e1, (int)2);
        }
        catch (IllegalAccessException e1) {
            JavaVEPlugin.log((Throwable)e1, (int)2);
        }
        catch (ClassNotFoundException e1) {
            JavaVEPlugin.log((Throwable)e1, (int)2);
        }
        return null;
    }

    protected abstract IWizard createWizard();

    protected void setUp(IWizard wizard, WizardDialog dialog) {
    }

    protected void cancelPressed(IWizard wizard) {
    }

    protected void okPressed(IWizard wizard) {
    }

    public void run() {
        try {
            IWizard wizard = this.createWizard();
            if (wizard == null) {
                return;
            }
            Shell shell = Display.getCurrent().getActiveShell();
            WizardDialog wizardDialog = new WizardDialog(shell, wizard);
            this.setUp(wizard, wizardDialog);
            wizardDialog.create();
            wizardDialog.open();
            int ret = wizardDialog.getReturnCode();
            switch (ret) {
                case 1: {
                    this.cancelPressed(wizard);
                    break;
                }
                case 0: {
                    this.okPressed(wizard);
                }
            }
        }
        catch (Exception e) {
            JavaVEPlugin.log((Throwable)e, (int)2);
        }
    }
}

