/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.internal.compiler.AbstractSyntaxTreeVisitorAdapter;
import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.ForStatement;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.ve.internal.java.codegen.java.CodeSnippetTranslatorHelper;

public class ASTHelper {
    public static String resolveSingleNameReference(String selector, int location, String entireCode) {
        List parserOutput = CodeSnippetTranslatorHelper.parseSyntacticallyCodeSnippet(entireCode);
        if (parserOutput == null) {
            return selector;
        }
        if (parserOutput.size() < 1) {
            return selector;
        }
        if (parserOutput.get(0) instanceof CompilationUnitDeclaration) {
            CompilationUnitDeclaration decl = (CompilationUnitDeclaration)parserOutput.get(0);
            SingleNameReferenceValueSyntaxTreeVisitor valueVisitor = new SingleNameReferenceValueSyntaxTreeVisitor(selector, location);
            decl.traverse((IAbstractSyntaxTreeVisitor)valueVisitor, decl.scope);
            return valueVisitor.getValue();
        }
        return selector;
    }

    public static class SingleNameReferenceValueSyntaxTreeVisitor
    extends AbstractSyntaxTreeVisitorAdapter {
        private String selector = null;
        private AstNode value = null;
        private Hashtable varToValHash = null;
        private Stack scopeStack = null;
        private int selectorLocation = -1;

        public SingleNameReferenceValueSyntaxTreeVisitor(String selector, int selectorLocation) {
            this.selector = selector;
            this.selectorLocation = selectorLocation;
        }

        public String getValue() {
            if (this.value != null) {
                if (this.value instanceof ArrayInitializer) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("{");
                    Expression[] args = ((ArrayInitializer)this.value).expressions;
                    int i = 0;
                    while (i < args.length) {
                        if (i > 0) {
                            sb.append(",");
                        }
                        sb.append(args[i].toString());
                        ++i;
                    }
                    sb.append('}');
                    return sb.toString();
                }
                return this.value.toString();
            }
            return this.selector;
        }

        private boolean isValuable(AstNode node) {
            if (node instanceof Literal) {
                return true;
            }
            return node instanceof ArrayInitializer;
        }

        private Stack getScopeStack() {
            if (this.scopeStack == null) {
                this.scopeStack = new Stack();
            }
            return this.scopeStack;
        }

        private Hashtable getHash() {
            if (this.varToValHash == null) {
                this.varToValHash = new Hashtable();
            }
            return this.varToValHash;
        }

        private void pushScope() {
            this.getScopeStack().push(this.getHash().clone());
        }

        private void popScope() {
            this.varToValHash = (Hashtable)this.getScopeStack().pop();
        }

        public boolean visit(Assignment assignment, BlockScope scope) {
            if (this.isValuable((AstNode)assignment.expression)) {
                Expression ref = assignment.lhs;
                String varName = "?";
                if (ref instanceof ArrayReference) {
                    ArrayReference arRef = (ArrayReference)ref;
                    varName = arRef.toStringExpression();
                } else if (ref instanceof FieldReference) {
                    FieldReference fieldRef = (FieldReference)ref;
                    varName = fieldRef.toStringExpression();
                } else if (ref instanceof NameReference) {
                    NameReference nameRef = (NameReference)ref;
                    varName = nameRef.toStringExpression();
                } else if (ref instanceof ThisReference) {
                    ThisReference thisRef = (ThisReference)ref;
                    varName = thisRef.toStringExpression();
                }
                this.getHash().put(varName, assignment.expression);
            }
            return super.visit(assignment, scope);
        }

        public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
            if (this.isValuable((AstNode)fieldDeclaration.initialization)) {
                this.getHash().put(fieldDeclaration.name(), fieldDeclaration.initialization);
            }
            return super.visit(fieldDeclaration, scope);
        }

        public boolean visit(LocalDeclaration localDeclaration, BlockScope scope) {
            if (this.isValuable((AstNode)localDeclaration.initialization)) {
                this.getHash().put(localDeclaration.name(), localDeclaration.initialization);
            }
            return super.visit(localDeclaration, scope);
        }

        public void endVisit(Block block, BlockScope scope) {
            this.exitingScope(block.sourceStart, block.sourceEnd);
            super.endVisit(block, scope);
        }

        public void endVisit(CompilationUnitDeclaration compilationUnitDeclaration, CompilationUnitScope scope) {
            this.exitingScope(compilationUnitDeclaration.sourceStart, compilationUnitDeclaration.sourceEnd);
            super.endVisit(compilationUnitDeclaration, scope);
        }

        public void endVisit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
            this.exitingScope(constructorDeclaration.sourceStart, constructorDeclaration.declarationSourceEnd);
            super.endVisit(constructorDeclaration, scope);
        }

        public void endVisit(ForStatement forStatement, BlockScope scope) {
            this.exitingScope(forStatement.sourceStart, forStatement.sourceEnd);
            super.endVisit(forStatement, scope);
        }

        public void endVisit(MethodDeclaration methodDeclaration, ClassScope scope) {
            this.exitingScope(methodDeclaration.sourceStart, methodDeclaration.declarationSourceEnd);
            super.endVisit(methodDeclaration, scope);
        }

        private void exitingScope(int scopeStart, int scopeEnd) {
            if (scopeStart < 0 || scopeEnd < 0 || scopeStart > scopeEnd) {
                return;
            }
            if (this.selectorLocation >= scopeStart && this.selectorLocation <= scopeEnd && this.value == null) {
                this.value = (AstNode)this.getHash().get(this.selector);
            }
            this.popScope();
        }

        public boolean visit(Block block, BlockScope scope) {
            this.pushScope();
            return super.visit(block, scope);
        }

        public boolean visit(CompilationUnitDeclaration compilationUnitDeclaration, CompilationUnitScope scope) {
            this.pushScope();
            return super.visit(compilationUnitDeclaration, scope);
        }

        public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
            this.pushScope();
            return super.visit(constructorDeclaration, scope);
        }

        public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
            this.pushScope();
            return super.visit(methodDeclaration, scope);
        }

        public boolean visit(ForStatement forStatement, BlockScope scope) {
            this.pushScope();
            return super.visit(forStatement, scope);
        }
    }
}

