/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ve.internal.java.codegen.java.BeanPartFactory;
import org.eclipse.ve.internal.java.codegen.java.ExpressionRefFactory;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeEventRef;
import org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.model.ICodeDelta;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class CodeSnippetMergelet {
    ICodeDelta fBDMDelta;
    String fElementContent = null;
    String fElementHandle = null;
    boolean fisMethod;
    IBeanDeclModel fBeanModel = null;
    HashMap fExpressionsByMethod = new HashMap();

    public CodeSnippetMergelet(ICodeDelta delta, String elementContent, String elementHandle, boolean isMethodElement) {
        this.fBDMDelta = delta;
        this.fElementContent = elementContent;
        this.fElementHandle = elementHandle;
        this.fisMethod = isMethodElement;
    }

    private CodeMethodRef getOriginalMethodElement() throws CodeGenException {
        if (!this.fisMethod) {
            throw new CodeGenException("Invalid Context");
        }
        return this.fBeanModel.getMethodInitializingABean(this.fElementHandle);
    }

    private List getExpressions(CodeMethodRef m) {
        ArrayList l = (ArrayList)this.fExpressionsByMethod.get(m);
        if (l == null) {
            l = new ArrayList();
            this.fExpressionsByMethod.put(m, l);
            Iterator itr = m.getAllExpressions();
            while (itr.hasNext()) {
                l.add(itr.next());
            }
        }
        return l;
    }

    private CodeExpressionRef getOriginal(CodeExpressionRef exp) throws CodeGenException {
        if (!this.fisMethod) {
            throw new CodeGenException("Invalid Context");
        }
        CodeMethodRef m = this.getOriginalMethodElement();
        if (m == null) {
            return null;
        }
        Iterator itr = this.getExpressions(m).iterator();
        CodeExpressionRef result = null;
        while (itr.hasNext()) {
            CodeExpressionRef e = (CodeExpressionRef)itr.next();
            if (e == exp) {
                result = e;
                break;
            }
            int eqv = e.isEquivalent(exp);
            if (eqv < 0) continue;
            if (eqv == 1) {
                result = e;
                break;
            }
            if (result != null) continue;
            result = e;
        }
        if (result != null) {
            this.getExpressions(m).remove(result);
            return result;
        }
        return null;
    }

    private BeanPart getOriginal(BeanPart b) {
        Iterator itr = this.fBeanModel.getBeans().iterator();
        while (itr.hasNext()) {
            BeanPart bean = (BeanPart)itr.next();
            if (!bean.isEquivalent(b) || !bean.getUniqueName().equals(b.getUniqueName())) continue;
            return bean;
        }
        return null;
    }

    private void replaceLocalContent(int left, int len, String Content) throws CodeGenException {
        try {
            this.fBeanModel.getDocument().replace(left, len, Content);
        }
        catch (BadLocationException e) {
            JavaVEPlugin.log((Throwable)e, (int)5);
            throw new CodeGenException(e);
        }
    }

    private CodeExpressionRef createNewExpression(CodeExpressionRef e, CodeMethodRef m, boolean decode) throws CodeGenException {
        if (this.getOriginal(e) != null) {
            throw new CodeGenException("duplicate Expression");
        }
        BeanPart b = this.getOriginal(e.getBean());
        if (b == null) {
            throw new CodeGenException("No Bean Part");
        }
        ExpressionRefFactory gen = new ExpressionRefFactory(b, null);
        CodeExpressionRef newe = gen.createFromSource(e, m);
        newe.setState(8, e.isStateSet(8));
        newe.setState(1024, e.isStateSet(1024));
        if (decode && !newe.decodeExpression()) {
            newe.dispose();
            newe = null;
        }
        return newe;
    }

    private CodeEventRef createNewEventExpression(CodeEventRef e, CodeMethodRef m, boolean decode) throws CodeGenException {
        if (this.getOriginal(e) != null) {
            throw new CodeGenException("duplicate Expression");
        }
        BeanPart b = this.getOriginal(e.getBean());
        if (b == null) {
            throw new CodeGenException("No Bean Part");
        }
        CodeEventRef newe = new CodeEventRef(m, b);
        newe.setState(8, e.isStateSet(8));
        newe.setState(1024, e.isStateSet(1024));
        newe.setState(64, true);
        newe.setExpression(e.getExpression());
        newe.setContent(e.getContentParser());
        newe.setOffset(e.getOffset());
        newe.setEventInvocation(e.getEventInvocation());
        if (decode && !newe.decodeExpression()) {
            newe.dispose();
            newe = null;
        }
        return newe;
    }

    private boolean processExpressionDelta(CodeExpressionRef dExp, CodeExpressionRef oExp, CodeMethodRef oMethod, int status) throws CodeGenException {
        boolean updated = false;
        if (oExp != null && dExp != null && !dExp.isStateSet(128)) {
            if (oExp.isEquivalent(dExp) < 0) {
                throw new CodeGenException("No the same Expressions");
            }
            oExp.setExpression(dExp.getExpression());
        }
        if (oExp != null && dExp != null) {
            oExp.updateLimboState(dExp);
        }
        if (oExp == null && status != 4 && status != 32) {
            JavaVEPlugin.log((Object)("CodeSnippetMergelent.processExpressionDelta(): could not find" + dExp), (int)2);
        }
        switch (status) {
            case 32: {
                JavaVEPlugin.log((Object)("CodeSnippetMergelent.processExpressionDelta() In Limbo: " + oExp), (int)2);
                if (oExp == null) break;
                oExp.setState(128, true);
                break;
            }
            case 16: {
                oExp.setOffset(dExp.getOffset());
                if (dExp.isStateSet(512) || dExp instanceof CodeEventRef) break;
                oExp.refreshFromJOM(dExp, false);
                break;
            }
            case 1: {
                if (oExp == null) break;
                oExp.setContent(dExp.getContentParser());
                break;
            }
            case 8: {
                if (oExp == null) break;
                if (oExp.isStateSet(1024)) {
                    this.fBeanModel.setState(1, true);
                    return false;
                }
                if (oExp.getOffset() != dExp.getOffset()) {
                    oExp.setOffset(dExp.getOffset());
                }
                oExp.refreshFromJOM(dExp, false);
                updated = true;
                break;
            }
            case 2: {
                if (oExp == null) break;
                if (oExp.isStateSet(1024)) {
                    this.fBeanModel.setState(1, true);
                    return false;
                }
                oExp.deleteFromComposition();
                oExp.dispose();
                updated = true;
                break;
            }
            case 4: {
                try {
                    if (dExp.isStateSet(1024)) {
                        this.fBeanModel.setState(1, true);
                        return false;
                    }
                    CodeExpressionRef newExp = this.createNewExpression(dExp, oMethod, !dExp.isStateSet(8));
                    if (newExp == null && dExp instanceof CodeEventRef) {
                        newExp = this.createNewEventExpression((CodeEventRef)dExp, oMethod, !dExp.isStateSet(8));
                    }
                    updated = true;
                }
                catch (CodeGenException codeGenException) {}
                break;
            }
            default: {
                throw new CodeGenException("Invalid Status");
            }
        }
        return updated;
    }

    private boolean updateMethodDelta(CodeMethodRef m, List deleteList) throws CodeGenException {
        CodeMethodRef oMethod = this.getOriginalMethodElement();
        boolean updated = false;
        if ((this.fBDMDelta.getElementStatus(m) & 0x20) == 32) {
            ArrayList deltaExpressions = new ArrayList();
            ArrayList oldExpressions = new ArrayList();
            Iterator newItr = m.getExpressions();
            Iterator oldItr = oMethod.getExpressions();
            while (newItr.hasNext()) {
                deltaExpressions.add(newItr.next());
            }
            while (oldItr.hasNext()) {
                oldExpressions.add(oldItr.next());
            }
            newItr = deltaExpressions.iterator();
            oldItr = oldExpressions.iterator();
            while (newItr.hasNext() && oldItr.hasNext()) {
                CodeExpressionRef dExp = (CodeExpressionRef)newItr.next();
                CodeExpressionRef oExp = (CodeExpressionRef)oldItr.next();
                updated |= this.processExpressionDelta(dExp, oExp, oMethod, this.fBDMDelta.getElementStatus(dExp));
            }
        } else {
            CodeExpressionRef oExp;
            CodeExpressionRef dExp;
            Iterator itr;
            if (deleteList != null) {
                itr = deleteList.iterator();
                while (itr.hasNext()) {
                    oExp = dExp = (CodeExpressionRef)itr.next();
                    updated |= this.processExpressionDelta(dExp, oExp, oMethod, this.fBDMDelta.getElementStatus(dExp));
                    if (!this.fBeanModel.isStateSet(1)) continue;
                    return updated;
                }
            }
            itr = m.getAllExpressions();
            while (itr.hasNext() && !this.fBeanModel.isStateSet(1)) {
                dExp = (CodeExpressionRef)itr.next();
                oExp = this.getOriginal(dExp);
                updated |= this.processExpressionDelta(dExp, oExp, oMethod, this.fBDMDelta.getElementStatus(dExp));
            }
        }
        return updated;
    }

    protected void replaceMethodContent() throws CodeGenException {
        try {
            IMethod m = CodeGenUtil.getMethod(CodeGenUtil.getMainType(this.fBeanModel.getCompilationUnit()), this.fElementHandle);
            this.replaceLocalContent(m.getSourceRange().getOffset(), m.getSourceRange().getLength(), this.fElementContent);
        }
        catch (JavaModelException e) {
            throw new CodeGenException(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateBDM(IBeanDeclModel model) throws CodeGenException {
        CodeMethodRef oriMref;
        if (model == null) throw new CodeGenException("Invalid Arg");
        if (this.fElementHandle == null) {
            throw new CodeGenException("Invalid Arg");
        }
        this.fBeanModel = model;
        boolean modelUpdated = false;
        CodeMethodRef mref = this.fBDMDelta.getDeltaMethod();
        if (mref == null) {
            JavaVEPlugin.log((Object)"CodeSnippetMerglent.updateBDM() : no CodeMethodRef", (int)5);
            return modelUpdated;
        }
        switch (this.fBDMDelta.getElementStatus(mref)) {
            case 1: {
                return modelUpdated;
            }
            case 4: {
                this.fBeanModel.setState(1, true);
                return true;
            }
            case 2: {
                this.fBeanModel.setState(1, true);
                return true;
            }
            case 8: 
            case 16: 
            case 32: {
                modelUpdated |= this.updateMethodDelta(mref, this.fBDMDelta.getDeletedElements(mref));
                if (this.fBeanModel.isStateSet(1)) {
                    return modelUpdated;
                }
                oriMref = this.getOriginalMethodElement();
                try {
                    oriMref.disconnectFromDoc();
                    this.replaceMethodContent();
                    BeanPartFactory.fixOffsetIfNeeded(this.fElementContent, oriMref);
                    break;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    oriMref.connectToDoc();
                    throw throwable;
                }
            }
            default: {
                throw new CodeGenException("Invalid State");
            }
        }
        {
            Object var5_7 = null;
            oriMref.connectToDoc();
            return modelUpdated;
        }
    }

    public void updateBDMwithLock(IBeanDeclModel model) throws CodeGenException {
        Object object = this.fBeanModel.getDocumentLock();
        synchronized (object) {
            this.updateBDM(model);
        }
    }
}

