/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.codegen.core.IDiagramModelInstance;
import org.eclipse.ve.internal.java.codegen.core.TransientErrorEvent;
import org.eclipse.ve.internal.java.codegen.java.CodeSnippetModelBuilder;
import org.eclipse.ve.internal.java.codegen.java.CodeSnippetTranslatorHelper;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.DefaultCodeDelta;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.model.ICodeDelta;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.codegen.util.ExpressionParser;
import org.eclipse.ve.internal.java.codegen.util.ICancelMonitor;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class CodeSnippetTranslator {
    public static String CODE_SNIPPET_CLASSNAME = "CodeSnippet_2";
    protected int insertOffset = -1;
    protected int insertLength = -1;
    private List errorStrore = new ArrayList();
    protected int[] importStarts;
    protected int[] importEnds;
    protected int[] fieldStarts;
    protected int[] fieldEnds;
    protected int[] methodStarts;
    protected int[] methodEnds;
    protected String entireCode = null;
    protected String packageName = null;
    protected String extendsClass = null;
    protected String[] implementsInterfaces = null;
    protected ISourceRange[] methods = null;
    protected ISourceRange[] fields = null;
    protected ISourceRange[] imports = null;
    protected ICancelMonitor cancelMonitor = null;
    protected ICompilationUnit referenceCU = null;
    protected int changedIndex = -1;
    protected boolean isChangedElementMethod = false;
    protected String[] methodHandles = null;
    protected String[] methodSkeletons = null;
    protected String[] innerTypeHandles = null;
    protected String[] innerTypeSkeletons = null;
    protected List offendingLines = null;
    IDiagramModelInstance fDiagram = null;

    public CodeSnippetTranslator(String entireCode, String packageName, String extendsClass, String[] implementsInterfaces, ISourceRange[] imports, ISourceRange[] fields, ISourceRange[] methods, ICancelMonitor cancelMonitor, ICompilationUnit referenceCU, String[] methodHandles, String[] methodSkeletons, String[] innerTypeHandles, String[] innerTypeSkeletons, int changedIndex, boolean changedType) {
        this.entireCode = entireCode;
        this.packageName = packageName;
        this.extendsClass = extendsClass;
        this.implementsInterfaces = implementsInterfaces;
        this.imports = imports;
        this.fields = fields;
        this.methods = methods;
        this.cancelMonitor = cancelMonitor;
        this.referenceCU = referenceCU;
        this.changedIndex = changedIndex;
        this.isChangedElementMethod = changedType;
        this.methodHandles = methodHandles;
        this.methodSkeletons = methodSkeletons;
        this.innerTypeHandles = innerTypeHandles;
        this.innerTypeSkeletons = innerTypeSkeletons;
        if (this.cancelMonitor == null) {
            this.cancelMonitor = new ICancelMonitor(){

                public boolean isCanceled() {
                    return false;
                }

                public void setCompleted() {
                }

                public boolean isCompleted(boolean wantToWait) {
                    return false;
                }
            };
        }
    }

    public void setDiagram(IDiagramModelInstance d) {
        this.fDiagram = d;
    }

    protected String getCodeSnippetClass(int whichMethod, boolean putOtherMethods) {
        StringBuffer src = new StringBuffer();
        try {
            StringBuffer prefix = new StringBuffer();
            if (this.packageName != null) {
                prefix.append("package " + this.packageName + " ;\n");
            }
            if (this.imports != null) {
                this.importStarts = new int[this.imports.length];
                this.importEnds = new int[this.imports.length];
                int ic = 0;
                while (ic < this.imports.length) {
                    this.importStarts[ic] = prefix.length();
                    if (this.imports[ic] != null) {
                        prefix.append(String.valueOf(this.entireCode.substring(this.imports[ic].getOffset(), this.imports[ic].getOffset() + this.imports[ic].getLength())) + "\n");
                    }
                    this.importEnds[ic] = prefix.length();
                    ++ic;
                }
            }
            prefix.append("public class " + CODE_SNIPPET_CLASSNAME);
            if (this.extendsClass != null && this.extendsClass.length() > 0) {
                prefix.append(" extends " + this.extendsClass);
            }
            if (this.implementsInterfaces != null && this.implementsInterfaces.length > 0) {
                prefix.append(" implements ");
                int i = 0;
                while (i < this.implementsInterfaces.length) {
                    if (this.implementsInterfaces[i] != null) {
                        prefix.append(this.implementsInterfaces[i]);
                        if (i < this.implementsInterfaces.length - 1) {
                            prefix.append(", ");
                        }
                    }
                    ++i;
                }
            }
            prefix.append("{\n");
            if (this.innerTypeSkeletons != null && this.innerTypeSkeletons.length > 0) {
                int innerC = 0;
                while (innerC < this.innerTypeSkeletons.length) {
                    prefix.append(this.innerTypeSkeletons[innerC]);
                    ++innerC;
                }
            }
            prefix.append("public " + CODE_SNIPPET_CLASSNAME + "(){super();}\n");
            StringBuffer postfix = new StringBuffer("\n}");
            src.append((Object)prefix);
            StringBuffer infix = new StringBuffer();
            if (this.fields != null) {
                this.fieldStarts = new int[this.fields.length];
                this.fieldEnds = new int[this.fields.length];
                int fc = 0;
                while (fc < this.fields.length) {
                    this.fieldStarts[fc] = src.length() + infix.length();
                    if (this.fields[fc] != null) {
                        infix.append(String.valueOf(this.entireCode.substring(this.fields[fc].getOffset(), this.fields[fc].getOffset() + this.fields[fc].getLength())) + "\n");
                    }
                    this.fieldEnds[fc] = src.length() + infix.length();
                    ++fc;
                }
            }
            if (this.methods != null) {
                int mc = 0;
                while (mc < this.methods.length) {
                    if (mc == whichMethod) {
                        this.methodStarts = new int[1];
                        this.methodEnds = new int[1];
                        this.methodStarts[0] = src.length() + infix.length();
                        if (this.methods[whichMethod] != null) {
                            infix.append(String.valueOf(this.entireCode.substring(this.methods[whichMethod].getOffset(), this.methods[whichMethod].getOffset() + this.methods[whichMethod].getLength())) + "\n");
                        }
                        this.methodEnds[0] = src.length() + infix.length();
                    } else if (putOtherMethods && this.methodSkeletons != null && this.methodSkeletons[mc] != null) {
                        infix.append(this.methodSkeletons[mc]);
                    }
                    ++mc;
                }
            }
            src.append((Object)infix);
            src.append((Object)postfix);
        }
        catch (Exception e) {
            JavaVEPlugin.log((Throwable)e, (int)5);
        }
        return src.toString();
    }

    protected ICodeDelta generateFieldsDelta(IBeanDeclModel oldModel, IBeanDeclModel newModel, List offenders, String methodHandle, String source) throws CodeGenException {
        return null;
    }

    protected ICodeDelta generateTypesDelta(IBeanDeclModel oldModel, IBeanDeclModel newModel, List offenders, String methodHandle, String source) throws CodeGenException {
        if (methodHandle == null) {
            return null;
        }
        CodeMethodRef oldMethod = oldModel.getMethodInitializingABean(methodHandle);
        if (oldMethod != null) {
            if (newModel == null) {
                return null;
            }
            if (newModel.getMethodInitializingABean(methodHandle) == null) {
                DefaultCodeDelta delta = new DefaultCodeDelta();
                IBeanDeclModel newBDM = CodeSnippetTranslatorHelper.createShadowBDM(oldModel, methodHandle);
                delta.addDeltaMethod(newBDM.getMethodInitializingABean(methodHandle));
                delta.setElementStatus(newBDM.getMethodInitializingABean(methodHandle), 2);
                return delta;
            }
        } else if (newModel != null && newModel.getMethodInitializingABean(methodHandle) != null) {
            if (source != null || source.length() > 0) {
                DefaultCodeDelta delta = new DefaultCodeDelta();
                delta.addDeltaMethod(newModel.getMethodInitializingABean(methodHandle));
                delta.setElementStatus(newModel.getMethodInitializingABean(methodHandle), 4);
                return delta;
            }
            return null;
        }
        return null;
    }

    protected ICodeDelta generateOffsetUpdatingDelta(IBeanDeclModel oldModel, String methodHandle, String source) {
        DefaultCodeDelta delta = new DefaultCodeDelta();
        List ranges = CodeSnippetTranslatorHelper.removeAllComments(source);
        ranges.remove(0);
        CodeMethodRef method = oldModel.getMethodInitializingABean(methodHandle);
        if (method == null) {
            return delta;
        }
        IBeanDeclModel shadowModel = CodeSnippetTranslatorHelper.createShadowBDM(oldModel, methodHandle);
        if (shadowModel.getMethodInitializingABean(methodHandle) == null) {
            return delta;
        }
        shadowModel.getMethodInitializingABean(methodHandle).setContent(source);
        Iterator newExpressions = shadowModel.getMethodInitializingABean(methodHandle).getExpressions();
        Iterator oldExpressions = oldModel.getMethodInitializingABean(methodHandle).getExpressions();
        delta.addDeltaMethod(shadowModel.getMethodInitializingABean(methodHandle));
        delta.setElementStatus(delta.getDeltaMethod(), 32);
        while (newExpressions.hasNext() && oldExpressions.hasNext()) {
            CodeExpressionRef newExpression = (CodeExpressionRef)newExpressions.next();
            CodeExpressionRef oldExpression = (CodeExpressionRef)oldExpressions.next();
            int index = -1;
            index = source.indexOf(oldExpression.getCodeContent(), index + 1);
            int i = 0;
            while (i < ranges.size() && index > -1) {
                ISourceRange range = (ISourceRange)ranges.get(i);
                if (range.getOffset() <= index && range.getOffset() + range.getLength() > index) {
                    index = source.indexOf(oldExpression.getCodeContent(), index + 1);
                }
                ++i;
            }
            if (index > -1) {
                delta.setElementStatus(newExpression, 16);
                newExpression.setContent(new ExpressionParser(source, index, oldExpression.getCodeContent().length()));
                newExpression.setOffset(index - newExpression.getFillerContent().length());
                continue;
            }
            delta.setElementStatus(newExpression, 2);
            newExpression.setState(128, true);
        }
        return delta;
    }

    protected void collectChangedExpressions(List oldExpressions, List newExpressions, Iterator oldI, Iterator newI, DefaultCodeDelta delta, List offenders) throws CodeGenException {
        while (oldI != null && oldI.hasNext()) {
            oldExpressions.add(oldI.next());
        }
        while (newI != null && newI.hasNext()) {
            newExpressions.add(newI.next());
        }
        int oldC = 0;
        while (oldC < oldExpressions.size() && !this.cancelMonitor.isCanceled()) {
            CodeExpressionRef oe = (CodeExpressionRef)oldExpressions.get(oldC);
            int newC = 0;
            while (newC < newExpressions.size() && !this.cancelMonitor.isCanceled()) {
                CodeExpressionRef ne = (CodeExpressionRef)newExpressions.get(newC);
                int index = this.isExpressionPresentInOffenders(ne, offenders);
                if (index > -1) {
                    ne.setState(128, true);
                    TransientErrorEvent event = (TransientErrorEvent)offenders.get(index);
                    event.setRefObject(oe.getBean().getEObject());
                } else {
                    ne.setState(128, false);
                }
                int res = oe.isEquivalent(ne);
                if (res == 0) {
                    delta.setElementStatus(ne, 8);
                    oldExpressions.remove(oe);
                    newExpressions.remove(ne);
                    --oldC;
                    --newC;
                    break;
                }
                if (res == 1) {
                    if (ne.getOffset() == oe.getOffset()) {
                        delta.setElementStatus(ne, 1);
                    } else {
                        delta.setElementStatus(ne, 16);
                    }
                    oldExpressions.remove(oe);
                    newExpressions.remove(ne);
                    --oldC;
                    --newC;
                    break;
                }
                ++newC;
            }
            if (newC == newExpressions.size()) {
                if (oe.getMethod().getMethodHandle().equals(delta.getDeltaMethod().getMethodHandle())) {
                    delta.setElementStatus(oe, 2);
                } else {
                    delta.setElementStatus(oe, 1);
                }
                oldExpressions.remove(oe);
                --oldC;
            }
            ++oldC;
        }
    }

    protected void processNewlyCollectedExpressions(IBeanDeclModel oldModel, List newExpressions, DefaultCodeDelta delta, List offenders) {
        int newC = 0;
        while (newC < newExpressions.size() && !this.cancelMonitor.isCanceled()) {
            int index = this.isExpressionPresentInOffenders((CodeExpressionRef)newExpressions.get(newC), offenders);
            if (index > -1) {
                TransientErrorEvent event = (TransientErrorEvent)offenders.get(index);
                BeanPart beanPart = oldModel.getABean(((CodeExpressionRef)newExpressions.get(newC)).getBean().getUniqueName());
                if (beanPart != null) {
                    event.setRefObject(beanPart.getEObject());
                }
                delta.setElementStatus((CodeExpressionRef)newExpressions.get(newC), 32);
            } else {
                delta.setElementStatus((CodeExpressionRef)newExpressions.get(newC), 4);
            }
            ++newC;
        }
    }

    protected void processPropertyExpressions(IBeanDeclModel oldModel, BeanPart oldBeanPart, BeanPart newBeanPart, DefaultCodeDelta delta, List offenders) throws CodeGenException {
        ArrayList oldExpressions = new ArrayList();
        ArrayList newExpressions = new ArrayList();
        Iterator oldI = oldBeanPart == null ? null : oldBeanPart.getRefExpressions().iterator();
        Iterator newI = newBeanPart == null ? null : newBeanPart.getRefExpressions().iterator();
        newBeanPart.setProxy(oldBeanPart);
        this.collectChangedExpressions(oldExpressions, newExpressions, oldI, newI, delta, offenders);
        newBeanPart.setProxy(null);
        this.processNewlyCollectedExpressions(oldModel, newExpressions, delta, offenders);
    }

    protected void processEventExpressions(IBeanDeclModel oldModel, BeanPart oldBeanPart, BeanPart newBeanPart, DefaultCodeDelta delta, List offenders) throws CodeGenException {
        ArrayList oldExpressions = new ArrayList();
        ArrayList newExpressions = new ArrayList();
        Iterator oldI = oldBeanPart == null ? null : oldBeanPart.getRefEventExpressions().iterator();
        Iterator newI = newBeanPart == null ? null : newBeanPart.getRefEventExpressions().iterator();
        newBeanPart.setProxy(oldBeanPart);
        this.collectChangedExpressions(oldExpressions, newExpressions, oldI, newI, delta, offenders);
        newBeanPart.setProxy(null);
        this.processNewlyCollectedExpressions(oldModel, newExpressions, delta, offenders);
    }

    protected ICodeDelta generateMethodsDelta(IBeanDeclModel oldModel, IBeanDeclModel newModel, List offenders, String methodHandle, String source) throws CodeGenException {
        if (newModel == null) {
            return this.generateOffsetUpdatingDelta(oldModel, methodHandle, source);
        }
        DefaultCodeDelta delta = new DefaultCodeDelta();
        ArrayList<BeanPart> originalBeanList = new ArrayList<BeanPart>();
        CodeMethodRef mr = oldModel.getMethodInitializingABean(methodHandle);
        if (mr == null) {
            return null;
        }
        Iterator itr = oldModel.getBeans().iterator();
        while (itr.hasNext()) {
            BeanPart b = (BeanPart)itr.next();
            if (!mr.equals(b.getInitMethod())) continue;
            originalBeanList.add(b);
        }
        int beanCount = 0;
        while (beanCount < newModel.getBeans().size() && !this.cancelMonitor.isCanceled()) {
            BeanPart newBeanPart = (BeanPart)newModel.getBeans().get(beanCount);
            BeanPart oldBeanPart = oldModel.getABean(newBeanPart.getUniqueName());
            if (oldBeanPart != null) {
                ((AbstractCollection)originalBeanList).remove(oldBeanPart);
            }
            if (oldBeanPart != null || newBeanPart.getInitMethod() != null) {
                CodeMethodRef oldInitMethod;
                CodeMethodRef newInitMethod = newBeanPart.getInitMethod();
                CodeMethodRef codeMethodRef = oldInitMethod = oldBeanPart == null ? null : oldBeanPart.getInitMethod();
                if ((newInitMethod != null || oldInitMethod != null && oldInitMethod.getMethodHandle().equals(methodHandle)) && (newInitMethod == null || oldInitMethod == null || !newInitMethod.getContent().equals(oldInitMethod.getContent()))) {
                    CodeMethodRef existingMR = newInitMethod != null ? newInitMethod : oldInitMethod;
                    if (delta.getDeltaMethod() == null) {
                        delta.addDeltaMethod(existingMR);
                        delta.setElementStatus(existingMR, 8);
                    }
                    this.processPropertyExpressions(oldModel, oldBeanPart, newBeanPart, delta, offenders);
                    this.processEventExpressions(oldModel, oldBeanPart, newBeanPart, delta, offenders);
                }
            }
            ++beanCount;
        }
        if (delta != null && delta.getDeltaMethod() != null) {
            Iterator iter = delta.getDeltaMethod().getExpressions();
            while (iter.hasNext()) {
                CodeExpressionRef exp = (CodeExpressionRef)iter.next();
                if (delta.getElementStatus(exp) >= 0) continue;
                delta.setElementStatus(exp, 1);
            }
        }
        if (originalBeanList.size() != 0) {
            throw new CodeGenException("Internal Beans were deleted; Reload - this is not an error");
        }
        return delta;
    }

    private int isExpressionPresentInOffenders(CodeExpressionRef exp, List offenders) {
        String expCode = exp.getCodeContent();
        int i = 0;
        while (i < offenders.size()) {
            TransientErrorEvent evt = (TransientErrorEvent)offenders.get(i);
            String offCode = evt.getSource();
            if (offCode != null && offCode.equals(expCode)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private IBeanDeclModel build(EditDomain d) {
        try {
            if (this.isChangedElementMethod) {
                this.offendingLines = CodeSnippetTranslatorHelper.determineOffendingParts(this.getCodeSnippetClass(this.changedIndex, true).toString(), CODE_SNIPPET_CLASSNAME, this.referenceCU.getJavaProject(), this.changedIndex);
                if (this.offendingLines == null) {
                    CodeSnippetModelBuilder mb = new CodeSnippetModelBuilder(d, this.getCodeSnippetClass(this.changedIndex, false).toString(), new String[]{this.methodHandles[this.changedIndex]}, this.importStarts, this.importEnds, this.fieldStarts, this.fieldEnds, this.methodStarts, this.methodEnds, this.referenceCU);
                    mb.setDiagram(this.fDiagram);
                    IBeanDeclModel newModel = mb.build();
                    return newModel;
                }
                if (this.offendingLines.get(0) instanceof TransientErrorEvent) {
                    this.errorStrore.addAll(this.offendingLines);
                    CodeSnippetModelBuilder mb = new CodeSnippetModelBuilder(d, this.getCodeSnippetClass(this.changedIndex, false).toString(), new String[]{this.methodHandles[this.changedIndex]}, this.importStarts, this.importEnds, this.fieldStarts, this.fieldEnds, this.methodStarts, this.methodEnds, this.referenceCU);
                    mb.setDiagram(this.fDiagram);
                    IBeanDeclModel newModel = mb.build();
                    return newModel;
                }
                int i = 0;
                while (i < this.offendingLines.size()) {
                    if (this.offendingLines.get(i) instanceof IProblem) {
                        IProblem problem = (IProblem)this.offendingLines.get(i);
                        TransientErrorEvent event = new TransientErrorEvent("typeParserFatal", null, problem.getSourceStart(), problem.getSourceEnd(), problem.getMessage(), null, this.entireCode);
                        this.errorStrore.add(event);
                    }
                    ++i;
                }
                return null;
            }
        }
        catch (Exception e) {
            JavaVEPlugin.log((Object)"*** Code Snippet in Error", (int)5);
            JavaVEPlugin.log((Throwable)e, (int)5);
            JavaVEPlugin.log((Object)"\n", (int)5);
        }
        return null;
    }

    private static String removeInternalReferences(String msg, String realTypeName) {
        int to;
        int from;
        String newMsg = msg;
        if (newMsg.indexOf(CODE_SNIPPET_CLASSNAME) > -1) {
            from = newMsg.indexOf(CODE_SNIPPET_CLASSNAME);
            to = from + CODE_SNIPPET_CLASSNAME.length();
            newMsg = String.valueOf(newMsg.substring(0, from)) + realTypeName + newMsg.substring(to, msg.length());
        }
        if (newMsg.indexOf("Wrapper_Class_For_Entries1") > -1) {
            from = newMsg.indexOf("Wrapper_Class_For_Entries1");
            to = from + "Wrapper_Class_For_Entries1".length();
            newMsg = String.valueOf(newMsg.substring(0, from)) + realTypeName + newMsg.substring(to, msg.length());
        }
        return newMsg;
    }

    public ICodeDelta generateCodeDelta(IBeanDeclModel mainModel, String methodHandle, String source) throws CodeGenException {
        ICodeDelta typeDelta;
        this.resetErrorStore();
        IBeanDeclModel deltaModel = this.build(mainModel.getDomain());
        if (this.cancelMonitor != null && this.cancelMonitor.isCanceled()) {
            return null;
        }
        if (mainModel == null) {
            return null;
        }
        if (this.offendingLines == null) {
            this.offendingLines = new ArrayList();
        }
        if ((typeDelta = this.generateTypesDelta(mainModel, deltaModel, this.offendingLines, methodHandle, source)) != null) {
            return typeDelta;
        }
        ICodeDelta fieldsDelta = this.generateFieldsDelta(mainModel, deltaModel, this.offendingLines, methodHandle, source);
        if (fieldsDelta != null) {
            return fieldsDelta;
        }
        ICodeDelta methodsDelta = this.generateMethodsDelta(mainModel, deltaModel, this.offendingLines, methodHandle, source);
        return methodsDelta;
    }

    public List getErrorsInCodeDelta() {
        ArrayList tempHolder = new ArrayList(this.errorStrore);
        Iterator itr = tempHolder.iterator();
        while (itr.hasNext()) {
            TransientErrorEvent evt = (TransientErrorEvent)itr.next();
            evt.setMessage(CodeSnippetTranslator.removeInternalReferences(evt.getMessage(), CodeGenUtil.getMainType(this.referenceCU).getElementName()));
        }
        this.resetErrorStore();
        return tempHolder;
    }

    private void resetErrorStore() {
        this.errorStrore = new ArrayList();
    }

    public static int[] indexOfIgnoringSpace(String main, String find) {
        if (main == null || main.length() < 1 || find == null || find.length() < 1) {
            return new int[]{-1, -1};
        }
        char[] mainTokens = main.toCharArray();
        StringTokenizer tokenizer = new StringTokenizer(find, " \t", false);
        String findS = new String();
        while (tokenizer.hasMoreTokens()) {
            findS = findS.concat(tokenizer.nextToken());
        }
        char[] findTokens = findS.toCharArray();
        int tokenFindStart = -1;
        int tokenFindEnd = -1;
        int mc = 0;
        while (mc < mainTokens.length) {
            if (!Character.isWhitespace(mainTokens[mc])) {
                tokenFindStart = -1;
                tokenFindEnd = -1;
                if (mainTokens[mc] == findTokens[0]) {
                    tokenFindStart = mc;
                    int fc = 0;
                    int nc = 0;
                    nc = mc;
                    while (fc < findTokens.length && nc < mainTokens.length) {
                        if (!Character.isWhitespace(mainTokens[nc])) {
                            if (mainTokens[nc] != findTokens[fc]) break;
                            ++fc;
                        }
                        ++nc;
                    }
                    if (fc == findTokens.length) {
                        tokenFindEnd = nc - 1;
                        break;
                    }
                }
            }
            ++mc;
        }
        if (tokenFindStart > -1 && tokenFindEnd > -1 && tokenFindStart <= tokenFindEnd) {
            return new int[]{tokenFindStart, tokenFindEnd + 1};
        }
        return new int[]{-1, -1};
    }

    public static int indexOfCorrespondingBracket(String str, int bracketIndex) {
        char br = str.charAt(bracketIndex);
        char cbr = ' ';
        int direction = 0;
        if (br == ')') {
            cbr = '(';
            direction = -1;
        } else if (br == '(') {
            cbr = ')';
            direction = 1;
        } else {
            return -1;
        }
        if (br == cbr || direction == 0) {
            return -1;
        }
        char[] chars = str.toCharArray();
        int stackCount = 0;
        int i = bracketIndex;
        while (i < chars.length && i > -1) {
            if (chars[i] == br) {
                ++stackCount;
            }
            if (chars[i] == cbr) {
                --stackCount;
            }
            if (stackCount == 0) {
                return i;
            }
            i += direction;
        }
        return -1;
    }
}

