/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.List;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jem.internal.beaninfo.BeanEvent;
import org.eclipse.jem.internal.beaninfo.EventSetDecorator;
import org.eclipse.ve.internal.java.codegen.java.EventInvocationHelper;
import org.eclipse.ve.internal.java.codegen.java.SourceVisitor;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeEventRef;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jcm.AbstractEventInvocation;
import org.eclipse.ve.internal.jcm.EventInvocation;
import org.eclipse.ve.internal.jcm.JCMFactory;
import org.eclipse.ve.internal.jcm.PropertyChangeEventInvocation;

public class EventExpressionVisitor
extends SourceVisitor {
    CodeMethodRef fMethod;
    CodeEventRef fExpression;
    BeanPart fBean;
    CompilationUnitDeclaration fDom;
    List fEventSigs;

    EventExpressionVisitor(BeanPart b, Statement stmt, IBeanDeclModel model, List eSigs, CompilationUnitDeclaration dom) {
        super((AstNode)stmt, model, null);
        this.fMethod = b.getInitMethod();
        this.fBean = b;
        this.fExpression = new CodeEventRef(stmt, this.fMethod, dom);
        this.fDom = dom;
        this.fEventSigs = eSigs;
    }

    EventExpressionVisitor(BeanPart b, CodeMethodRef mref, Statement stmt, IBeanDeclModel model, List eSigs, CompilationUnitDeclaration dom) {
        super((AstNode)stmt, model, null);
        this.fMethod = mref;
        this.fBean = b;
        this.fExpression = new CodeEventRef(stmt, this.fMethod, dom);
        this.fDom = dom;
        this.fEventSigs = eSigs;
    }

    protected void processAMessageSend() {
        PropertyChangeEventInvocation ei;
        MessageSend stmt = (MessageSend)this.fExpression.getExpression();
        if (stmt == null) {
            return;
        }
        String selector = new String(stmt.selector);
        if (selector.equals("addPropertyChangeListener")) {
            ei = JCMFactory.eINSTANCE.createPropertyChangeEventInvocation();
        } else {
            EventSetDecorator ed = null;
            int i = 0;
            while (i < this.fEventSigs.size()) {
                if (((EventSetDecorator)this.fEventSigs.get(i)).getAddListenerMethod().getName().equals(selector)) {
                    ed = (EventSetDecorator)this.fEventSigs.get(i);
                    break;
                }
                ++i;
            }
            if (ed == null) {
                return;
            }
            ei = EventInvocationHelper.getNewEventInvocation(this.fModel.getCompositionModel());
            BeanEvent be = (BeanEvent)ed.getEModelElement();
            ((EventInvocation)ei).setEvent(be);
        }
        this.fExpression.setBean(this.fBean);
        this.fExpression.setEventInvocation((AbstractEventInvocation)ei);
        this.fMethod.setModel(this.fModel);
    }

    public void visit() {
        if (this.fExpression.getExpression() instanceof MessageSend) {
            this.processAMessageSend();
        } else {
            JavaVEPlugin.log((Object)("\t[Event] ExpressionVisitor: *** did not process Expression:" + this.fExpression), (int)2);
        }
    }

    public String toString() {
        return "EventExpression(" + this.fVisitedNode + ")";
    }
}

