/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jem.internal.beaninfo.EventSetDecorator;
import org.eclipse.ve.internal.java.codegen.java.EventExpressionVisitor;
import org.eclipse.ve.internal.java.codegen.java.MethodVisitor;
import org.eclipse.ve.internal.java.codegen.java.TypeVisitor;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.CodeTypeRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class EventMethodVisitor
extends MethodVisitor {
    List fESigs;
    CompilationUnitDeclaration fDom;
    BeanPart fBean;
    String fPrefixConstraint = null;
    static final String fDefaultPrefix = "add";

    public EventMethodVisitor(BeanPart b, IBeanDeclModel model, List signitures, CompilationUnitDeclaration dom) {
        this(b.getInitMethod().getDeclMethod(), b, model, signitures, dom);
    }

    public EventMethodVisitor(AbstractMethodDeclaration method, BeanPart b, IBeanDeclModel model, List signitures, CompilationUnitDeclaration dom) {
        this(method, b.getInitMethod(), b, model, signitures, dom);
    }

    public EventMethodVisitor(AbstractMethodDeclaration method, CodeMethodRef m, BeanPart b, IBeanDeclModel model, List signitures, CompilationUnitDeclaration dom) {
        super(method, model, null, m);
        this.fBean = b;
        this.fESigs = signitures;
        this.fDom = dom;
        boolean useDefault = true;
        int i = 0;
        while (i < this.fESigs.size()) {
            if (!((EventSetDecorator)this.fESigs.get(i)).getAddListenerMethod().getName().startsWith(fDefaultPrefix)) {
                useDefault = false;
                break;
            }
            ++i;
        }
        if (useDefault) {
            this.fPrefixConstraint = fDefaultPrefix;
        }
    }

    protected void processStatementArray(Statement[] statements) throws CodeGenException {
        if (statements != null) {
            int i = 0;
            while (i < statements.length) {
                this.processAStatement(statements[i]);
                ++i;
            }
        }
    }

    protected CodeMethodRef getMethodRef(AbstractMethodDeclaration method, CodeTypeRef tRef, String methodHandle, ISourceRange range, String content) {
        CodeMethodRef m;
        Iterator itr = this.fMethod.getTypeRef().getMethods();
        while (itr.hasNext()) {
            m = (CodeMethodRef)itr.next();
            if (!methodHandle.equals(m.getMethodHandle())) continue;
            return m;
        }
        m = new CodeMethodRef(method, tRef, methodHandle, range, content);
        return m;
    }

    protected void processMessageSend(MessageSend stmt) throws CodeGenException {
        String selector;
        if (stmt.receiver instanceof ThisReference && !(stmt.receiver instanceof SuperReference)) {
            MethodVisitor newVisitor = null;
            if (stmt.arguments == null) {
                String method = new String(stmt.selector);
                AbstractMethodDeclaration[] methods = this.fDom.types[0].methods;
                IMethod[] cuMethods = TypeVisitor.getCUMethods(methods, CodeGenUtil.getMethods(this.fModel.getCompilationUnit()), this.fModel);
                int idx = 0;
                while (idx < methods.length) {
                    if (methods[idx] instanceof MethodDeclaration) {
                        MethodDeclaration md = (MethodDeclaration)methods[idx];
                        if (md.arguments == null && method.equals(new String(md.selector))) {
                            if (!cuMethods[idx].getElementName().equals(new String(md.selector))) {
                                throw new CodeGenException("Not the same JCMMethod");
                            }
                            try {
                                CodeMethodRef mref = this.getMethodRef((AbstractMethodDeclaration)md, this.fMethod.getTypeRef(), cuMethods[idx].getHandleIdentifier(), cuMethods[idx].getSourceRange(), cuMethods[idx].getSource());
                                newVisitor = new EventMethodVisitor((AbstractMethodDeclaration)md, mref, this.fBean, this.fModel, this.fESigs, this.fDom);
                            }
                            catch (JavaModelException javaModelException) {}
                            break;
                        }
                    }
                    ++idx;
                }
                return;
            }
            if (newVisitor != null) {
                newVisitor.visit();
            }
        }
        if (this.fPrefixConstraint != null && !(selector = new String(stmt.selector)).startsWith(this.fPrefixConstraint)) {
            return;
        }
        if (stmt.receiver instanceof MessageSend) {
            CodeMethodRef mref = this.fBean.getReturnedMethod();
            MessageSend ms = (MessageSend)stmt.receiver;
            if (mref != null && mref.getMethodName().equals(new String(ms.selector))) {
                new EventExpressionVisitor(this.fBean, this.fMethod, (Statement)stmt, this.fModel, this.fESigs, this.fDom).visit();
            }
        } else if ((stmt.receiver instanceof SingleNameReference || stmt.receiver instanceof ThisReference) && this.fBean.getSimpleName().equals(stmt.receiver.toString())) {
            new EventExpressionVisitor(this.fBean, this.fMethod, (Statement)stmt, this.fModel, this.fESigs, this.fDom).visit();
        }
    }

    protected void processAStatement(Statement stmt) throws CodeGenException {
        if (stmt instanceof Block) {
            this.processBlockStatement((Block)stmt);
        } else if (stmt instanceof TryStatement) {
            this.processTryStatement((TryStatement)stmt);
        } else if (stmt instanceof IfStatement) {
            this.processIFStatement((IfStatement)stmt);
        } else if (stmt instanceof SynchronizedStatement) {
            this.processSynchStatement((SynchronizedStatement)stmt);
        } else if (stmt instanceof MessageSend) {
            this.processMessageSend((MessageSend)stmt);
        } else if (stmt instanceof Expression) {
            new EventExpressionVisitor(this.fBean, this.fMethod, (Statement)((Expression)stmt), this.fModel, this.fESigs, this.fDom).visit();
        } else {
            JavaVEPlugin.log((Object)("\t[Event] MethodVisitor() skiping: " + stmt), (int)2);
        }
    }

    public String toString() {
        return "EventMethodVisitor(" + this.fBean + "," + this.fMethod.getMethodName() + ")";
    }
}

