/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.ve.internal.cde.core.CDEHack;
import org.eclipse.ve.internal.java.codegen.java.BeanDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenAdapter;
import org.eclipse.ve.internal.java.codegen.java.MethodTextGenerator;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenInfoMissing;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class MethodAnalyzer {
    protected IMethod fMethod;
    protected IBeanDeclModel fModel;
    protected String fSource;
    protected CodeMethodRef fMethodRef;
    protected String flastFiller;

    public MethodAnalyzer(IMethod method, IBeanDeclModel model) {
        this.fModel = model;
        this.fMethod = method;
        if (this.fMethod != null) {
            try {
                this.fSource = method.getSource();
            }
            catch (Exception e) {
                JavaVEPlugin.log((Object)("MethodAnalyzer(" + method.getElementName() + "): " + e), (int)5);
                JavaVEPlugin.log((Throwable)e, (int)5);
            }
        }
    }

    protected IMethod nextSiebling() throws JavaModelException {
        IMethod[] methods = this.fMethod.getDeclaringType().getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].equals(this.fMethod)) {
                if (i + 1 >= methods.length) {
                    return null;
                }
                return methods[i + 1];
            }
            ++i;
        }
        return null;
    }

    protected boolean hasContentChanged() {
        boolean result;
        try {
            result = !this.fMethodRef.getContent().equals(this.fMethod.getSource());
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        return result;
    }

    protected void updateMethodContent(String newContent) throws CodeGenException {
        this.fMethodRef.setContent(newContent);
    }

    protected void removeDeletedExpressions(Vector list) {
        int i = 0;
        while (i < list.size()) {
            this.fMethodRef.removeExpressionRef((CodeExpressionRef)list.elementAt(i));
            ((CodeExpressionRef)list.elementAt(i)).getBean().removeRefExpression((CodeExpressionRef)list.elementAt(i));
            ++i;
        }
    }

    protected int reflectExistingSource(StringBuffer buf, Vector impactedBeans) throws CodeGenException {
        int left = 0;
        int right = -1;
        Iterator itr = this.fMethodRef.getExpressions();
        Vector<CodeExpressionRef> deleteCandidate = new Vector<CodeExpressionRef>();
        if (itr.hasNext()) {
            while (itr.hasNext()) {
                CodeExpressionRef exp = (CodeExpressionRef)itr.next();
                if (!impactedBeans.contains(exp.getBean())) {
                    impactedBeans.add(exp.getBean());
                }
                if ((right = exp.getOffset()) < left) {
                    throw new CodeGenException("Bad expression offset");
                }
                if (right - left > 0) {
                    buf.append(this.fSource.substring(left, right));
                }
                left = right + exp.getLen();
                String pc = exp.getContent();
                exp.refreshFromComposition();
                exp.setOffset(buf.length());
                if (!exp.isAnyStateSet() || exp.isStateSet(1)) {
                    CDEHack.fixMe((String)"Need to deal with comments associated with statement");
                    deleteCandidate.add(exp);
                    JavaVEPlugin.log((Object)("\tDeleting: " + exp), (int)2);
                    continue;
                }
                if (!exp.isStateSet(4) || exp.isStateSet(16)) continue;
                buf.append(exp.getContent());
                if (pc != null && !pc.equals(exp.getContent())) {
                    JavaVEPlugin.log((Object)("\tUpdating: " + pc + " -> " + exp.getContent()), (int)2);
                }
                CDEHack.fixMe((String)"clean this up");
                this.flastFiller = exp.getFillerContent();
            }
        }
        this.removeDeletedExpressions(deleteCandidate);
        if (this.flastFiller == null) {
            this.flastFiller = "";
        }
        return left;
    }

    protected String GenerateAttribute(StringBuffer buf, EStructuralFeature sf, BeanPart bean, int Offset, String filler) throws CodeGenException {
        CodeExpressionRef exp = new CodeExpressionRef(this.fMethodRef, bean);
        exp.setState(2, true);
        exp.setFillerContent(filler);
        exp.setOffset(Offset);
        return exp.getContent();
    }

    protected boolean isSourceExists(Notifier elm, EObject bean, EStructuralFeature sf) throws CodeGenException {
        boolean result = true;
        if (elm != null) {
            if (EcoreUtil.getExistingAdapter((Notifier)elm, (Object)ICodeGenAdapter.JVE_CODE_GEN_TYPE) == null) {
                result = false;
            }
        } else {
            BeanDecoderAdapter a = (BeanDecoderAdapter)EcoreUtil.getExistingAdapter((Notifier)bean, (Object)ICodeGenAdapter.JVE_CODEGEN_BEAN_PART_ADAPTER);
            if (a == null) {
                throw new CodeGenException("No Adapter" + bean);
            }
            if (a.getNullValuedAdapter(sf) == null) {
                result = false;
            }
        }
        if (elm instanceof EObject && MethodTextGenerator.isNotToBeCodedAttribute(sf, bean)) {
            result = true;
        }
        return result;
    }

    protected void appendNewAttributes(StringBuffer buf, BeanPart bean, String filler) throws CodeGenException {
        EObject obj = bean.getEObject();
        Iterator itr = ((JavaClass)obj.eClass()).getAllProperties().iterator();
        while (itr.hasNext()) {
            EStructuralFeature sf = (EStructuralFeature)itr.next();
            if (!obj.eIsSet(sf)) continue;
            Object val = obj.eGet(sf);
            if (sf.isMany()) {
                Iterator vItr = ((List)val).iterator();
                while (vItr.hasNext()) {
                    this.appendNewAttribute(buf, bean, filler, obj, sf, vItr.next());
                }
                continue;
            }
            this.appendNewAttribute(buf, bean, filler, obj, sf, val);
        }
    }

    private void appendNewAttribute(StringBuffer buf, BeanPart bean, String filler, EObject obj, EStructuralFeature sf, Object val) throws CodeGenException {
        Notifier elm;
        if ((val == null || val instanceof Notifier) && !this.isSourceExists(elm = (Notifier)val, obj, sf)) {
            String src = this.GenerateAttribute(buf, sf, bean, buf.length(), filler);
            if (src == null) {
                throw new CodeGenException("Could not Generate Source");
            }
            JavaVEPlugin.log((Object)("\tAdding: " + src), (int)2);
            buf.append(src);
        }
    }

    protected String GenerateAddComponent(StringBuffer buf, BeanPart bean, BeanPart child, int Offset, String filler) throws CodeGenException {
        CodeExpressionRef exp = new CodeExpressionRef(this.fMethodRef, bean);
        exp.setState(2, true);
        exp.setArguments(new Object[]{child});
        exp.setFillerContent(filler);
        exp.setOffset(Offset);
        return exp.getContent();
    }

    protected void appendNewContainerSource(StringBuffer buf, BeanPart bean, String filler) throws CodeGenException, CodeGenInfoMissing {
        BeanDecoderAdapter bAdapter = (BeanDecoderAdapter)EcoreUtil.getExistingAdapter((Notifier)bean.getEObject(), (Object)ICodeGenAdapter.JVE_CODEGEN_BEAN_PART_ADAPTER);
        if (bAdapter == null) {
            throw new CodeGenInfoMissing("MethodAnalyzer.appendNewContainerSource: " + bean + " - Adapter");
        }
        List children = CodeGenUtil.getChildrenComponents(bean.getEObject());
        if (children == null) {
            return;
        }
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            EObject child = (EObject)itr.next();
            BeanPart bp = bean.getModel().getABean(child);
            if (bp == null) {
                throw new CodeGenInfoMissing("MethodAnalyzer.appendNewContainerSource: " + bean + " - BeanPart");
            }
            ICodeGenAdapter cAdapter = bAdapter.getChildAdapter(bp);
            if (cAdapter != null) continue;
            String src = this.GenerateAddComponent(buf, bean, bp, buf.length(), filler);
            if (src == null) {
                throw new CodeGenException("Could not Generate Source");
            }
            JavaVEPlugin.log((Object)("\tAdding: " + src), (int)2);
            buf.append(src);
        }
    }

    protected void appendNewSource(StringBuffer buf, BeanPart bean, String filler) throws CodeGenException, CodeGenInfoMissing {
        this.appendNewAttributes(buf, bean, filler);
        this.appendNewContainerSource(buf, bean, filler);
    }

    public String getCompositionReflectedSource() throws CodeGenException {
        if (this.fModel == null) {
            throw new CodeGenException(String.valueOf(this.fMethod.getElementName()) + " is not in the model");
        }
        this.fMethodRef = this.fModel.getMethodInitializingABean(this.fMethod.getHandleIdentifier());
        if (this.fMethodRef == null) {
            return null;
        }
        JavaVEPlugin.log((Object)("MethodAnalyzer: " + this.fMethod.getElementName() + "() - thinking ...."), (int)2);
        StringBuffer buf = new StringBuffer(2 * this.fSource.length());
        CDEHack.fixMe((String)"this may not be the init method for a bean");
        Vector beans = new Vector();
        int srcOffset = this.reflectExistingSource(buf, beans);
        CDEHack.fixMe();
        int i = 0;
        while (i < beans.size()) {
            this.appendNewSource(buf, (BeanPart)beans.elementAt(i), this.flastFiller);
            ++i;
        }
        buf.append(this.fSource.substring(srcOffset));
        String proposedContent = buf.toString();
        if (!proposedContent.equals(this.fSource)) {
            JavaVEPlugin.log((Object)("                " + this.fMethod.getElementName() + "() - Updating Source"), (int)2);
            this.updateMethodContent(proposedContent);
        } else {
            JavaVEPlugin.log((Object)("                " + this.fMethod.getElementName() + "() - No Change"), (int)2);
        }
        return this.fMethodRef.getContent();
    }

    public String toString() {
        return String.valueOf(super.toString()) + "\n" + this.fSource;
    }
}

