/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.ve.internal.java.codegen.java.BeanDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.java.ExpressionRefFactory;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenAdapter;
import org.eclipse.ve.internal.java.codegen.model.BeanDeclModel;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.BeanMethodTemplate;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class MethodTextGenerator {
    protected IBeanDeclModel fModel;
    protected IDOMMethod fJdomMethod;
    protected CodeMethodRef fMethodRef;
    protected EObject fComponent;
    protected String freturnType;
    protected String fName;
    protected String fMethodName;
    protected String[] fComments = null;

    public MethodTextGenerator(EObject component, IBeanDeclModel model) {
        this.fModel = model;
        this.fComponent = component;
    }

    protected CodeExpressionRef GenerateAttribute(EStructuralFeature sf, BeanPart bean, Object[] args, boolean updateDoc) throws CodeGenException {
        ExpressionRefFactory egen = new ExpressionRefFactory(bean, sf);
        CodeExpressionRef exp = egen.createFromJVEModel(args);
        if (updateDoc) {
            if (exp.getMethod().getMethodHandle() != null) {
                exp.insertContentToDocument(true);
            } else {
                exp.setState(256, true);
            }
        }
        return exp;
    }

    public void setComments(String[] comments) {
        this.fComments = comments;
    }

    public static boolean isNotToBeCodedAttribute(EStructuralFeature sf, EObject component) {
        return sf == null || sf instanceof EStructuralFeature && sf.isTransient() || sf.equals(CodeGenUtil.getComponentFeature(component)) || sf.equals(CodeGenUtil.getImplicitFeature(component)) || sf.equals(CodeGenUtil.getInitStringFeature(component));
    }

    protected boolean ignoreSF(EStructuralFeature sf) {
        return MethodTextGenerator.isNotToBeCodedAttribute(sf, this.fComponent);
    }

    protected void appendNewSource(StringBuffer buf, BeanPart bean, List kids) throws CodeGenException {
        this.appendNewSource(buf, bean, kids, false);
    }

    public void generateExpressionsContent() throws CodeGenException {
        BeanPart bp = this.fModel.getABean(this.fComponent);
        BeanDecoderAdapter bda = (BeanDecoderAdapter)EcoreUtil.getExistingAdapter((Notifier)this.fComponent, (Object)ICodeGenAdapter.JVE_CODEGEN_BEAN_PART_ADAPTER);
        Iterator itr = ((JavaClass)this.fComponent.eClass()).getAllProperties().iterator();
        while (itr.hasNext()) {
            EStructuralFeature sf = (EStructuralFeature)itr.next();
            if (!this.fComponent.eIsSet(sf) || bda == null || sf.isMany() || this.ignoreSF(sf) || bda.getSettingAdapters(sf) != null) continue;
            CodeExpressionRef newExpr = this.GenerateAttribute(sf, bp, null, true);
            String src = newExpr.getContent();
            if (src == null) {
                throw new CodeGenException("Could not Generate Source");
            }
            JavaVEPlugin.log((Object)("\tAdding: " + src), (int)2);
        }
    }

    protected void appendNewSource(StringBuffer buf, BeanPart bean, List kids, boolean updateDoc) throws CodeGenException {
        EObject obj = bean.getEObject();
        BeanDecoderAdapter a = (BeanDecoderAdapter)EcoreUtil.getExistingAdapter((Notifier)bean.getEObject(), (Object)ICodeGenAdapter.JVE_CODEGEN_BEAN_PART_ADAPTER);
        Iterator itr = ((JavaClass)obj.eClass()).getEAllStructuralFeatures().iterator();
        while (itr.hasNext()) {
            EStructuralFeature sf = (EStructuralFeature)itr.next();
            if (!obj.eIsSet(sf) || sf.isMany() || this.ignoreSF(sf) || kids.contains(sf) || a.getSettingAdapters(sf) != null && a.getSettingAdapters(sf).length > 0) continue;
            CodeExpressionRef newExpr = this.GenerateAttribute(sf, bean, null, updateDoc);
            String src = newExpr.getContent();
            if (src == null) {
                throw new CodeGenException("Could not Generate Source");
            }
            JavaVEPlugin.log((Object)("\tAdding: " + src), (int)2);
            if (!updateDoc) {
                newExpr.setOffset(buf.length());
            }
            buf.append(src);
        }
    }

    CodeExpressionRef createInitExpression(BeanMethodTemplate mt, BeanPart bean) {
        ExpressionRefFactory eg = new ExpressionRefFactory(bean, null);
        return eg.createInitExpression(mt);
    }

    protected Object getChildRoot(BeanPart bean, BeanPart child, EStructuralFeature sf) {
        if (bean == null || child == null) {
            return null;
        }
        if (child.getEObject().eContainer().equals(bean.getEObject())) {
            return child.getEObject();
        }
        return child.getEObject().eContainer();
    }

    protected void GenerateAChild(StringBuffer buf, BeanPart bean, BeanPart child, EStructuralFeature sf) throws CodeGenException {
        Object actualChild = this.getChildRoot(bean, child, sf);
        CodeExpressionRef newExpr = this.GenerateAttribute(sf, bean, new Object[]{actualChild}, false);
        String src = newExpr.getContent();
        if (src == null) {
            JavaVEPlugin.log((Object)("No Source Generated for " + bean.getUniqueName() + "(" + sf + ")"), (int)5);
            return;
        }
        CodeMethodRef mref = newExpr.getMethod();
        mref.removeExpressionRef(newExpr);
        newExpr.setOffset(buf.length());
        mref.addExpressionRef(newExpr);
        buf.append(src);
        JavaVEPlugin.log((Object)("\tAttribute source added: " + src), (int)2);
    }

    protected void setConstractorString(BeanMethodTemplate tp, Object component) {
        if (component instanceof IJavaObjectInstance) {
            IJavaObjectInstance obj = (IJavaObjectInstance)component;
            String st = obj.getInitializationString();
            tp.setBeanConstructorString(st);
        }
    }

    public String generateInLine(CodeMethodRef method, String beanName, List kids) throws CodeGenException {
        this.fMethodRef = method;
        this.freturnType = ((IJavaObjectInstance)this.fComponent).getJavaType().getQualifiedName();
        this.fName = beanName;
        BeanPart bp = this.fModel.getABean(this.fName);
        if (bp == null) {
            bp = this.fModel.getABean(BeanDeclModel.constructUniqueName(method, this.fName));
        }
        BeanMethodTemplate template = new BeanMethodTemplate(this.freturnType, this.fName, "", this.fComments);
        this.setConstractorString(template, this.fComponent);
        template.setSeperator(this.fModel.getLineSeperator());
        template.setInLineMethod(true);
        StringBuffer sb = new StringBuffer();
        CodeExpressionRef initExp = this.createInitExpression(template, bp);
        initExp.setState(64, false);
        initExp.setOffset(-1);
        try {
            method.updateExpressionOrder();
        }
        catch (Throwable e) {
            JavaVEPlugin.log((Throwable)e, (int)6);
            return null;
        }
        if (method.getMethodHandle() != null) {
            initExp.insertContentToDocument(true);
        } else {
            initExp.setState(256, true);
        }
        this.appendNewSource(sb, bp, kids, true);
        sb.append(template.getPostfix());
        return sb.toString();
    }

    public String generate(CodeMethodRef method, String methodName, String beanName, List kids) throws CodeGenException {
        this.fMethodRef = method;
        this.freturnType = ((IJavaObjectInstance)this.fComponent).getJavaType().getQualifiedName();
        this.fName = beanName;
        this.fMethodName = methodName;
        BeanPart bp = this.fModel.getABean(this.fName);
        BeanMethodTemplate template = new BeanMethodTemplate(this.freturnType, this.fName, this.fMethodName, this.fComments);
        this.setConstractorString(template, this.fComponent);
        template.setSeperator(this.fModel.getLineSeperator());
        StringBuffer sb = new StringBuffer();
        sb.append(template.getPrefix());
        ArrayList shadowExprList = new ArrayList();
        Iterator itr = this.fMethodRef.getExpressions();
        while (itr.hasNext()) {
            shadowExprList.add(itr.next());
        }
        int i = 0;
        while (i < shadowExprList.size()) {
            this.fMethodRef.removeExpressionRef((CodeExpressionRef)shadowExprList.get(i));
            ++i;
        }
        this.createInitExpression(template, bp);
        i = 0;
        while (i < shadowExprList.size()) {
            CodeExpressionRef exp = (CodeExpressionRef)shadowExprList.get(i);
            exp.setOffset(sb.length());
            sb.append(exp.getContent());
            if (!exp.isStateSet(256)) {
                throw new CodeGenException("STATE_EXP_NOT_PERSISTED is not set for existing expression");
            }
            exp.setState(256, false);
            this.fMethodRef.addExpressionRef(exp);
            ++i;
        }
        this.appendNewSource(sb, bp, kids);
        if (kids != null) {
            itr = kids.iterator();
            while (itr.hasNext()) {
                BeanPart child = (BeanPart)itr.next();
                EStructuralFeature sf = (EStructuralFeature)itr.next();
                child.addBackRef(bp, (EReference)sf);
                this.GenerateAChild(sb, bp, child, sf);
            }
        }
        sb.append(template.getPostfix());
        return sb.toString();
    }

    public String generateMethod(CodeMethodRef method, String methodName, String beanName) throws CodeGenException {
        this.fMethodRef = method;
        this.freturnType = ((IJavaObjectInstance)this.fComponent).getJavaType().getQualifiedName();
        this.fName = beanName;
        this.fMethodName = methodName;
        BeanPart bp = this.fModel.getABean(this.fName);
        BeanMethodTemplate template = new BeanMethodTemplate(this.freturnType, this.fName, this.fMethodName, this.fComments);
        this.setConstractorString(template, this.fComponent);
        template.setSeperator(this.fModel.getLineSeperator());
        StringBuffer sb = new StringBuffer();
        sb.append(template.getPrefix());
        if (this.fMethodRef.getExpressions() != null && this.fMethodRef.getExpressions().hasNext()) {
            throw new CodeGenException("Init JCMMethod already has expressions in it");
        }
        this.createInitExpression(template, bp);
        this.appendNewSource(sb, bp, new ArrayList(), true);
        sb.append(template.getPostfix());
        return sb.toString();
    }

    public String toString() {
        return String.valueOf(super.toString()) + this.fMethodName;
    }
}

