/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.List;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.ve.internal.java.codegen.java.ExpressionVisitor;
import org.eclipse.ve.internal.java.codegen.java.ISourceVisitor;
import org.eclipse.ve.internal.java.codegen.java.ReturnStmtVisitor;
import org.eclipse.ve.internal.java.codegen.java.SourceVisitor;
import org.eclipse.ve.internal.java.codegen.java.rules.IIfStatementRule;
import org.eclipse.ve.internal.java.codegen.java.rules.IMethodVariableRule;
import org.eclipse.ve.internal.java.codegen.java.rules.IOverideMethodVisitRule;
import org.eclipse.ve.internal.java.codegen.java.rules.IThisReferenceRule;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.CodeTypeRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class MethodVisitor
extends SourceVisitor {
    CodeMethodRef fMethod = null;

    protected void processLocalDecleration(LocalDeclaration stmt) {
        IMethodVariableRule methodVarRule = (IMethodVariableRule)CodeGenUtil.getEditorStyle(this.fModel).getRule("ruleMethodVariable");
        if (methodVarRule != null && methodVarRule.ignoreVariable((AbstractVariableDeclaration)stmt, this.fModel, this.fModel.getCompositionModel())) {
            return;
        }
        BeanPart bp = new BeanPart((AbstractVariableDeclaration)stmt);
        bp.setModel(this.fModel);
        bp.setInstanceVar(false);
        bp.addInitMethod(this.fMethod);
        this.fModel.addBean(bp);
        if (stmt.initialization instanceof AllocationExpression || stmt.initialization instanceof ArrayAllocationExpression || stmt.initialization instanceof CastExpression || stmt.initialization instanceof MessageSend) {
            new ExpressionVisitor(this.fMethod, (Statement)stmt, this.fModel, this.fReTryLater).visit();
        }
    }

    protected void processStatementArray(Statement[] statements) throws CodeGenException {
        if (statements == null) {
            BeanPart bean;
            IThisReferenceRule thisRule = (IThisReferenceRule)CodeGenUtil.getEditorStyle(this.fModel).getRule("ruleIThisReference");
            String[] mNameModifier = thisRule.getThisInitMethodName(this.fModel.getClassHierarchy());
            if (this.fMethod.getMethodName().equals(mNameModifier[0]) && (bean = this.fModel.getABean("this")) != null) {
                bean.addInitMethod(this.fMethod);
            }
            return;
        }
        int i = 0;
        while (i < statements.length) {
            this.processAStatement(statements[i]);
            ++i;
        }
    }

    protected void processBlockStatement(Block stmt) throws CodeGenException {
        this.processStatementArray(stmt.statements);
    }

    protected void processSynchStatement(SynchronizedStatement stmt) throws CodeGenException {
        this.processBlockStatement(stmt.block);
    }

    protected void processTryStatement(TryStatement stmt) throws CodeGenException {
        if (stmt.tryBlock != null) {
            this.processBlockStatement(stmt.tryBlock);
        }
        if (stmt.finallyBlock != null) {
            this.processBlockStatement(stmt.finallyBlock);
        }
    }

    protected void processIFStatement(IfStatement stmt) throws CodeGenException {
        IIfStatementRule ifRule = (IIfStatementRule)CodeGenUtil.getEditorStyle(this.fModel).getRule("ruleIfStatement");
        if (ifRule == null) {
            throw new CodeGenException("No IIfStatementRule");
        }
        ISourceVisitor overideIf = ifRule.overideIFVisit(this.fMethod.getDeclMethod(), stmt, this.fModel);
        if (overideIf != null) {
            overideIf.visit();
            return;
        }
        int processPattern = ifRule.whichPartToProcess(this.fMethod.getDeclMethod(), stmt);
        if ((processPattern & 1) > 0) {
            this.processAStatement(stmt.thenStatement);
        }
        if ((processPattern & 2) > 0) {
            this.processAStatement(stmt.elseStatement);
        }
    }

    protected void processAStatement(Statement stmt) throws CodeGenException {
        if (stmt instanceof LocalDeclaration) {
            this.processLocalDecleration((LocalDeclaration)stmt);
        } else if (stmt instanceof Block) {
            this.processBlockStatement((Block)stmt);
        } else if (stmt instanceof TryStatement) {
            this.processTryStatement((TryStatement)stmt);
        } else if (stmt instanceof IfStatement) {
            this.processIFStatement((IfStatement)stmt);
        } else if (stmt instanceof SynchronizedStatement) {
            this.processSynchStatement((SynchronizedStatement)stmt);
        } else if (stmt instanceof ReturnStatement) {
            new ReturnStmtVisitor(this.fMethod, (ReturnStatement)stmt, this.fModel, this.fReTryLater).visit();
        } else if (stmt instanceof Expression) {
            new ExpressionVisitor(this.fMethod, (Statement)((Expression)stmt), this.fModel, this.fReTryLater).visit();
        } else {
            JavaVEPlugin.log((Object)("\t[JCMMethod] Visitor did not processAStatement : " + stmt), (int)2);
        }
    }

    public MethodVisitor(AbstractMethodDeclaration node, IBeanDeclModel model, List reTryList, CodeTypeRef typeRef, String methodHandle, ISourceRange range, String content) {
        super((AstNode)node, model, reTryList);
        this.fMethod = new CodeMethodRef(node, typeRef, methodHandle, range, content);
    }

    public MethodVisitor(AbstractMethodDeclaration node, IBeanDeclModel model, List reTryList, CodeMethodRef m) {
        super((AstNode)node, model, reTryList);
        this.fMethod = m;
    }

    public void visit() {
        ISourceVisitor overideVisitor;
        IOverideMethodVisitRule overideRule = (IOverideMethodVisitRule)CodeGenUtil.getEditorStyle(this.fModel).getRule("ruleOverideMethod");
        if (overideRule != null && (overideVisitor = overideRule.overideMethodVisit(this.fMethod.getDeclMethod(), this.fModel)) != null) {
            overideVisitor.visit();
            return;
        }
        if (this.fMethod.getDeclMethod() instanceof ConstructorDeclaration) {
            JavaVEPlugin.log((Object)("Skiping Custructor parsing: " + this.fMethod.getMethodName()));
            return;
        }
        try {
            this.processStatementArray(this.fMethod.getDeclMethod().statements);
        }
        catch (CodeGenException e) {
            JavaVEPlugin.log((Throwable)((Object)e), (int)5);
        }
    }

    public String toString() {
        return "MethodVisitor(" + this.fMethod.getMethodName() + ")";
    }

    public void setInitMethodFor(BeanPart bp) {
        bp.addInitMethod(this.fMethod);
    }
}

