/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.List;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.eval.CodeSnippetReturnStatement;
import org.eclipse.ve.internal.java.codegen.java.ISourceVisitor;
import org.eclipse.ve.internal.java.codegen.java.SourceVisitor;
import org.eclipse.ve.internal.java.codegen.java.rules.IReturnStmtRule;
import org.eclipse.ve.internal.java.codegen.model.BeanDeclModel;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class ReturnStmtVisitor
extends SourceVisitor {
    CodeMethodRef fMethod = null;
    ReturnStatement fReturnStmt = null;

    ReturnStmtVisitor(CodeMethodRef method, ReturnStatement stmt, IBeanDeclModel model, List reTryList) {
        super((AstNode)stmt, model, reTryList);
        this.fMethod = method;
        this.fReturnStmt = stmt;
    }

    void processAReturnStatement() {
        Expression exp = this.fReturnStmt.expression;
        if (exp instanceof SingleNameReference) {
            String value = new String(((SingleNameReference)exp).token);
            String localValue = BeanDeclModel.constructUniqueName(this.fMethod, value);
            BeanPart bean = this.fModel.getABean(localValue);
            if (bean == null) {
                bean = this.fModel.getABean(value);
            }
            if (bean != null) {
                bean.addReturnMethod(this.fMethod);
                try {
                    this.fModel.addMethodReturningABean(new String(this.fMethod.getDeclMethod().selector), bean.getUniqueName());
                }
                catch (CodeGenException codeGenException) {}
            }
        }
    }

    public void visit() {
        ISourceVisitor override;
        IReturnStmtRule returnRule = (IReturnStmtRule)CodeGenUtil.getEditorStyle(this.fModel).getRule("ruleReturnStatement");
        if (returnRule != null && (override = returnRule.overideReturnVisit(this.fMethod.getDeclMethod(), this.fReturnStmt, this.fModel)) != null) {
            override.visit();
            return;
        }
        if (!(this.fReturnStmt instanceof CodeSnippetReturnStatement) && this.fReturnStmt instanceof ReturnStatement) {
            this.processAReturnStatement();
        } else {
            JavaVEPlugin.log((Object)("... did not process Expression:" + this.fReturnStmt), (int)2);
        }
    }
}

