/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jem.internal.beaninfo.PropertyDecorator;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaDataTypeInstance;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.jem.internal.java.JavaDataType;
import org.eclipse.jem.internal.java.impl.JavaFactoryImpl;
import org.eclipse.ve.internal.java.codegen.java.CodeSnippetTranslator;
import org.eclipse.ve.internal.java.codegen.java.ExpressionDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.java.ExpressionDecoderHelper;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenAdapter;
import org.eclipse.ve.internal.java.codegen.java.IExpressionDecoder;
import org.eclipse.ve.internal.java.codegen.java.IJavaFeatureMapper;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.codegen.util.ExpressionTemplate;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class SimpleAttributeDecoderHelper
extends ExpressionDecoderHelper {
    public static final String NULL_STRING = "null";
    String fInitString = null;
    String fUnresolveInitString = null;
    IJavaInstance fPropInstance = null;

    public SimpleAttributeDecoderHelper(BeanPart bean, Statement exp, IJavaFeatureMapper fm, IExpressionDecoder owner) {
        super(bean, exp, fm, owner);
    }

    protected String getInitString(Literal arg, EStructuralFeature sf) {
        if (arg instanceof NullLiteral) {
            return null;
        }
        if (arg instanceof StringLiteral) {
            String val = new String(arg.source());
            return BeanUtilities.createStringInitString((String)val);
        }
        return new String(arg.source());
    }

    public int getSFPriority() {
        if (this.fFmapper != null) {
            String methodName = null;
            if (this.fFmapper.getDecorator() != null) {
                methodName = this.fFmapper.getDecorator().getWriteMethod().getName();
            }
            if (methodName == null) {
                methodName = CodeGenUtil.getWriteMethod(this.fExpr);
            }
            if (methodName != null) {
                return this.fFmapper.getPriorityIncrement(methodName) + super.getSFPriority();
            }
        }
        return super.getSFPriority();
    }

    protected boolean isMethodType(String writeMethodName) {
        String method = null;
        if (this.fFmapper != null && this.fFmapper.getDecorator() != null) {
            method = this.fFmapper.getDecorator().getWriteMethod().getName();
        }
        if (method == null) {
            method = CodeGenUtil.getWriteMethod(this.fExpr);
        }
        return method != null && method.equals(writeMethodName);
    }

    protected String getInitString(QualifiedNameReference arg) {
        String initString = CodeGenUtil.tokensToString(arg.tokens);
        try {
            String resType;
            if (this.fbeanPart != null && this.fbeanPart.getModel() != null && this.fbeanPart.getModel().getCompilationUnit() != null && this.fbeanPart.getModel().getCompilationUnit().getTypes().length > 0 && (resType = this.fbeanPart.getModel().resolve(initString)) != null) {
                this.fUnresolveInitString = initString;
                initString = resType;
            }
        }
        catch (JavaModelException e) {
            JavaVEPlugin.log((Throwable)e);
        }
        return initString;
    }

    protected String getInitString(MessageSend msg) {
        String initstring = msg.toString();
        if (msg.receiver instanceof QualifiedNameReference || msg.receiver instanceof SingleNameReference) {
            String resolved;
            String unResolved = msg.receiver.toString();
            if (this.fbeanPart != null && this.fbeanPart.getModel() != null && !(resolved = this.fbeanPart.getModel().resolve(unResolved)).equals(unResolved)) {
                int from = initstring.indexOf(unResolved);
                int to = from + unResolved.length();
                if (from > -1 && from < initstring.length() && to > -1 && to < initstring.length() && from <= to) {
                    String newInitstring;
                    initstring = newInitstring = String.valueOf(initstring.substring(0, from)) + resolved + initstring.substring(to, initstring.length());
                }
            }
        }
        return initstring;
    }

    protected String getInitString(AllocationExpression arg) {
        String initString = arg.toString();
        this.fUnresolveInitString = arg.toString();
        try {
            if (this.fbeanPart != null && this.fbeanPart.getModel() != null && this.fbeanPart.getModel().getCompilationUnit() != null && this.fbeanPart.getModel().getCompilationUnit().getTypes().length > 0) {
                String type = CodeGenUtil.tokensToString(arg.type.getTypeName());
                String resolvedType = null;
                String rt = this.fbeanPart.getModel().resolve(type);
                resolvedType = rt != null ? rt : type;
                StringBuffer initConstruction = new StringBuffer("new ");
                initConstruction.append(resolvedType);
                initConstruction.append("(");
                int i = 0;
                while (arg.arguments != null && i < arg.arguments.length) {
                    initConstruction.append(arg.arguments[i].toStringExpression());
                    if (i != arg.arguments.length - 1) {
                        initConstruction.append(", ");
                    }
                    ++i;
                }
                initConstruction.append(")");
                initString = initConstruction.toString();
            }
        }
        catch (JavaModelException e) {
            JavaVEPlugin.log((Throwable)e);
        }
        return initString;
    }

    protected String getInitString(SingleNameReference snr) {
        int loc = snr.sourceStart;
        if (this.fOwner.getExprRef() != null && this.fOwner.getExprRef().getMethod() != null) {
            loc = this.fOwner.getExprRef().getOffset() + this.fOwner.getExprRef().getMethod().getOffset();
        }
        return this.fOwner.getBeanModel().resolveSingleNameReference(snr.toString(), loc);
    }

    protected String parseInitString(Expression exp) {
        String initString = null;
        try {
            initString = exp instanceof Literal ? this.getInitString((Literal)exp, this.fFmapper.getFeature(this.fExpr)) : (exp instanceof QualifiedNameReference ? this.getInitString((QualifiedNameReference)exp) : (exp instanceof AllocationExpression ? this.getInitString((AllocationExpression)exp) : (exp instanceof MessageSend ? this.getInitString((MessageSend)exp) : (exp instanceof SingleNameReference ? this.getInitString((SingleNameReference)exp) : exp.toString()))));
        }
        catch (Exception e) {
            JavaVEPlugin.log((Throwable)e, (int)5);
            initString = exp.toString();
        }
        return initString;
    }

    protected boolean dealwithInternalBean(AllocationExpression exp) {
        try {
            String unresolved = CodeGenUtil.tokensToString(exp.type.getTypeName());
            String resolved = this.fbeanPart.getModel().resolve(unresolved);
            String origInitString = exp.toString();
            int start = origInitString.indexOf(unresolved);
            int end = start + unresolved.length();
            String newInitString = String.valueOf(origInitString.substring(0, start)) + resolved + origInitString.substring(end, origInitString.length());
            EStructuralFeature sf = this.fFmapper.getFeature(this.fExpr);
            IJavaObjectInstance attr = (IJavaObjectInstance)CodeGenUtil.createInstance(resolved, this.fbeanPart.getModel().getCompositionModel());
            attr.setInitializationString(newInitString);
            EObject target = this.fbeanPart.getEObject();
            CodeGenUtil.propertyCleanup(target, sf);
            this.fbeanPart.getInitMethod().getCompMethod().getProperties().add(attr);
            target.eSet(sf, (Object)attr);
            this.fInitString = this.parseInitString((Expression)exp);
        }
        catch (CodeGenException codeGenException) {
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IJavaInstance createProperyInstance(String initString, EClassifier argType) throws CodeGenException {
        if (initString == null) return null;
        if (argType instanceof JavaDataType) {
            JavaFactoryImpl fact = (JavaFactoryImpl)((JavaDataType)argType).getEPackage().getEFactoryInstance();
            return (IJavaInstance)fact.createFromString((JavaDataType)argType, initString);
        }
        if (!(argType instanceof EClass)) {
            JavaVEPlugin.log((Object)("SimpleAttributeDecoderHelper.addFeature() : Not a Class or a DataType: " + argType), (int)2);
            throw new CodeGenException("Not a class or datatype: " + argType);
        }
        EFactory fact = ((EClass)argType).getEPackage().getEFactoryInstance();
        IJavaInstance result = (IJavaInstance)fact.create((EClass)argType);
        ((IJavaObjectInstance)result).setInitializationString(initString);
        return result;
    }

    protected boolean addFeature() throws CodeGenException {
        EStructuralFeature sf;
        if (this.fbeanPart.getEObject() == null) {
            throw new CodeGenException("null EObject:" + this.fExpr);
        }
        EClassifier argType = null;
        if (this.fFmapper.isFieldFeature()) {
            sf = this.fFmapper.getFeature(this.fExpr);
            if (sf == null) {
                throw new CodeGenException("Invalid SF");
            }
            argType = sf.getEType();
            this.fInitString = this.parseInitString(((Assignment)this.fExpr).expression);
        } else {
            PropertyDecorator pd = this.fFmapper.getDecorator();
            if (pd == null) {
                throw new CodeGenException("Invalid PropertyDecorator");
            }
            argType = pd.getPropertyType();
            Expression[] argExpr = ((MessageSend)this.fExpr).arguments;
            if (argExpr.length != 1) {
                throw new CodeGenException("Expression has more than one argument");
            }
            if (argExpr[0] instanceof AllocationExpression) {
                return this.dealwithInternalBean((AllocationExpression)argExpr[0]);
            }
            this.fInitString = this.parseInitString(argExpr[0]);
        }
        try {
            this.fPropInstance = this.createProperyInstance(this.fInitString, argType);
            if (this.fInitString == null) {
                this.fInitString = NULL_STRING;
            }
        }
        catch (CodeGenException codeGenException) {
            return false;
        }
        sf = this.fFmapper.getFeature(this.fExpr);
        EObject target = this.fbeanPart.getEObject();
        CodeGenUtil.propertyCleanup(target, sf);
        if (this.fPropInstance == null) {
            target.eSet(sf, null);
        } else {
            this.fbeanPart.getInitMethod().getCompMethod().getProperties().add(this.fPropInstance);
            target.eSet(sf, (Object)this.fPropInstance);
        }
        return true;
    }

    private String boxLayoutOveride(String st) {
        int index = st.indexOf("(,");
        if (index >= 0) {
            String toAdd = this.fbeanPart.getSimpleName();
            StringBuffer s = new StringBuffer(st);
            s.replace(index, index + 2, "(" + toAdd + ", ");
            return s.toString();
        }
        return st;
    }

    protected String primGetInitString() {
        Object currentVal = this.fbeanPart.getEObject().eGet(this.fFmapper.getFeature(this.fExpr));
        this.fPropInstance = (IJavaInstance)currentVal;
        if (currentVal != null) {
            if (currentVal instanceof IJavaObjectInstance) {
                return this.boxLayoutOveride(((IJavaObjectInstance)currentVal).getInitializationString());
            }
            if (currentVal instanceof JavaDataTypeInstance) {
                return ((JavaDataTypeInstance)currentVal).getInitializationString();
            }
        } else {
            EObject eobj = this.fbeanPart.getEObject();
            Iterator itr = ((JavaClass)eobj.eClass()).getAllProperties().iterator();
            while (itr.hasNext()) {
                EStructuralFeature sf = (EStructuralFeature)itr.next();
                if (!eobj.eIsSet(sf) || !sf.equals(this.fFmapper.getFeature(null))) continue;
                return NULL_STRING;
            }
        }
        return null;
    }

    public boolean primIsDeleted() {
        return this.primGetInitString() == null;
    }

    public boolean canRefreshFromComposition() {
        EObject obj = (EObject)this.fbeanPart.getEObject().eGet(this.fFmapper.getFeature(this.fExpr));
        if (obj != null && this.fOwner != null && this.fOwner.getExprRef() != null && this.fOwner.getExprRef().getBean() != null && this.fOwner.getExprRef().getBean().getModel() != null && this.fOwner.getExprRef().getBean().getModel().getABean(obj) != null) {
            return false;
        }
        return super.canRefreshFromComposition();
    }

    public String primRefreshFromComposition(String expSig) throws CodeGenException {
        if (this.fExprSig == null) {
            this.fExprSig = expSig;
        }
        int[] positions = CodeSnippetTranslator.indexOfIgnoringSpace(this.fExprSig, "(" + this.fInitString + ")");
        if (this.fUnresolveInitString != null && (positions[0] < 0 || positions[1] < 0)) {
            positions = CodeSnippetTranslator.indexOfIgnoringSpace(this.fExprSig, "(" + this.fUnresolveInitString + ")");
            if (positions[0] < 0 || positions[1] < 0) {
                JavaVEPlugin.log((Object)"SimpleAttr.DecoderHelper.primRefreshFromComposition(): Error", (int)2);
                return this.generate(null);
            }
            positions[0] = positions[0] + 1;
            positions[1] = positions[1] - 1;
        } else {
            if (positions[0] < 0 || positions[1] < 0) {
                JavaVEPlugin.log((Object)"SimpleAttr.DecoderHelper.primRefreshFromComposition(): Error", (int)2);
                return this.generate(null);
            }
            positions[0] = positions[0] + 1;
            positions[1] = positions[1] - 1;
        }
        this.fInitString = this.primGetInitString();
        StringBuffer sb = new StringBuffer(expSig);
        sb.replace(positions[0], positions[1], this.fInitString);
        this.fExprSig = sb.toString();
        return this.fExprSig;
    }

    public boolean decode() throws CodeGenException {
        if (this.fFmapper.getFeature(this.fExpr) == null || this.fExpr == null) {
            CodeGenUtil.logParsingError(this.fExpr.toString(), this.fbeanPart.getInitMethod().getMethodName(), "Feature " + this.fFmapper.getMethodName() + " is not recognized.", false);
            throw new CodeGenException("null Feature:" + this.fExpr);
        }
        if (this.fExpr instanceof Assignment || this.fExpr instanceof MessageSend && ((MessageSend)this.fExpr).arguments.length == 1) {
            return this.addFeature();
        }
        CodeGenUtil.logParsingError(this.fExpr.toString(), this.fbeanPart.getInitMethod().getMethodName(), "Invalid Format", false);
        return false;
    }

    public void delete() {
        this.unadaptToCompositionModel();
        EStructuralFeature sf = this.fFmapper.getFeature(this.fExpr);
        IJavaObjectInstance parent = (IJavaObjectInstance)this.fbeanPart.getEObject();
        EObject setting = (EObject)parent.eGet(sf);
        if (setting != null) {
            parent.eUnset(sf);
            this.cleanProperty(setting);
        }
        parent.eUnset(sf);
    }

    public String generate(Object[] noArgs) throws CodeGenException {
        String mtd;
        if (this.fFmapper.getFeature(null) == null) {
            throw new CodeGenException("null Feature");
        }
        this.fInitString = this.primGetInitString();
        if (this.fInitString == null) {
            this.fInitString = NULL_STRING;
        }
        if ((mtd = this.fFmapper.getMethodName()) == null) {
            JavaVEPlugin.log((Object)("No Write JCMMethod found for " + this.fFmapper.getFeature(null) + " on " + this.fbeanPart.getUniqueName()), (int)5);
            return null;
        }
        String sel = this.fbeanPart.getSimpleName();
        ExpressionTemplate exp = new ExpressionTemplate(sel, mtd, new String[]{this.fInitString}, null, 0);
        exp.setLineSeperator(this.fbeanPart.getModel().getLineSeperator());
        if (this.fFmapper.isFieldFeature()) {
            exp.setFieldAccess(true);
        }
        this.fExprSig = exp.toString();
        return this.fExprSig;
    }

    public boolean isImplicit(Object[] args) {
        this.primGetInitString();
        if (this.fPropInstance instanceof IJavaObjectInstance) {
            return ((IJavaObjectInstance)this.fPropInstance).isImplicit();
        }
        return false;
    }

    public Object[] getArgsHandles(Statement expr) {
        return null;
    }

    public void adaptToCompositionModel(IExpressionDecoder decoder) {
        super.adaptToCompositionModel(decoder);
        if (this.fPropInstance == null) {
            this.fPropInstance = (IJavaInstance)this.fbeanPart.getEObject().eGet(this.fFmapper.getFeature(this.fExpr));
        }
        if (this.fPropInstance != null) {
            this.fPropInstance.eAdapters().add(new ExpressionDecoderAdapter(decoder).getShadowSourceRangeAdapter());
        }
    }

    public void unadaptToCompositionModel() {
        ICodeGenAdapter a;
        Object o;
        super.unadaptToCompositionModel();
        if (this.fPropInstance == null && !this.fFmapper.getFeature(this.fExpr).isMany() && (o = this.fbeanPart.getEObject().eGet(this.fFmapper.getFeature(this.fExpr))) instanceof IJavaInstance) {
            this.fPropInstance = (IJavaInstance)o;
        }
        if (this.fPropInstance != null && (a = (ICodeGenAdapter)EcoreUtil.getExistingAdapter((Notifier)this.fPropInstance, (Object)ICodeGenAdapter.JVE_CODEGEN_EXPRESSION_SOURCE_RANGE)) != null) {
            this.fPropInstance.eAdapters().remove(a);
        }
    }
}

