/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.model;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.codegen.core.ICodeGenStatus;
import org.eclipse.ve.internal.java.codegen.core.IDiagramModelInstance;
import org.eclipse.ve.internal.java.codegen.java.ASTHelper;
import org.eclipse.ve.internal.java.codegen.java.BeanPartFactory;
import org.eclipse.ve.internal.java.codegen.java.CompositionDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenAdapter;
import org.eclipse.ve.internal.java.codegen.java.JavaSourceSynchronizer;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeEventHandlerRef;
import org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.CodeTypeRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.codegen.util.IWorkingCopyProvider;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jcm.BeanSubclassComposition;

public class BeanDeclModel
implements IBeanDeclModel {
    ArrayList fBeans = null;
    Hashtable fBeansKey = new Hashtable();
    Hashtable fBeanReturns = new Hashtable();
    Hashtable fBeanInitMethod = new Hashtable();
    Hashtable fRefObjKey = new Hashtable();
    ArrayList fBeanDeleteCandidates = new ArrayList();
    TypeDeclaration fTypeDeclaration = null;
    CodeTypeRef fTypeRef = null;
    List fEventHandlers = new ArrayList();
    CompilationUnitDeclaration fJDOM = null;
    IWorkingCopyProvider fWorkCopyP = null;
    JavaSourceSynchronizer fSrcSync = null;
    IDiagramModelInstance fCompositionModel = null;
    String fLineSeperator = null;
    int fState = 1;
    ICodeGenStatus fStatus = null;
    EditDomain fDomain = null;

    private boolean isPriority(BeanPart b) {
        String s = b.getType();
        return s.equals("java.awt.GridBagConstraints");
    }

    public List getBeans() {
        ArrayList v = new ArrayList();
        Enumeration e = this.fBeansKey.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (this.isPriority((BeanPart)o)) {
                v.add(0, o);
                continue;
            }
            v.add(o);
        }
        return v;
    }

    public List getEventHandlers() {
        return this.fEventHandlers;
    }

    public synchronized void dispose() {
        this.fState = 1;
        List beans = this.getBeans();
        int i = beans.size() - 1;
        while (i >= 0) {
            BeanPart b = (BeanPart)beans.remove(i);
            b.dispose();
            --i;
        }
        this.fTypeRef.dispose();
        i = 0;
        while (i < this.fEventHandlers.size()) {
            ((CodeEventHandlerRef)this.fEventHandlers.get(i)).dispose();
            ++i;
        }
        this.fCompositionModel = null;
        this.fSrcSync = null;
        this.fWorkCopyP = null;
    }

    public List getRootBeans() {
        if (this.fBeans == null) {
            this.fBeans = new ArrayList();
        }
        return this.fBeans;
    }

    public void setLineSeperator(String sep) {
        this.fLineSeperator = sep;
    }

    public String getLineSeperator() {
        return this.fLineSeperator;
    }

    public void designateAsDelete(BeanPart bean) {
        if (bean == null || this.fBeanDeleteCandidates.contains(bean)) {
            return;
        }
        ArrayList arrayList = this.fBeanDeleteCandidates;
        synchronized (arrayList) {
            this.fBeanDeleteCandidates.add(bean);
        }
    }

    public BeanPart getDeleteDesignated(IJavaObjectInstance obj, boolean remove) {
        if (obj == null) {
            return null;
        }
        BeanPart bean = this.getABean((EObject)obj);
        if (bean != null && this.fBeanDeleteCandidates.contains(bean)) {
            if (remove) {
                ArrayList arrayList = this.fBeanDeleteCandidates;
                synchronized (arrayList) {
                    ((AbstractCollection)this.fBeanDeleteCandidates).remove(bean);
                }
            }
            return bean;
        }
        return null;
    }

    public void deleteDesignatedBeans() {
        ArrayList arrayList = this.fBeanDeleteCandidates;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.fBeanDeleteCandidates.size()) {
                try {
                    BeanPart b = (BeanPart)this.fBeanDeleteCandidates.get(i);
                    BeanPartFactory bgen = new BeanPartFactory(this, this.getCompositionModel());
                    bgen.removeBeanPart(b);
                }
                catch (Throwable e) {
                    JavaVEPlugin.log((Throwable)e);
                }
                ++i;
            }
            this.fBeanDeleteCandidates.clear();
        }
    }

    public BeanPart[] getBeansInializedByMethod(String methodHandle) {
        BeanPart[] result;
        Vector<BeanPart> beans = new Vector<BeanPart>();
        Iterator itr = this.getBeans().iterator();
        while (itr.hasNext()) {
            BeanPart b = (BeanPart)itr.next();
            if (b.getInitMethod() == null || !b.getInitMethod().getMethodHandle().equals(methodHandle)) continue;
            beans.add(b);
        }
        if (beans.size() > 0) {
            result = new BeanPart[beans.size()];
            int i = 0;
            while (i < beans.size()) {
                result[i] = (BeanPart)beans.elementAt(i);
                ++i;
            }
        } else {
            result = null;
        }
        return result;
    }

    public void addBean(BeanPart bean) {
        bean.setModel(this);
        if (bean.getContainer() == null) {
            if (!this.getRootBeans().contains(bean)) {
                this.getRootBeans().add(bean);
            }
        } else {
            this.getRootBeans().remove(bean);
        }
        this.fBeansKey.put(bean.getUniqueName(), bean);
        if (bean.getEObject() != null) {
            this.fRefObjKey.put(bean.getEObject(), bean);
        }
    }

    public void removeBeanFromRoot(BeanPart bean) {
        this.getRootBeans().remove(bean);
    }

    public void removeBean(BeanPart bean) {
        this.removeBeanFromRoot(bean);
        this.fBeansKey.remove(bean.getUniqueName());
        if (bean.getEObject() != null) {
            this.fRefObjKey.remove(bean.getEObject());
        }
        this.fBeanReturns.values().remove(bean);
        bean.setModel(null);
    }

    public BeanPart getABean(String name) {
        return (BeanPart)this.fBeansKey.get(name);
    }

    public BeanPart getABean(EObject obj) {
        return (BeanPart)this.fRefObjKey.get(obj);
    }

    public void UpdateRefObjKey(BeanPart bean, EObject prev) {
        if (prev != null) {
            this.fRefObjKey.remove(prev);
        }
        if (bean.getEObject() != null) {
            this.fRefObjKey.put(bean.getEObject(), bean);
        }
    }

    public TypeDeclaration getTypeDecleration() {
        return this.fTypeDeclaration;
    }

    public void setTypeDecleration(TypeDeclaration decl) {
        this.fTypeDeclaration = decl;
    }

    public CompilationUnitDeclaration getJDOM() {
        return this.fJDOM;
    }

    public CodeTypeRef getTypeRef() {
        return this.fTypeRef;
    }

    public void setTypeRef(CodeTypeRef tr) {
        this.fTypeRef = tr;
    }

    public void setJDOM(CompilationUnitDeclaration dom) {
        this.fJDOM = dom;
    }

    public IDiagramModelInstance getCompositionModel() {
        return this.fCompositionModel;
    }

    public void setCompositionModel(IDiagramModelInstance cm) {
        if (cm == null && this.fCompositionModel == null) {
            return;
        }
        this.fCompositionModel = cm;
        BeanSubclassComposition c = cm.getModelRoot();
        BeanPart b = new BeanPart("BeanSubclassComposition", "");
        if (!this.isStateSet(8)) {
            b.setModel(this);
            b.setEObject((EObject)c);
            ICodeGenAdapter a = (ICodeGenAdapter)EcoreUtil.getExistingAdapter((Notifier)c, (Object)ICodeGenAdapter.JVE_CODE_GEN_TYPE);
            while (a != null) {
                c.eAdapters().remove(a);
                a = (ICodeGenAdapter)EcoreUtil.getExistingAdapter((Notifier)c, (Object)ICodeGenAdapter.JVE_CODE_GEN_TYPE);
            }
            CompositionDecoderAdapter adapter = new CompositionDecoderAdapter(b);
            adapter.setTarget((Notifier)c);
            c.eAdapters().add(adapter);
        } else {
            b.setModel(this);
        }
    }

    public void setWorkingCopyProvider(IWorkingCopyProvider wcp) {
        this.fWorkCopyP = wcp;
        if (this.fSrcSync != null) {
            this.fSrcSync.uninstall();
        }
        this.fSrcSync = null;
    }

    public void setSourceSynchronizer(JavaSourceSynchronizer sync) {
        if (this.fSrcSync != null) {
            this.fSrcSync.uninstall();
        }
        this.fSrcSync = sync;
    }

    public ICompilationUnit getCompilationUnit() {
        if (this.fWorkCopyP != null) {
            return this.fWorkCopyP.getLocalWorkingCopy();
        }
        return null;
    }

    public IDocument getDocument() {
        if (this.fWorkCopyP != null) {
            return this.fWorkCopyP.getLocalDocument();
        }
        return null;
    }

    public Object getDocumentLock() {
        return this.fWorkCopyP.getLocalDocLock();
    }

    public IWorkingCopyProvider getWorkingCopyProvider() {
        return this.fWorkCopyP;
    }

    public void updateJavaSource(String elementHandle) {
        this.fSrcSync.updateSharedFromLocal(elementHandle);
    }

    public BeanPart getBeanReturned(String methodName) {
        return (BeanPart)this.fBeanReturns.get(methodName);
    }

    public void addMethodReturningABean(String method, String beanName) throws CodeGenException {
        BeanPart bean = this.getABean(beanName);
        if (bean == null || method == null) {
            throw new CodeGenException("Invalid Bean Name " + beanName);
        }
        this.fBeanReturns.put(method, bean);
    }

    public void addMethodInitializingABean(CodeMethodRef methodRef) {
        if (methodRef.getMethodHandle() != null) {
            this.fBeanInitMethod.put(methodRef.getMethodHandle(), methodRef);
        }
    }

    public CodeMethodRef getMethodInitializingABean(String methodHandle) {
        return (CodeMethodRef)this.fBeanInitMethod.get(methodHandle);
    }

    public void removeMethodRef(CodeMethodRef mr) {
        BeanPart bean;
        this.fBeanInitMethod.remove(mr.getMethodHandle());
        this.fBeanReturns.remove(mr.getMethodName());
        Iterator allBeans = this.getBeans().iterator();
        while (allBeans.hasNext()) {
            bean = (BeanPart)allBeans.next();
            if (bean.getInitMethod() != null && bean.getInitMethod().equals(mr)) {
                bean.removeInitMethod(mr);
            }
            if (bean.getReturnedMethod() == null || !bean.getReturnedMethod().equals(mr)) continue;
            bean.removeReturnMethod(mr);
        }
        allBeans = this.getBeans().iterator();
        while (allBeans.hasNext()) {
            bean = (BeanPart)allBeans.next();
            CodeExpressionRef[] exps = new CodeExpressionRef[bean.getRefExpressions().size()];
            Iterator beansExps = bean.getRefExpressions().iterator();
            int count = 0;
            while (beansExps.hasNext()) {
                exps[count] = (CodeExpressionRef)beansExps.next();
                ++count;
            }
            if (this.isStateSet(1)) continue;
            count = 0;
            while (count < exps.length) {
                CodeExpressionRef exp = exps[count];
                if (exp != null && exp.getCodeContent() != null && CodeGenUtil.isExactlyPresent(exp.getCodeContent(), mr.getMethodName())) {
                    exp.deleteFromComposition();
                    exp.dispose();
                }
                ++count;
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("BDM : [");
        if (this.isStateSet(8)) {
            sb.append(" DELTA");
        }
        if (this.isStateSet(2)) {
            sb.append(" UP");
        }
        if (this.isStateSet(4)) {
            sb.append(" UPDATING_MODEL");
        }
        if (this.isStateSet(16)) {
            sb.append(" UPDATING_DOCUMENT");
        }
        sb.append("]");
        return sb.toString();
    }

    public String resolve(String unresolved) {
        return this.getWorkingCopyProvider().resolve(unresolved);
    }

    public String resolveThis() {
        return this.getWorkingCopyProvider().resolveThis();
    }

    public ITypeHierarchy getClassHierarchy() {
        return this.getWorkingCopyProvider().getHierarchy();
    }

    protected void setState(int flag) {
        this.fState = flag;
    }

    protected int getState() {
        return this.fState;
    }

    public void setState(int flag, boolean state) throws CodeGenException {
        if ((flag & 2) > 0 && (flag & 1) > 0 || (flag & 2) > 0 && (this.getState() & 8) > 0) {
            throw new CodeGenException("Invalid BDM state: " + flag);
        }
        if (state) {
            this.setState(this.getState() | flag);
            if ((flag & 2) > 0) {
                this.setState(this.getState() & 0xFFFFFFFE);
            } else if ((flag & 1) > 0) {
                this.setState(this.getState() & 0xFFFFFFFD);
            }
        } else {
            this.setState(this.getState() & ~flag);
        }
    }

    public boolean isStateSet(int state) {
        return (this.getState() & state) == state;
    }

    private static String constructUniqueName(String methodHandle, String simpleName) {
        return String.valueOf(methodHandle) + "^" + simpleName;
    }

    public static String constructUniqueName(IMethod method, String simpleName) {
        return BeanDeclModel.constructUniqueName(method.getHandleIdentifier(), simpleName);
    }

    public static String constructUniqueName(CodeMethodRef method, String simpleName) {
        return BeanDeclModel.constructUniqueName(method.getMethodHandle(), simpleName);
    }

    public Collection getBeansInitilizedByMethod(CodeMethodRef mref) {
        if (mref == null) {
            return null;
        }
        ArrayList<BeanPart> beans = new ArrayList<BeanPart>();
        Iterator itr = this.getBeans().iterator();
        while (itr.hasNext()) {
            BeanPart b = (BeanPart)itr.next();
            if (b.getInitMethod() == null || !b.getInitMethod().equals(mref)) continue;
            beans.add(b);
        }
        return beans;
    }

    public void updateBeanNameChange(BeanPart bp) {
        this.fBeansKey.values().remove(bp);
        this.fBeansKey.put(bp.getUniqueName(), bp);
    }

    public ICodeGenStatus getFStatus() {
        return this.fStatus;
    }

    public void setFStatus(ICodeGenStatus fStatus) {
        this.fStatus = fStatus;
    }

    public String resolveSingleNameReference(String selector, int location) {
        return ASTHelper.resolveSingleNameReference(selector, location, this.getWorkingCopyProvider().getSharedDocument().get());
    }

    public EditDomain getDomain() {
        return this.fDomain;
    }

    public void setDomain(EditDomain domain) {
        this.fDomain = domain;
    }

    private void updateMethodOffset(CodeMethodRef sMethod, CodeMethodRef m, int docOff, int delta) {
        if (sMethod.equals(m)) {
            m.updateExpressionsOffset(docOff, delta);
        } else {
            if (m.getOffset() < docOff) {
                return;
            }
            m.setOffset(m.getOffset() + delta);
        }
    }

    public Iterator getAllMethods() {
        ArrayList list = new ArrayList();
        Iterator m = this.getTypeRef().getMethods();
        while (m.hasNext()) {
            list.add(m.next());
        }
        Iterator t = this.getEventHandlers().iterator();
        while (t.hasNext()) {
            CodeEventHandlerRef handler = (CodeEventHandlerRef)t.next();
            m = handler.getMethods();
            while (m.hasNext()) {
                list.add(m.next());
            }
        }
        return ((AbstractList)list).iterator();
    }

    public void driveExpressionChangedEvent(CodeMethodRef sourceMethod, int docOff, int delta) {
        Iterator m = this.getAllMethods();
        while (m.hasNext()) {
            this.updateMethodOffset(sourceMethod, (CodeMethodRef)m.next(), docOff, delta);
        }
    }

    public CodeMethodRef getMethod(String handle) {
        Iterator itr = this.getAllMethods();
        while (itr.hasNext()) {
            CodeMethodRef m = (CodeMethodRef)itr.next();
            if (!m.getMethodHandle().equals(handle)) continue;
            return m;
        }
        return null;
    }
}

