/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.model;

import java.util.Iterator;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.ve.internal.java.codegen.java.IEventDecoder;
import org.eclipse.ve.internal.java.codegen.java.IJVEDecoder;
import org.eclipse.ve.internal.java.codegen.java.ITypeResolver;
import org.eclipse.ve.internal.java.codegen.model.AbstractCodeRef;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.codegen.util.EventExpressionParser;
import org.eclipse.ve.internal.java.codegen.util.ExpressionParser;
import org.eclipse.ve.internal.java.codegen.util.ExpressionTemplate;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jcm.AbstractEventInvocation;

public class CodeEventRef
extends CodeExpressionRef {
    private CompilationUnitDeclaration fDom;
    private AbstractEventInvocation fEventInvocation = null;
    protected IEventDecoder fDecoder = null;

    public CodeEventRef(Statement exp, CodeMethodRef method, CompilationUnitDeclaration dom) {
        super(exp, method);
        this.fDom = dom;
    }

    public CodeEventRef(CodeMethodRef method, BeanPart bean) {
        super(method, bean);
        this.fDom = null;
    }

    public void setDom(CompilationUnitDeclaration dom) {
        this.fDom = dom;
    }

    public void setBean(BeanPart bean) {
        this.fBean = bean;
        this.fMethod.addEventExpressionRef(this);
        bean.addEventExpression(this);
        bean.addEventInitMethod(this.fMethod);
    }

    public void dispose() {
        if (this.fMethod != null) {
            this.fMethod.removeEventRef(this);
        }
        if (this.fBean != null) {
            this.fBean.removeEventExpression(this);
        }
        super.dispose();
    }

    protected boolean isDuplicate() {
        boolean result = false;
        Iterator itr = this.fBean.getRefEventExpressions().iterator();
        while (itr.hasNext()) {
            CodeEventRef e = (CodeEventRef)itr.next();
            if (e == this) {
                return false;
            }
            try {
                if (e.isEquivalent(this) < 0) continue;
                return true;
            }
            catch (CodeGenException codeGenException) {
                JavaVEPlugin.log((Object)("CodeExpressionRef.isDuplicate():  can not determine: " + this));
            }
        }
        return result;
    }

    public void setDecoder(IEventDecoder decoder) {
        if (this.fDecoder == decoder) {
            return;
        }
        if (this.fDecoder != null) {
            this.fDecoder.dispose();
        }
        this.fDecoder = decoder;
    }

    protected IEventDecoder getEventDecoder() {
        if (this.fDecoder != null) {
            return this.fDecoder;
        }
        this.fDecoder = CodeGenUtil.getDecoderFactory(this.fBean.getModel()).getEventDecoder((IJavaInstance)this.fBean.getEObject());
        this.fDecoder.setBeanModel(this.fBean.getModel());
        this.fDecoder.setBeanPart(this.fBean);
        this.fDecoder.setCompositionModel(this.fBean.getModel().getCompositionModel());
        try {
            this.fDecoder.setExpression(this);
        }
        catch (CodeGenException e) {
            JavaVEPlugin.log((Throwable)((Object)e));
        }
        this.fDecoder.setEventInvocation(this.fEventInvocation);
        return this.fDecoder;
    }

    public synchronized boolean decodeExpression() throws CodeGenException {
        if (!this.isAnyStateSet() || this.isStateSet(1)) {
            return true;
        }
        if (this.isStateSet(8)) {
            return true;
        }
        if (this.getEventDecoder() != null) {
            boolean result = this.getEventDecoder().decode();
            if (result) {
                this.getEventDecoder().setFiller(this.fContentParser.getFiller());
            }
            return result;
        }
        return false;
    }

    public AbstractEventInvocation getEventInvocation() {
        return this.fEventInvocation;
    }

    public void setEventInvocation(AbstractEventInvocation ei) {
        this.fEventInvocation = ei;
        if (this.fDecoder != null) {
            try {
                this.fDecoder.setExpression(this);
            }
            catch (CodeGenException e) {
                JavaVEPlugin.log((Throwable)((Object)e));
            }
            this.fDecoder.setEventInvocation(ei);
        }
    }

    public synchronized String generateSource(AbstractEventInvocation ei) throws CodeGenException {
        if (!this.isStateSet(2)) {
            return null;
        }
        String result = this.getEventDecoder().generate(ei, this.fArguments);
        if (result == null) {
            return result;
        }
        String e = ExpressionTemplate.getExpression(result);
        int offset = result.indexOf(e);
        ExpressionParser p = this.createExpressionParser(result, offset, e.length());
        this.setContent(p);
        this.setOffset(-1);
        this.fEventInvocation = ei;
        this.getEventDecoder().setEventInvocation(this.fEventInvocation);
        return result;
    }

    public void setFillerContent(String filler) throws CodeGenException {
        this.fDecoder.setFiller(filler);
        this.generateSource(this.fEventInvocation);
    }

    protected ExpressionParser createExpressionParser(String sourceSnippet, int expOffset, int expLen) {
        return new EventExpressionParser(sourceSnippet, expOffset, expLen);
    }

    public synchronized void refreshFromComposition() throws CodeGenException {
        if (!this.isAnyStateSet() || this.isStateSet(1)) {
            this.clearAllFlags();
            this.setState(1, true);
            this.setContent((ExpressionParser)null);
            return;
        }
        if (this.isStateSet(8)) {
            return;
        }
        if (this.fDecoder == null) {
            throw new CodeGenException("No Decoder");
        }
        if (this.fDecoder.isDeleted()) {
            this.clearAllFlags();
            this.setState(1, true);
            this.setContent((ExpressionParser)null);
            return;
        }
        this.setState(4, true);
        this.setState(2, true);
    }

    public int isEquivalent(AbstractCodeRef code) throws CodeGenException {
        if (code instanceof CodeEventRef) {
            CodeEventRef exp1 = (CodeEventRef)code;
            if (this.isShadowExpOf(exp1) || exp1.isShadowExpOf(this)) {
                return 1;
            }
            if (exp1.equals(this)) {
                return 1;
            }
            if (exp1.getMethod() == null || exp1.getMethod().getMethodHandle() == null) {
                return -1;
            }
            if (!exp1.getMethod().getMethodHandle().equals(this.getMethod().getMethodHandle())) {
                return -1;
            }
            if (this.getBean() == null && exp1.getBean() != null) {
                return -1;
            }
            if (this.getBean() != null && exp1.getBean() == null) {
                return -1;
            }
            boolean beanNameEquivalency = this.getBean().getSimpleName().equals(exp1.getBean().getSimpleName());
            String expc1 = exp1.getMethodNameContent();
            String expc2 = this.getMethodNameContent();
            boolean expEquivalency = expc1.equals(expc2);
            if (beanNameEquivalency && expEquivalency) {
                if (this.isStateSet(8)) {
                    if (exp1.isStateSet(8)) {
                        if (this.getCodeContent().equals(exp1.getCodeContent())) {
                            return 1;
                        }
                        return 0;
                    }
                    return -1;
                }
                if (exp1.isStateSet(8)) {
                    return -1;
                }
                if (this.getCodeContent().equals(exp1.getCodeContent())) {
                    return 1;
                }
                return 0;
            }
        }
        return -1;
    }

    public boolean isEquivalentChanged(ITypeResolver oldResolver, CodeExpressionRef newExp, ITypeResolver newResolver) {
        return super.isEquivalentChanged(oldResolver, newExp, newResolver);
    }

    protected IJVEDecoder primGetDecoder() {
        return this.getEventDecoder();
    }

    public synchronized void refreshFromJOM(CodeExpressionRef exp, boolean updateDocumentContents) {
        if (exp.getExpression() != null) {
            this.setExpression(exp.getExpression());
        }
        this.setEventInvocation(((CodeEventRef)exp).getEventInvocation());
        super.refreshFromJOM(exp, updateDocumentContents);
    }
}

