/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.model;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ve.internal.java.codegen.java.CodeGenSourceRange;
import org.eclipse.ve.internal.java.codegen.java.ExpressionRefFactory;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenAdapter;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenSourceRange;
import org.eclipse.ve.internal.java.codegen.java.MemberDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.model.AbstractCodeRef;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.CodeEventRef;
import org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef;
import org.eclipse.ve.internal.java.codegen.model.CodeTypeRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jcm.JCMFactory;
import org.eclipse.ve.internal.jcm.JCMMethod;

public class CodeMethodRef
extends AbstractCodeRef {
    protected AbstractMethodDeclaration fdeclMethod = null;
    protected CodeTypeRef fTypeRef = null;
    protected ArrayList fExpressions = new ArrayList();
    protected ArrayList fEventExpressions = new ArrayList();
    protected String fMethodHandle = null;
    protected String fMethodName;
    protected DocListener fdocListener = null;
    protected Object fSync = this;
    protected IBeanDeclModel fModel = null;
    protected JCMMethod fcompMethod = null;
    protected boolean fgenerationRequired = false;
    protected boolean fStaleOffset = false;

    public CodeMethodRef(AbstractMethodDeclaration method, CodeTypeRef tRef, String methodHandle, ISourceRange range, String content) {
        super(range.getOffset(), range.getLength(), content);
        this.fTypeRef = tRef;
        this.connectToDoc();
        this.setMethodHandle(methodHandle);
        this.setDeclMethod(method);
        tRef.addRefMethod(this);
    }

    public void connectToDoc() {
        if (this.fdocListener == null) {
            this.fdocListener = new DocListener();
            this.fdocListener.connectToDocument();
        }
    }

    public CodeMethodRef(CodeTypeRef tr, String mName) {
        this.fTypeRef = tr;
        tr.addRefMethod(this);
        this.fMethodName = mName;
        this.connectToDoc();
    }

    public CodeMethodRef(CodeTypeRef tr, String mName, JCMMethod cMethod) {
        this(tr, mName);
        this.fcompMethod = cMethod;
    }

    protected void setDeclMethod(AbstractMethodDeclaration method) {
        this.fdeclMethod = method;
        if (this.fdeclMethod != null) {
            this.fMethodName = new String(this.fdeclMethod.selector);
        }
    }

    public String getMethodName() {
        return this.fMethodName;
    }

    public AbstractMethodDeclaration getDeclMethod() {
        return this.fdeclMethod;
    }

    public void setMethodHandle(String handle) {
        this.fMethodHandle = handle;
        if (this.fModel != null) {
            Collection beans = this.fModel.getBeansInitilizedByMethod(this);
            Iterator iter = beans.iterator();
            while (iter.hasNext()) {
                BeanPart bean = (BeanPart)iter.next();
                this.fModel.updateBeanNameChange(bean);
            }
        }
    }

    public String getMethodHandle() {
        return this.fMethodHandle;
    }

    public int isEquivalent(AbstractCodeRef code) {
        return -1;
    }

    public synchronized void addExpressionRef(CodeExpressionRef ref) {
        int offset = ref.getOffset();
        if (this.fExpressions == null) {
            this.fExpressions = new ArrayList();
        }
        if (ref.isStateSet(64) && offset > -1) {
            int index = 0;
            while (index < this.fExpressions.size()) {
                if (((CodeExpressionRef)this.fExpressions.get(index)).getOffset() > offset) break;
                ++index;
            }
            if (index == this.fExpressions.size()) {
                this.fExpressions.add(ref);
            } else {
                this.fExpressions.add(index, ref);
            }
        } else {
            this.fExpressions.add(ref);
        }
    }

    public synchronized void addEventExpressionRef(CodeEventRef ref) {
        int offset = ref.getOffset();
        if (this.fEventExpressions == null) {
            this.fEventExpressions = new ArrayList();
        }
        if (ref.isStateSet(64) && offset > -1) {
            int index = 0;
            while (index < this.fEventExpressions.size()) {
                if (((CodeEventRef)this.fEventExpressions.get(index)).getOffset() > offset) break;
                ++index;
            }
            if (index == this.fEventExpressions.size()) {
                this.fEventExpressions.add(ref);
            } else {
                this.fEventExpressions.add(index, ref);
            }
        } else {
            this.fEventExpressions.add(ref);
        }
    }

    public synchronized void removeExpressionRef(CodeExpressionRef ref) {
        if (this.fExpressions != null) {
            ((AbstractCollection)this.fExpressions).remove(ref);
        }
    }

    public synchronized void removeEventRef(CodeEventRef ref) {
        if (this.fEventExpressions != null) {
            ((AbstractCollection)this.fEventExpressions).remove(ref);
        }
    }

    public synchronized Iterator getExpressions() {
        if (this.fExpressions == null) {
            this.fExpressions = new ArrayList();
        }
        return ((AbstractList)this.fExpressions).iterator();
    }

    public synchronized Iterator getEventExpressions() {
        if (this.fEventExpressions == null) {
            this.fEventExpressions = new ArrayList();
        }
        return ((AbstractList)this.fEventExpressions).iterator();
    }

    public synchronized Iterator getAllExpressions() {
        final Iterator exp = this.getExpressions();
        final Iterator events = this.getEventExpressions();
        return new Iterator(){
            boolean eventsFlag = false;

            public boolean hasNext() {
                return exp.hasNext() || events.hasNext();
            }

            public Object next() {
                if (exp.hasNext()) {
                    return exp.next();
                }
                this.eventsFlag = true;
                return events.next();
            }

            public void remove() {
                if (this.eventsFlag) {
                    events.remove();
                } else {
                    exp.remove();
                }
            }
        };
    }

    protected void resetExpressionPriorities() {
        CodeExpressionRef expression;
        int count = 0;
        while (count < this.fExpressions.size()) {
            expression = (CodeExpressionRef)this.fExpressions.get(count);
            try {
                if (!expression.isStateSet(8) && expression.isAnyStateSet() && !expression.isStateSet(1)) {
                    expression.setProprity(expression.primGetDecoder().determinePriority());
                } else if (expression.isStateSet(1024)) {
                    int[] nArray = new int[2];
                    nArray[0] = Integer.MAX_VALUE;
                    expression.setProprity(nArray);
                } else {
                    expression.setProprity(new int[2]);
                }
            }
            catch (Exception e) {
                JavaVEPlugin.log((Throwable)e, (int)5);
            }
            ++count;
        }
        count = 0;
        while (count < this.fEventExpressions.size()) {
            expression = (CodeExpressionRef)this.fEventExpressions.get(count);
            try {
                if (!expression.isStateSet(8) && expression.isAnyStateSet() && !expression.isStateSet(1)) {
                    expression.setProprity(expression.primGetDecoder().determinePriority());
                } else if (expression.isStateSet(1024)) {
                    int[] nArray = new int[2];
                    nArray[0] = Integer.MAX_VALUE;
                    expression.setProprity(nArray);
                } else {
                    expression.setProprity(new int[2]);
                }
            }
            catch (Exception e) {
                JavaVEPlugin.log((Throwable)e, (int)5);
            }
            ++count;
        }
    }

    protected static List sortExpressionsByBeans(List newfExpressions) {
        Hashtable beanToExpHash = new Hashtable();
        int count = 0;
        while (count < newfExpressions.size()) {
            CodeExpressionRef exp = (CodeExpressionRef)newfExpressions.get(count);
            if (!exp.isStateSet(1)) {
                if (!beanToExpHash.containsKey(exp.getBean())) {
                    beanToExpHash.put(exp.getBean(), new ArrayList());
                }
                List expHolder = (List)beanToExpHash.get(exp.getBean());
                expHolder.add(exp);
            }
            ++count;
        }
        ArrayList tmpFinalOrder = new ArrayList();
        Enumeration beansToBeVisited = CodeMethodRef.determineBeanOrder(beanToExpHash.keys());
        while (beansToBeVisited.hasMoreElements()) {
            Vector sortedExpressions = new Vector();
            List expressions = (List)beanToExpHash.get(beansToBeVisited.nextElement());
            TreeSet methodSorterSet = new TreeSet(CodeMethodRef.getDefaultMethodComparator());
            int ec = 0;
            while (ec < expressions.size()) {
                methodSorterSet.add(expressions.get(ec));
                ++ec;
            }
            Iterator sorted = methodSorterSet.iterator();
            while (sorted.hasNext()) {
                sortedExpressions.add(sorted.next());
            }
            Vector<CodeExpressionRef> beanFinalOrder = new Vector<CodeExpressionRef>(sortedExpressions.size());
            int expc = 0;
            while (expc < sortedExpressions.size()) {
                CodeExpressionRef exp = (CodeExpressionRef)sortedExpressions.get(expc);
                if (exp.isStateSet(64)) {
                    int bestPosition = expc;
                    int i = 0;
                    while (i < beanFinalOrder.size()) {
                        CodeExpressionRef texp = (CodeExpressionRef)beanFinalOrder.get(i);
                        if (texp.isStateSet(64) && texp.getOffset() > exp.getOffset()) {
                            bestPosition = i;
                        }
                        ++i;
                    }
                    beanFinalOrder.insertElementAt(exp, bestPosition);
                } else {
                    beanFinalOrder.add(expc, exp);
                }
                ++expc;
            }
            tmpFinalOrder.addAll(beanFinalOrder);
        }
        return tmpFinalOrder;
    }

    protected List reorderInitExpsToTop(List unordered) {
        int maxPriorityCount = 0;
        Iterator allExpressions = unordered.iterator();
        ArrayList<CodeExpressionRef> ordered = new ArrayList<CodeExpressionRef>(unordered.size());
        while (allExpressions.hasNext()) {
            CodeExpressionRef exp = (CodeExpressionRef)allExpressions.next();
            if (((int[])exp.getPriority())[0] == Integer.MAX_VALUE) {
                if (exp.getBean() != null && exp.getBean().getReturnedMethod() != null && exp.getBean().getReturnedMethod().equals(this)) {
                    ordered.add(0, exp);
                } else {
                    ordered.add(maxPriorityCount, exp);
                }
                ++maxPriorityCount;
                continue;
            }
            ordered.add(exp);
        }
        return ordered;
    }

    protected List orderExpressions(List expressions) {
        List tmpExpressionOrder = new ArrayList(expressions);
        tmpExpressionOrder = CodeMethodRef.sortExpressionsByBeans(tmpExpressionOrder);
        tmpExpressionOrder = this.reorderInitExpsToTop(tmpExpressionOrder);
        return tmpExpressionOrder;
    }

    protected Object[] getUsableOffsetAndFiller(List allExpressionsSorted) throws CodeGenException {
        int offset = -1;
        String filler = null;
        boolean floatingExpessionFound = false;
        int i = 0;
        while (i < allExpressionsSorted.size()) {
            CodeExpressionRef ce = (CodeExpressionRef)allExpressionsSorted.get(i);
            if (ce.isStateSet(64)) {
                offset = ce.getOffset();
                filler = ce.getFillerContent();
            } else {
                floatingExpessionFound = true;
            }
            if (floatingExpessionFound && offset != -1 && filler != null) break;
            ++i;
        }
        if (offset != -1 && filler != null) {
            return new Object[]{new Integer(offset), filler};
        }
        IType mainType = CodeGenUtil.getMainType(this.fModel.getCompilationUnit());
        IMethod fMethod = CodeGenUtil.getMethod(mainType, this.getMethodHandle());
        if (fMethod != null) {
            ICodeGenSourceRange sr = ExpressionRefFactory.getOffsetForFirstExpression(fMethod);
            if (sr == null) {
                throw new CodeGenException("Could not find Offset");
            }
            offset = sr.getOffset();
            StringBuffer sb = new StringBuffer();
            int i2 = 0;
            while (i2 < sr.getLength()) {
                sb.append(' ');
                ++i2;
            }
            filler = sb.toString();
        }
        return new Object[]{new Integer(offset), filler};
    }

    public synchronized void updateExpressionOrder() throws CodeGenException {
        this.resetExpressionPriorities();
        List sortedExpressions = this.orderExpressions(this.fExpressions);
        List sortedEventExpressions = this.orderExpressions(this.fEventExpressions);
        ArrayList allExpressions = new ArrayList(sortedExpressions);
        allExpressions.addAll(sortedEventExpressions);
        int bestUsablePosition = -1;
        String bestUsableFiller = new String();
        try {
            Object[] ret = this.getUsableOffsetAndFiller(allExpressions);
            bestUsablePosition = (Integer)ret[0];
            bestUsableFiller = (String)ret[1];
        }
        catch (CodeGenException e) {
            JavaVEPlugin.log((Throwable)((Object)e), (int)5);
        }
        int c = 0;
        while (c < allExpressions.size()) {
            CodeExpressionRef exp = (CodeExpressionRef)allExpressions.get(c);
            if (exp.isStateSet(64)) {
                if (bestUsablePosition < exp.getOffset() + exp.getLen()) {
                    bestUsableFiller = exp.getFillerContent();
                    bestUsablePosition = exp.getOffset() + exp.getLen();
                }
            } else {
                if (bestUsableFiller != null) {
                    exp.setFillerContent(bestUsableFiller);
                }
                Iterator itr = allExpressions.iterator();
                while (itr.hasNext()) {
                    CodeExpressionRef tmpexp = (CodeExpressionRef)itr.next();
                    if (!tmpexp.isStateSet(64) || ((int[])tmpexp.getPriority())[0] != Integer.MAX_VALUE || tmpexp.getOffset() <= bestUsablePosition) continue;
                    bestUsablePosition = tmpexp.getOffset() + tmpexp.getLen();
                }
                exp.setOffset(bestUsablePosition);
                bestUsablePosition += exp.getLen();
                exp.setState(64, true);
            }
            ++c;
        }
        this.fExpressions = (ArrayList)sortedExpressions;
        this.fEventExpressions = (ArrayList)sortedEventExpressions;
    }

    protected static Enumeration determineBeanOrder(Enumeration beans) {
        TreeSet<BeanPart> beanSorter = new TreeSet<BeanPart>(CodeMethodRef.getDefaultBeanOrderComparator());
        while (beans.hasMoreElements()) {
            boolean added = beanSorter.add((BeanPart)beans.nextElement());
            if (added) continue;
            JavaVEPlugin.log((Object)"No addition to the treeset", (int)2);
        }
        Vector order = new Vector();
        Iterator sorted = beanSorter.iterator();
        while (sorted.hasNext()) {
            order.add(sorted.next());
        }
        return order.elements();
    }

    protected static Comparator getDefaultBeanOrderComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                int np2;
                BeanPart bp1 = (BeanPart)o1;
                BeanPart bp2 = (BeanPart)o2;
                int np1 = this.getImportanceCount(bp1, bp2);
                if (np1 < (np2 = this.getImportanceCount(bp2, bp1))) {
                    return -1;
                }
                if (np1 == np2) {
                    return 1;
                }
                return 1;
            }

            protected int getImportanceCount(BeanPart main, BeanPart subMain) {
                if (this.isAChildOf(main, subMain)) {
                    return Integer.MAX_VALUE;
                }
                int parentCount = this.getParentCount(main);
                int constraintCount = this.getConstraintCount(main);
                return parentCount + constraintCount;
            }

            protected boolean isAChildOf(BeanPart parent, BeanPart reference) {
                Iterator children = parent.getChildren();
                while (children.hasNext()) {
                    BeanPart child = (BeanPart)children.next();
                    if (child.getSimpleName().equals(reference.getSimpleName())) {
                        return true;
                    }
                    if (!this.isAChildOf(child, reference)) continue;
                    return true;
                }
                return false;
            }

            protected int getConstraintCount(BeanPart b) {
                EStructuralFeature sf = b.getEObject().eClass().getEStructuralFeature("components");
                if (sf != null) {
                    return 1;
                }
                if (CodeGenUtil.getConstraintFeature(b.getEObject()) != null) {
                    return 1;
                }
                return 0;
            }

            protected int getParentCount(BeanPart b) {
                int pc = 0;
                int safetyCount = 1000;
                while (b.getBackRefs().length > 0 && safetyCount > 0) {
                    ++pc;
                    --safetyCount;
                    b = b.getBackRefs()[0];
                }
                return pc;
            }
        };
    }

    protected static Comparator getDefaultMethodComparator() {
        return new Comparator(){

            public int compare(Object e1, Object e2) {
                CodeExpressionRef r1 = (CodeExpressionRef)e1;
                CodeExpressionRef r2 = (CodeExpressionRef)e2;
                int sfPriority1 = ((int[])r1.getPriority())[0];
                int sfPriority2 = ((int[])r2.getPriority())[0];
                int indexPriority1 = ((int[])r1.getPriority())[1];
                int indexPriority2 = ((int[])r2.getPriority())[1];
                int o1 = r1.getOffset();
                int o2 = r2.getOffset();
                if (o1 < 0) {
                    o1 = Integer.MAX_VALUE;
                }
                if (o2 < 0) {
                    o2 = Integer.MAX_VALUE;
                }
                if (sfPriority1 < sfPriority2) {
                    return 1;
                }
                if (sfPriority1 == sfPriority2) {
                    if (indexPriority1 < indexPriority2) {
                        return 1;
                    }
                    if (indexPriority1 == indexPriority2) {
                        if (o1 < o2) {
                            return -1;
                        }
                        return 1;
                    }
                    return -1;
                }
                return -1;
            }

            public boolean equals(Object o) {
                return super.equals(o);
            }
        };
    }

    public synchronized void aboutToDispose() {
        if (this.fdocListener != null) {
            this.fdocListener.disconnectFromDocument();
        }
    }

    public void disconnectFromDoc() {
        if (this.fdocListener != null) {
            this.fdocListener.disconnectFromDocument();
        }
        this.fdocListener = null;
    }

    public synchronized void dispose() {
        Object[] tmp;
        this.disconnectFromDoc();
        if (this.fModel != null) {
            Iterator itr = this.fModel.getBeansInitilizedByMethod(this).iterator();
            while (itr.hasNext()) {
                BeanPart b = (BeanPart)itr.next();
                b.removeInitMethod(this);
                b.removeReturnMethod(this);
            }
        }
        if (this.fExpressions != null) {
            tmp = this.fExpressions.toArray();
            int i = 0;
            while (i < tmp.length) {
                ((CodeExpressionRef)tmp[i]).dispose();
                ++i;
            }
        }
        this.fExpressions = null;
        if (this.fEventExpressions != null) {
            tmp = this.fEventExpressions.toArray();
            int i = 0;
            while (i < tmp.length) {
                ((CodeEventRef)tmp[i]).dispose();
                ++i;
            }
        }
        this.fExpressions = null;
        if (this.fTypeRef != null) {
            this.fTypeRef.removeRefMethod(this);
        }
        if (this.fModel != null) {
            this.fModel.removeMethodRef(this);
        }
        this.fdeclMethod = null;
        if (this.fcompMethod != null) {
            this.fTypeRef.getBeanComposition().getMethods().remove(this.fcompMethod);
        }
        this.fTypeRef = null;
        this.fcompMethod = null;
    }

    public synchronized void deleteFromComposition() {
        Iterator itr;
        if (this.fExpressions != null) {
            itr = ((AbstractList)this.fExpressions).iterator();
            while (itr.hasNext()) {
                ((CodeExpressionRef)itr.next()).deleteFromComposition();
            }
        }
        if (this.fEventExpressions != null) {
            itr = ((AbstractList)this.fEventExpressions).iterator();
            while (itr.hasNext()) {
                ((CodeEventRef)itr.next()).deleteFromComposition();
            }
        }
    }

    public ICodeGenSourceRange getTargetSourceRange() {
        if (this.fModel == null) {
            return null;
        }
        ISourceRange sr = this.fModel.getWorkingCopyProvider().getSharedSourceRange(this.getMethodHandle());
        CodeGenSourceRange result = new CodeGenSourceRange(sr);
        if (sr != null) {
            result.setLineOffset(this.fModel.getWorkingCopyProvider().getSharedLineNo(result.getOffset()));
        }
        return result;
    }

    public ICodeGenSourceRange getHighlightSourceRange() {
        if (this.fModel == null || this.fModel.getWorkingCopyProvider() == null) {
            return null;
        }
        try {
            ICompilationUnit cu = this.fModel.getWorkingCopyProvider().getSharedWorkingCopy();
            IType[] types = cu.getTypes();
            IMethod mtd = null;
            int i = 0;
            while (types != null && i < types.length) {
                if (CodeGenUtil.getMethod(types[i], this.getMethodHandle()) != null) {
                    mtd = CodeGenUtil.getMethod(types[i], this.getMethodHandle());
                }
                ++i;
            }
            if (mtd == null) {
                return null;
            }
            int start = mtd.getNameRange().getOffset();
            int end = mtd.getSourceRange().getOffset() + mtd.getSourceRange().getLength();
            start = cu.getSource().lastIndexOf(10, start) + 1;
            CodeGenSourceRange result = new CodeGenSourceRange(start, end - start);
            result.setLineOffset(this.fModel.getWorkingCopyProvider().getSharedLineNo(result.getOffset()));
            return result;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public void setModel(IBeanDeclModel model) {
        this.fModel = model;
    }

    public void refreshIMethod() {
        try {
            IType mainType;
            IMethod fMethod;
            try {
                if (!this.fModel.getCompilationUnit().isConsistent()) {
                    this.fModel.getCompilationUnit().reconcile();
                }
            }
            catch (JavaModelException javaModelException) {}
            if ((fMethod = CodeGenUtil.getMethod(mainType = CodeGenUtil.getMainType(this.fModel.getCompilationUnit()), this.getMethodHandle())) == null) {
                return;
            }
            if (fMethod != null) {
                this.setOffset(fMethod.getSourceRange().getOffset());
                this.setContent(fMethod.getSource());
            }
            this.connectToDoc();
        }
        catch (Exception e) {
            JavaVEPlugin.log((Throwable)e, (int)5);
        }
    }

    public String _debugExpressions() {
        StringBuffer sb = new StringBuffer();
        int mOffset = this.getOffset();
        String doc = this.fModel.getDocument().get();
        Iterator itr = this.getExpressions();
        while (itr.hasNext()) {
            CodeExpressionRef exp = (CodeExpressionRef)itr.next();
            sb.append(String.valueOf(exp.toString()) + "\n\"");
            if (!exp.isStateSet(1)) {
                sb.append(doc.substring(mOffset + exp.getOffset(), mOffset + exp.getOffset() + exp.getLen()));
            } else {
                sb.append("STATE_NOT_EXISTANT");
            }
            sb.append("\"\n");
        }
        return sb.toString();
    }

    public JCMMethod getCompMethod() {
        if (this.fcompMethod == null) {
            this.fcompMethod = JCMFactory.eINSTANCE.createJCMMethod();
            this.fTypeRef.getBeanComposition().getMethods().add(this.fcompMethod);
            this.fcompMethod.setName(this.getMethodName());
            MemberDecoderAdapter a = new MemberDecoderAdapter(this.fModel);
            a.setMethodRef(this);
            a.setTarget((Notifier)this.fcompMethod);
            this.fcompMethod.eAdapters().add(a);
        }
        return this.fcompMethod;
    }

    public void setCompMethod(JCMMethod m) throws CodeGenException {
        if (this.fcompMethod != null) {
            throw new CodeGenException("Already initialized");
        }
        this.fcompMethod = m;
        MemberDecoderAdapter ma = (MemberDecoderAdapter)EcoreUtil.getExistingAdapter((Notifier)m, (Object)ICodeGenAdapter.JVE_MEMBER_ADAPTER);
        ma.setMethodRef(this);
        m.setName(this.getMethodName());
    }

    public boolean isGenerationRequired() {
        return this.fgenerationRequired;
    }

    public void setGenerationRequired(boolean enerationRequired) {
        this.fgenerationRequired = enerationRequired;
    }

    public CodeTypeRef getTypeRef() {
        return this.fTypeRef;
    }

    public String toString() {
        return this.fStaleOffset ? "***StaleOffset***\n" + super.toString() : super.toString();
    }

    public void setOffset(int off) {
        super.setOffset(off);
        this.fStaleOffset = false;
    }

    public void setContent(String content) {
        super.setContent(content);
        this.fStaleOffset = false;
    }

    public void updateExpressionsOffset(int offset, int delta) {
        Iterator itr = this.getAllExpressions();
        while (itr.hasNext()) {
            CodeExpressionRef exp = (CodeExpressionRef)itr.next();
            if (exp.isStateSet(32) || exp.isStateSet(1) || exp.getOffset() + this.getOffset() < offset) continue;
            exp.setOffset(exp.getOffset() + delta);
        }
    }

    class DocListener
    implements IDocumentListener {
        IDocument fDoc = null;
        boolean fActive = false;

        DocListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        private void refresh() {
            ICompilationUnit cu = CodeMethodRef.this.fModel.getCompilationUnit();
            try {
                if (!cu.isConsistent()) {
                    cu.reconcile();
                }
                if (CodeMethodRef.this.fMethodHandle == null) {
                    throw new RuntimeException("No JCMMethod Handle");
                }
                IType mainType = CodeGenUtil.getMainType(CodeMethodRef.this.fModel.getCompilationUnit());
                IMethod fMethod = CodeGenUtil.getMethod(mainType, CodeMethodRef.this.getMethodHandle());
                if (fMethod == null) {
                    return;
                }
                IMethod[] mArray = mainType.findMethods(fMethod);
                if (mArray == null || mArray.length == 0) {
                    JavaVEPlugin.log((Object)("CodeMethodRef$DocListener.refresh(), No method found; " + fMethod), (int)2);
                    return;
                }
                fMethod = mArray[0];
                if (fMethod != null) {
                    CodeMethodRef.this.setOffset(fMethod.getSourceRange().getOffset());
                }
            }
            catch (Exception exception) {}
        }

        public void documentChanged(DocumentEvent event) {
            if (!this.fActive) {
                return;
            }
            if (CodeMethodRef.this.fModel == null) {
                return;
            }
            if (CodeMethodRef.this.fModel.isStateSet(16)) {
                CodeMethodRef.this.fStaleOffset = true;
                return;
            }
            IType mainType = CodeGenUtil.getMainType(CodeMethodRef.this.fModel.getCompilationUnit());
            IMethod fMethod = CodeGenUtil.getMethod(mainType, CodeMethodRef.this.getMethodHandle());
            if (fMethod == null) {
                return;
            }
            Object object = CodeMethodRef.this.fSync;
            synchronized (object) {
                if (CodeMethodRef.this.fExpressions == null || event.getOffset() > CodeMethodRef.this.getOffset() + CodeMethodRef.this.getLen()) {
                    return;
                }
                this.refresh();
                if (event.getOffset() <= CodeMethodRef.this.getOffset()) {
                    if (event.getOffset() + event.getLength() > CodeMethodRef.this.getOffset()) {
                        return;
                    }
                } else {
                    int delta = event.getText() == null ? 0 : event.getText().length();
                    delta -= event.getLength();
                    Iterator itr = CodeMethodRef.this.getAllExpressions();
                    while (itr.hasNext()) {
                        CodeExpressionRef exp = (CodeExpressionRef)itr.next();
                        if (exp.isStateSet(32) || exp.isStateSet(1) || exp.getOffset() + CodeMethodRef.this.getOffset() < event.getOffset()) continue;
                        exp.setOffset(exp.getOffset() + delta);
                    }
                }
                try {
                    CodeMethodRef.this.setOffset(fMethod.getSourceRange().getOffset());
                    CodeMethodRef.this.setContent(fMethod.getSource());
                }
                catch (JavaModelException e) {
                    JavaVEPlugin.log((Throwable)e, (int)5);
                }
            }
        }

        public void connectToDocument() {
            if (this.fDoc == null && CodeMethodRef.this.fTypeRef.getBeanModel().getDocument() != null) {
                this.fDoc = CodeMethodRef.this.fTypeRef.getBeanModel().getDocument();
                this.fDoc.addDocumentListener((IDocumentListener)this);
                this.fActive = true;
            }
        }

        public void disconnectFromDocument() {
            if (this.fDoc != null) {
                this.fDoc.removeDocumentListener((IDocumentListener)this);
                this.fDoc = null;
                this.fActive = false;
            }
        }
    }
}

