/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.util;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.java.JavaHelpers;
import org.eclipse.jem.internal.java.impl.JavaClassImpl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.InverseMaintenanceAdapter;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.cdm.AnnotationEMF;
import org.eclipse.ve.internal.cdm.CDMFactory;
import org.eclipse.ve.internal.java.codegen.core.IDiagramModelInstance;
import org.eclipse.ve.internal.java.codegen.java.BeanDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.java.ExpressionDecoderFactory;
import org.eclipse.ve.internal.java.codegen.java.ICodeGenAdapter;
import org.eclipse.ve.internal.java.codegen.java.IExpressionDecoder;
import org.eclipse.ve.internal.java.codegen.java.ITypeResolver;
import org.eclipse.ve.internal.java.codegen.java.ThisBeanDecoderAdapter;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodegenTypeResolver;
import org.eclipse.ve.internal.java.codegen.util.ICancelMonitor;
import org.eclipse.ve.internal.java.codegen.util.IWorkingCopyProvider;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.rules.IEditorStyle;
import org.eclipse.ve.internal.java.vce.rules.VCEPostSetCommand;
import org.eclipse.ve.internal.jcm.MemberContainer;

public class CodeGenUtil {
    private static JavaHelpers _CompositionInstance = null;

    public static String getWriteMethod(Statement expr) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof MessageSend) {
            return new String(((MessageSend)expr).selector);
        }
        if (expr instanceof Assignment) {
            if (((Assignment)expr).lhs instanceof QualifiedNameReference) {
                char[][] tokens = ((QualifiedNameReference)((Assignment)expr).lhs).tokens;
                return new String(tokens[tokens.length - 1]);
            }
            if (((Assignment)expr).lhs instanceof SingleNameReference) {
                SingleNameReference lhs = (SingleNameReference)((Assignment)expr).lhs;
                return new String(lhs.token);
            }
        } else if (expr instanceof LocalDeclaration) {
            TypeReference tr = ((LocalDeclaration)expr).type;
            if (tr instanceof QualifiedTypeReference) {
                return "new " + CodeGenUtil.tokensToString(((QualifiedTypeReference)tr).tokens);
            }
            return "new";
        }
        return null;
    }

    public static boolean isExactlyPresent(String main, String target) {
        if (main == null || target == null) {
            return false;
        }
        int index = main.indexOf(target);
        if (index < 0) {
            return false;
        }
        if ((index += target.length()) >= main.length()) {
            return true;
        }
        return !Character.isJavaIdentifierPart(main.charAt(index));
    }

    public static String tokensToString(char[][] tokens) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            if (i > 0 && buf.length() > 0) {
                buf.append(".");
            }
            buf.append(tokens[i]);
            ++i;
        }
        return buf.toString();
    }

    public static EObject createInstance(String instanceType, ResourceSet rs) throws CodeGenException {
        EClass iClass = (EClass)JavaClassImpl.reflect((String)instanceType, (ResourceSet)rs);
        EObject inst = iClass.getEPackage().getEFactoryInstance().create(iClass);
        return inst;
    }

    public static EObject createInstance(String instanceType, IDiagramModelInstance cm) throws CodeGenException {
        if (cm.getModelResourceSet() == null) {
            throw new CodeGenException("MOF is not set up");
        }
        JavaVEPlugin.log((Object)("CodeGenUtil.createInstance(" + instanceType + ")"), (int)2);
        return CodeGenUtil.createInstance(instanceType, cm.getModelResourceSet());
    }

    public static EClassifier getMetaClass(String qualifiedName, IDiagramModelInstance cm) {
        if (cm.getModelResourceSet() == null || qualifiedName == null) {
            return null;
        }
        return JavaClassImpl.reflect((String)qualifiedName, (ResourceSet)cm.getModelResourceSet());
    }

    public static void addAnnotatedName(Annotation a, String name) {
        if (a != null) {
            EStringToStringMapEntryImpl sentry = (EStringToStringMapEntryImpl)EcoreFactory.eINSTANCE.create(EcorePackage.eINSTANCE.getEStringToStringMapEntry());
            sentry.setKey((Object)"org.eclipse.ve.internal.cde.core.nameincomposition");
            if (name != null && name.length() > 0) {
                sentry.setValue((Object)name);
            }
            CDEUtilities.putEMapEntry((EMap)a.getKeyedValues(), (Map.Entry)sentry);
        }
    }

    public static EStructuralFeature getConstraintFeature(EObject componentConstraint) {
        return componentConstraint.eClass().getEStructuralFeature("constraint");
    }

    public static void addConstraintString(MemberContainer pOwner, EObject target, String initVal, EStructuralFeature sf, IDiagramModelInstance cm) throws Exception {
        IJavaObjectInstance value = null;
        CodeGenUtil.propertyCleanup(target, sf);
        if (initVal != null) {
            value = (IJavaObjectInstance)CodeGenUtil.createInstance("java.lang.String", cm);
            value.setInitializationString(initVal);
            pOwner.getProperties().add(value);
        }
        target.eSet(sf, value);
    }

    public static void addConstraintInstance(EObject target, IJavaObjectInstance val, EStructuralFeature sf) throws Exception {
        target.eSet(sf, (Object)val);
    }

    public static EStructuralFeature getComponentFeature(EObject target) {
        return target.eClass().getEStructuralFeature("components");
    }

    public static EStructuralFeature getParentContainerFeature(EObject target) {
        return target.eClass().getEStructuralFeature("parentContainer");
    }

    public static IType getMainType(ICompilationUnit cu) {
        if (cu == null) {
            return null;
        }
        try {
            IType[] types = cu.getTypes();
            return types.length > 0 ? types[0] : null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static IType getType(ICompilationUnit cu, String name) {
        if (cu == null) {
            return null;
        }
        IType[] elements = null;
        IType main = CodeGenUtil.getMainType(cu);
        try {
            if (main != null) {
                elements = main.getTypes();
                int i = 0;
                while (i < elements.length) {
                    if (elements[i].getElementName().equals(name)) {
                        return elements[i];
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IMethod[] getMethods(ICompilationUnit cu) {
        if (cu == null) {
            return null;
        }
        IType mt = CodeGenUtil.getMainType(cu);
        try {
            if (mt != null) {
                return mt.getMethods();
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IMethod[] getMethods(ICompilationUnit cu, String typeName) {
        if (cu == null) {
            return null;
        }
        IType mt = CodeGenUtil.getType(cu, typeName);
        try {
            if (mt != null) {
                return mt.getMethods();
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IMethod refreshMethod(IMethod method) {
        if (method == null) {
            return method;
        }
        ICompilationUnit cu = method.getCompilationUnit();
        try {
            if (!cu.isConsistent()) {
                cu.reconcile();
            }
        }
        catch (JavaModelException javaModelException) {}
        IType t = CodeGenUtil.getMainType(cu);
        return CodeGenUtil.getMethod(t, method);
    }

    public static IMethod refreshMethod(String handle, ICompilationUnit cu) {
        if (handle == null) {
            return null;
        }
        try {
            if (!cu.isConsistent()) {
                cu.reconcile();
            }
        }
        catch (JavaModelException javaModelException) {}
        return CodeGenUtil.getMethod(CodeGenUtil.getMainType(cu), handle);
    }

    public static IField getField(String handle, ICompilationUnit cu) {
        if (handle == null) {
            return null;
        }
        try {
            if (!cu.isConsistent()) {
                cu.reconcile();
            }
            IType t = CodeGenUtil.getMainType(cu);
            IField[] flds = t.getFields();
            int i = 0;
            while (i < flds.length) {
                IField iField = flds[i];
                if (iField.getHandleIdentifier().equals(handle)) {
                    return iField;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IField getFieldByName(String name, ICompilationUnit cu) {
        if (name == null || cu == null) {
            return null;
        }
        try {
            if (!cu.isConsistent()) {
                cu.reconcile();
            }
            IType t = CodeGenUtil.getMainType(cu);
            IField[] flds = t.getFields();
            int i = 0;
            while (i < flds.length) {
                IField iField = flds[i];
                if (iField.getElementName().equals(name)) {
                    return iField;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IMethod getMethod(IType t, String handle) {
        if (t == null) {
            return null;
        }
        try {
            IMethod[] mt = t.getMethods();
            int index = 0;
            while (index < mt.length) {
                if (mt[index].getHandleIdentifier().equals(handle)) {
                    return mt[index];
                }
                ++index;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IMethod getMethod(IType t, IMethod old) {
        try {
            IMethod[] mt = t.getMethods();
            int index = 0;
            while (index < mt.length) {
                if (mt[index].isSimilar(old)) {
                    return mt[index];
                }
                ++index;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static void refreshMethodOffsets(IType t, IBeanDeclModel model) throws CodeGenException {
        try {
            IMethod[] methods = t.getMethods();
            int i = 0;
            while (i < methods.length) {
                CodeMethodRef mr = model.getMethodInitializingABean(methods[i].getHandleIdentifier());
                if (mr != null) {
                    mr.setOffset(methods[i].getSourceRange().getOffset());
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            throw new CodeGenException(e);
        }
    }

    private static boolean isComponentContained(IBeanDeclModel m, EObject component, EObject parent) throws CodeGenException {
        if (parent == null || component == null) {
            return false;
        }
        if (component.equals(parent)) {
            return true;
        }
        IExpressionDecoder decoder = CodeGenUtil.getDecoderFactory(m).getExpDecoder((IJavaInstance)((IJavaObjectInstance)parent));
        Iterator itr = ((AbstractList)decoder.getChildren((IJavaObjectInstance)parent)).iterator();
        while (itr.hasNext()) {
            EObject child = (EObject)itr.next();
            itr.next();
            if (!CodeGenUtil.isComponentContained(m, component, child)) continue;
            return true;
        }
        return false;
    }

    public static boolean isComponentInComposition(IBeanDeclModel m, EObject component, IDiagramModelInstance model) throws CodeGenException {
        Iterator itr = model.getModelRoot().getComponents().iterator();
        while (itr.hasNext()) {
            if (!CodeGenUtil.isComponentContained(m, component, (EObject)itr.next())) continue;
            return true;
        }
        return false;
    }

    private static IJavaObjectInstance getParent(IBeanDeclModel model, IJavaObjectInstance child, IJavaObjectInstance parent) throws CodeGenException {
        if (parent == null || child == null) {
            return null;
        }
        if (parent.equals(child)) {
            return null;
        }
        IExpressionDecoder decoder = CodeGenUtil.getDecoderFactory(model).getExpDecoder((IJavaInstance)parent);
        Iterator itr = ((AbstractList)decoder.getChildren(parent)).iterator();
        while (itr.hasNext()) {
            IJavaObjectInstance c = (IJavaObjectInstance)itr.next();
            itr.next();
            if (c.equals(child)) {
                return parent;
            }
            IJavaObjectInstance p = CodeGenUtil.getParent(model, child, c);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public static IJavaObjectInstance getParent(IBeanDeclModel bmodel, IJavaObjectInstance child, IDiagramModelInstance model) throws CodeGenException {
        Iterator itr = model.getModelRoot().getComponents().iterator();
        while (itr.hasNext()) {
            IJavaObjectInstance p = CodeGenUtil.getParent(bmodel, child, (IJavaObjectInstance)itr.next());
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public static boolean isContainerHasLayoutManager(EObject container) {
        if (container == null) {
            return false;
        }
        EStructuralFeature sf = container.eClass().getEStructuralFeature("layout");
        return !container.eIsSet(sf) || container.eGet(sf) != null;
    }

    public static List getChildrenComponents(EObject parent) {
        if (parent == null) {
            return null;
        }
        List compList = null;
        EStructuralFeature sf = CodeGenUtil.getComponentFeature(parent);
        if (sf != null) {
            try {
                compList = (List)parent.eGet(CodeGenUtil.getComponentFeature(parent));
            }
            catch (Exception exception) {}
        }
        if (compList != null && compList.size() == 0) {
            return null;
        }
        return compList;
    }

    public static EObject getParentComponent(EObject child) {
        if (child == null) {
            return null;
        }
        return null;
    }

    public static IJavaObjectInstance getCCcomponent(EObject constraintComponent) {
        IJavaObjectInstance comp = (IJavaObjectInstance)constraintComponent.eGet(constraintComponent.eClass().getEStructuralFeature("component"));
        return comp;
    }

    public static IJavaObjectInstance getCCconstraint(EObject constraintComponent) {
        try {
            IJavaObjectInstance cons = (IJavaObjectInstance)constraintComponent.eGet(constraintComponent.eClass().getEStructuralFeature("constraint"));
            return cons;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static JavaHelpers getCompositionInstance(EObject component) {
        if (_CompositionInstance != null) {
            return _CompositionInstance;
        }
        _CompositionInstance = JavaClassImpl.reflect((String)"com.ibm.etools.ocm.Composition", (EObject)component);
        return _CompositionInstance;
    }

    public static EStructuralFeature getImplicitFeature(EObject target) {
        return target.eClass().getEStructuralFeature("implicit");
    }

    public static EStructuralFeature getInitStringFeature(EObject target) {
        return target.eClass().getEStructuralFeature("initializationString");
    }

    public static int getExactJavaIndex(String searchIn, String seachFor) {
        int index = -1;
        int indexEnd = -1;
        while (searchIn.indexOf(seachFor, indexEnd) > -1) {
            boolean endAllright;
            index = searchIn.indexOf(seachFor, indexEnd);
            indexEnd = index + seachFor.length();
            boolean startAllright = index == 0 || index > 0 && !Character.isJavaIdentifierPart(searchIn.charAt(index - 1));
            boolean bl = endAllright = indexEnd == searchIn.length() || indexEnd < searchIn.length() && !Character.isJavaIdentifierPart(searchIn.charAt(indexEnd + 1));
            if (!startAllright || !endAllright) continue;
            return index;
        }
        return -1;
    }

    public static String getResolvedInitString(Statement stmt, ITypeResolver resolver) {
        String resolved = null;
        if (stmt instanceof TypeReference && resolved == null) {
            TypeReference tr = (TypeReference)stmt;
            return resolver.resolve(CodeGenUtil.tokensToString(tr.getTypeName()));
        }
        if (stmt instanceof SingleNameReference) {
            SingleNameReference snr = (SingleNameReference)stmt;
            return resolver.resolve(new String(snr.token));
        }
        if (stmt instanceof AllocationExpression && resolved == null) {
            AllocationExpression ae = (AllocationExpression)stmt;
            resolved = ae.toString();
            TypeReference str = ae.type;
            String type = CodeGenUtil.tokensToString(str.getTypeName());
            String resolvedType = CodeGenUtil.getResolvedInitString((Statement)str, resolver);
            int newStart = CodeGenUtil.getExactJavaIndex(resolved, "new");
            int start = resolved.indexOf(type, newStart);
            int end = start + type.length();
            if (start > 0 && end > 0 && start <= resolved.length() && end <= resolved.length()) {
                resolved = String.valueOf(resolved.substring(0, start)) + resolvedType + resolved.substring(end, resolved.length());
            }
            if (ae.arguments != null) {
                int pc = 0;
                while (pc < ae.arguments.length) {
                    String unresolvedARG = ae.arguments[pc].toString();
                    start = resolved.indexOf(unresolvedARG, end);
                    end = start + unresolvedARG.length();
                    if (start <= 0 || end <= 0) break;
                    String resolvedARG = CodeGenUtil.getResolvedInitString((Statement)ae.arguments[pc], resolver);
                    resolved = String.valueOf(resolved.substring(0, start)) + resolvedARG + resolved.substring(end);
                    end += resolvedARG.length() - unresolvedARG.length();
                    ++pc;
                }
            }
        }
        if (stmt instanceof CastExpression && resolved == null) {
            int expFrom;
            int expTo;
            int castTo;
            CastExpression castExpr = (CastExpression)stmt;
            resolved = castExpr.toString();
            String castUnResolved = castExpr.type.toString();
            String castResolved = CodeGenUtil.getResolvedInitString((Statement)castExpr.type, resolver);
            String expUnResolved = castExpr.expression.toString();
            String expResolved = CodeGenUtil.getResolvedInitString((Statement)castExpr.expression, resolver);
            int castFrom = CodeGenUtil.getExactJavaIndex(resolved, castUnResolved);
            int n = castTo = castFrom < 0 ? -1 : castFrom + castUnResolved.length();
            if (castFrom > -1 && castTo > -1 && castFrom <= resolved.length() && castTo <= resolved.length() && !castUnResolved.equals(castResolved)) {
                resolved = String.valueOf(resolved.substring(0, castFrom)) + castResolved + resolved.substring(castTo, resolved.length());
            }
            int n2 = expTo = (expFrom = CodeGenUtil.getExactJavaIndex(resolved, expUnResolved)) < 0 ? -1 : expFrom + expUnResolved.length();
            if (expFrom > -1 && expTo > -1 && expFrom <= resolved.length() && expTo <= resolved.length() && !expUnResolved.equals(expResolved)) {
                resolved = String.valueOf(resolved.substring(0, expFrom)) + expResolved + resolved.substring(expTo, resolved.length());
            }
        }
        if (stmt instanceof MessageSend) {
            MessageSend m = (MessageSend)stmt;
            StringBuffer ms = new StringBuffer(m.toString());
            String r = m.receiver.toString();
            ms.replace(0, r.length(), resolver.resolve(r));
            resolved = ms.toString();
        }
        if (stmt instanceof Assignment && resolved == null) {
            Assignment assgn = (Assignment)stmt;
            resolved = assgn.toString();
            if (assgn.expression instanceof AllocationExpression) {
                resolved = CodeGenUtil.getResolvedInitString((Statement)assgn.expression, resolver);
            } else if (assgn.expression instanceof MessageSend) {
                resolved = CodeGenUtil.getResolvedInitString((Statement)assgn.expression, resolver);
            } else if (assgn.expression instanceof CastExpression) {
                resolved = CodeGenUtil.getResolvedInitString((Statement)assgn.expression, resolver);
            }
        }
        if (stmt instanceof LocalDeclaration && resolved == null) {
            LocalDeclaration ld = (LocalDeclaration)stmt;
            resolved = ld.toString();
            if (ld.initialization instanceof AllocationExpression || ld.initialization instanceof ArrayAllocationExpression || ld.initialization instanceof CastExpression || ld.initialization instanceof MessageSend) {
                resolved = CodeGenUtil.getResolvedInitString((Statement)ld.initialization, resolver);
            }
        }
        if (stmt instanceof QualifiedNameReference && resolver != null) {
            QualifiedNameReference qnr = (QualifiedNameReference)stmt;
            resolved = resolver.resolve(qnr.toString());
        }
        if (resolved == null) {
            resolved = stmt.toString();
        }
        return resolved;
    }

    public static boolean isConstraintComponentValue(Object val) {
        return val != null && val instanceof EObject && ((EObject)val).eClass().getName().equals("ConstraintComponent");
    }

    public static boolean isTabPaneComponentValue(Object val) {
        return val != null && val instanceof EObject && ((EObject)val).eClass().getName().equals("JTabComponent");
    }

    public static boolean isThisPart(EObject model) {
        BeanDecoderAdapter beanDecoderAdapter = (BeanDecoderAdapter)EcoreUtil.getExistingAdapter((Notifier)model, (Object)ICodeGenAdapter.JVE_CODEGEN_BEAN_PART_ADAPTER);
        return beanDecoderAdapter instanceof ThisBeanDecoderAdapter;
    }

    public static boolean isSpecialRootComponent(Object val) {
        boolean result = false;
        if (val instanceof EObject) {
            result = CodeGenUtil.isConstraintComponentValue(val) || CodeGenUtil.isTabPaneComponentValue(val);
        }
        return result;
    }

    public static Annotation getAnnotation(EObject obj) {
        AnnotationEMF.ParentAdapter a = (AnnotationEMF.ParentAdapter)EcoreUtil.getExistingAdapter((Notifier)obj, (Object)AnnotationEMF.ParentAdapter.PARENT_ANNOTATION_ADAPTER_KEY);
        return a != null ? a.getParentAnnotation() : null;
    }

    public static Annotation addAnnotation(EObject obj) {
        AnnotationEMF annotation = CDMFactory.eINSTANCE.createAnnotationEMF();
        annotation.setAnnotates(obj);
        return annotation;
    }

    public static void snoozeAlarm(EObject obj, ResourceSet rs) {
        InverseMaintenanceAdapter ai;
        if (obj != null && obj.eContainer() != null && (ai = (InverseMaintenanceAdapter)EcoreUtil.getExistingAdapter((Notifier)obj, (Object)InverseMaintenanceAdapter.ADAPTER_KEY)) != null) {
            EReference[] refs = ai.getFeatures();
            int sfIdx = 0;
            while (sfIdx < refs.length) {
                EReference sf = refs[sfIdx];
                if (!(sf.isContainment() || VCEPostSetCommand.isChildRelationShip((EReference)sf) || sf.getName().equals("initializes") || sf.getName().equals("return"))) {
                    EObject[] list = ai.getReferencedBy(sf);
                    int i = 0;
                    while (i < list.length) {
                        EObject parent = list[i];
                        if (sf.isMany()) {
                            List elements = (List)parent.eGet((EStructuralFeature)sf);
                            elements.set(elements.indexOf(obj), obj);
                        } else {
                            parent.eSet((EStructuralFeature)sf, (Object)obj);
                        }
                        CodeGenUtil.snoozeAlarm(parent, rs);
                        ++i;
                    }
                }
                ++sfIdx;
            }
        }
    }

    public static void eSet(EObject obj, EStructuralFeature sf, EObject val, int index) {
        if (sf.isMany()) {
            List elements = (List)obj.eGet(sf);
            if (index >= 0) {
                if (elements.contains(val)) {
                    elements.set(index, val);
                } else {
                    elements.add(index, val);
                }
            } else {
                elements.add(val);
            }
        } else {
            obj.eSet(sf, (Object)val);
        }
    }

    public static IWorkingCopyProvider getRefWorkingCopyProvider(ICompilationUnit refCU) {
        final ICompilationUnit cu = refCU;
        IWorkingCopyProvider wcp = new IWorkingCopyProvider(){
            CodegenTypeResolver resolver;
            {
                this.resolver = new CodegenTypeResolver(CodeGenUtil.getMainType(iCompilationUnit));
            }

            public ICompilationUnit getSharedWorkingCopy() {
                return cu;
            }

            public ICompilationUnit getSharedWorkingCopy(boolean force) {
                return cu;
            }

            public ICompilationUnit getLocalWorkingCopy() {
                return cu;
            }

            public IFileEditorInput getEditor() {
                return null;
            }

            public IFile getFile() {
                return null;
            }

            public IDocument getSharedDocument() {
                return null;
            }

            public IDocument getLocalDocument() {
                return null;
            }

            public Object getLocalDocLock() {
                return null;
            }

            public void ReplaceWithLocalContent(IProgressMonitor pm, boolean commit) throws CodeGenException {
            }

            public void UpdateDeltaToShared(ICancelMonitor pm, IDocumentListener docListener, List handles, boolean commit) throws CodeGenException {
            }

            public void aboutToChangeShared() {
            }

            public void changeCompleteShared() {
            }

            public ISourceRange getSharedSourceRange(String handle) {
                return null;
            }

            public int getSharedLineNo(int Offset) {
                return -1;
            }

            public void dispose() {
            }

            public String resolve(String unresolved) {
                try {
                    if (this.resolver == null) {
                        return unresolved;
                    }
                    return this.resolver.resolveTypeComplex(unresolved);
                }
                catch (Exception exception) {
                    return unresolved;
                }
            }

            public String resolveThis() {
                return CodeGenUtil.getMainType(cu).getTypeQualifiedName();
            }

            public ITypeHierarchy getHierarchy() {
                try {
                    IType t = CodeGenUtil.getMainType(cu);
                    return t.newSupertypeHierarchy(null);
                }
                catch (JavaModelException javaModelException) {
                    return null;
                }
            }

            public void disconnect() {
            }

            public void reconnect(IFile file) {
            }
        };
        return wcp;
    }

    public static void clearCache() {
    }

    public static IEditorStyle getEditorStyle(IBeanDeclModel beanModel) {
        return (IEditorStyle)beanModel.getDomain().getRuleRegistry();
    }

    public static ExpressionDecoderFactory getDecoderFactory(IBeanDeclModel beanModel) {
        EditDomain d = beanModel.getDomain();
        return (ExpressionDecoderFactory)d.getData((Object)"org.eclipse.ve.internal.java.codegen.java.ExpressionDecoderFactory");
    }

    public static boolean propertyCleanup(EObject target, EStructuralFeature sf) {
        EObject p;
        boolean result = false;
        if (target.eIsSet(sf) && (p = (EObject)target.eGet(sf)) != null && p.eContainer() instanceof MemberContainer) {
            MemberContainer c = (MemberContainer)p.eContainer();
            result = c.getProperties().contains(p);
            c.getProperties().remove(p);
        }
        return result;
    }

    public static void logParsingError(String exp, String method, String msg, boolean event) {
        String context = event ? "as an event registration" : "as a property setting";
        JavaVEPlugin.log((Object)("\n/**\n Could not parse the following expression " + context + ":\n\t" + method + "(): " + exp + "\n\treason: " + msg + "\n**/\n"), (int)2);
    }
}

