/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.util;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.ve.internal.java.codegen.java.PropertyFeatureMapper;
import org.eclipse.ve.internal.java.codegen.java.rules.InstanceVariableCreationRule;
import org.eclipse.ve.internal.java.codegen.java.rules.InstanceVariableRule;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;

public class CodegenTypeResolver
implements IElementChangedListener {
    private IType fReferenceIType = null;
    private boolean isConnected = false;
    private HashMap tempHash = null;

    public CodegenTypeResolver(IType referenceIType) {
        this.fReferenceIType = referenceIType;
    }

    public void connect() {
        if (!this.isConnected) {
            JavaCore.addElementChangedListener((IElementChangedListener)this);
            this.isConnected = true;
        }
    }

    private String[] resolveSimpleType(String toResolve) {
        try {
            String[][] types = this.fReferenceIType.resolveType(toResolve);
            if (types != null && types.length > 0) {
                return types[0];
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        return null;
    }

    private HashMap getNewHashMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("int", "int");
        map.put("float", "float");
        map.put("double", "double");
        map.put("short", "short");
        map.put("long", "long");
        map.put("boolean", "boolean");
        map.put("byte", "byte");
        map.put("char", "char");
        map.put("void", "void");
        map.put("Integer", "java.lang.Integer");
        map.put("Double", "java.lang.Double");
        map.put("Float", "java.lang.Float");
        map.put("Short", "java.lang.Short");
        map.put("Long", "java.lang.Long");
        map.put("Boolean", "java.lang.Boolean");
        map.put("Byte", "java.lang.Byte");
        map.put("Character", "java.lang.Character");
        map.put("String", "java.lang.String");
        map.put("Class", "java.lang.Class");
        return map;
    }

    public String resolveTypeComplex(String toResolve) {
        if (this.tempHash == null) {
            this.tempHash = this.getNewHashMap();
        }
        if (this.tempHash.containsKey(toResolve)) {
            return (String)this.tempHash.get(toResolve);
        }
        StringTokenizer dotTokenizer = new StringTokenizer(toResolve, "$.", false);
        String finalResolved = toResolve;
        String[] tokens = new String[dotTokenizer.countTokens()];
        int count = 0;
        while (dotTokenizer.hasMoreTokens()) {
            tokens[count] = dotTokenizer.nextToken();
            ++count;
        }
        String correctedFinalResolved = new String();
        String seenSoFar = new String();
        boolean lastTokenWasAClass = false;
        boolean couldResolveAtleastOneToken = false;
        int i = 0;
        while (i < tokens.length) {
            String[] ret;
            String token = tokens[i];
            seenSoFar = correctedFinalResolved.replace('$', '.');
            if (i > 0) {
                seenSoFar = seenSoFar.concat(".");
            }
            if ((ret = this.resolveSimpleType(seenSoFar = seenSoFar.concat(token))) != null) {
                couldResolveAtleastOneToken = true;
            }
            boolean tokenPresentInHierarchy = false;
            if (ret == null && lastTokenWasAClass) {
                ret = this.checkInHierarchy(seenSoFar);
            }
            if (!(ret != null && ret.length >= 1 || tokenPresentInHierarchy)) {
                if (i > 0) {
                    correctedFinalResolved = correctedFinalResolved.concat(".");
                }
                correctedFinalResolved = correctedFinalResolved.concat(token);
                lastTokenWasAClass = false;
            } else {
                String pkg = ret[0];
                String cls = ret[1];
                correctedFinalResolved = pkg.length() > 0 ? String.valueOf(pkg) + "." + cls.replace('.', '$') : cls.replace('.', '$');
                lastTokenWasAClass = true;
            }
            ++i;
        }
        if (correctedFinalResolved != null) {
            finalResolved = correctedFinalResolved;
        }
        if (finalResolved.startsWith(".")) {
            finalResolved = finalResolved.substring(1, finalResolved.length());
        }
        if (couldResolveAtleastOneToken) {
            this.tempHash.put(toResolve, finalResolved);
        }
        return finalResolved;
    }

    private String[] checkInHierarchy(String inner) {
        try {
            String outerClassName = inner.substring(0, inner.lastIndexOf(46));
            String innerClassName = inner.substring(inner.lastIndexOf(46) + 1, inner.length());
            IType outerClassType = this.fReferenceIType.getJavaProject().findType(outerClassName);
            if (outerClassType == null) {
                return null;
            }
            return this.traverseHierarchy(outerClassType, innerClassName);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private String[] traverseHierarchy(IType outerType, String innerClassName) {
        try {
            String superName;
            String[][] tmp;
            String[] ret;
            block10: {
                ret = this.resolveSimpleType(String.valueOf(outerType.getFullyQualifiedName()) + "." + innerClassName);
                if (ret != null) {
                    return ret;
                }
                String[] implementsNames = outerType.getSuperInterfaceNames();
                if (implementsNames == null || implementsNames.length <= 0) break block10;
                int i = 0;
                while (i < implementsNames.length) {
                    block12: {
                        IType implementType;
                        block13: {
                            block11: {
                                implementType = null;
                                if (!(outerType instanceof SourceType)) break block11;
                                tmp = outerType.resolveType(implementsNames[i]);
                                if (tmp == null || tmp.length < 1) break block12;
                                String[] implement = tmp[0];
                                implementType = this.fReferenceIType.getJavaProject().findType(implement[0], implement[1]);
                                break block13;
                            }
                            implementType = this.fReferenceIType.getJavaProject().findType(implementsNames[i]);
                        }
                        if (implementType != null && (ret = this.traverseHierarchy(implementType, innerClassName)) != null) {
                            return ret;
                        }
                    }
                    ++i;
                }
            }
            if ((superName = outerType.getSuperclassName()) != null) {
                IType superType = null;
                if (outerType instanceof SourceType) {
                    tmp = outerType.resolveType(superName);
                    if (tmp != null || tmp.length > 0) {
                        String[] supers = tmp[0];
                        superType = this.fReferenceIType.getJavaProject().findType(supers[0], supers[1]);
                    }
                } else {
                    superType = this.fReferenceIType.getJavaProject().findType(superName);
                }
                if (superType != null && (ret = this.traverseHierarchy(superType, innerClassName)) != null) {
                    return ret;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public void elementChanged(ElementChangedEvent event) {
        if (this.tempHash != null) {
            this.tempHash.clear();
        }
        PropertyFeatureMapper.clearCache();
        CodeGenUtil.clearCache();
        InstanceVariableCreationRule.clearCache();
        InstanceVariableRule.clearCache();
    }

    public void disconnect() {
        if (this.isConnected) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
            this.isConnected = false;
        }
    }
}

