/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.util;

import org.eclipse.ve.internal.java.codegen.util.AbstractAnnotationTemplate;

public class FreeFormAnnotationTemplate
extends AbstractAnnotationTemplate {
    public static final String VISUAL_CONTENT_TYPE = "visual-constraint";
    public static final String ANNOTATION_START = "//";
    public static final String ANNOTATION_PREFIX = "  //";

    public FreeFormAnnotationTemplate() {
        super("visual-info  decl-index=0");
    }

    public FreeFormAnnotationTemplate(int x, int y) {
        super("visual-info  decl-index=0");
        this.setPosition(x, y);
    }

    public void setPosition(int x, int y) {
        this.fContent = "visual-constraint=\"" + Integer.toString(x) + "," + Integer.toString(y) + "\"";
    }

    protected static int getSigOnSameLine(int s, String src, String sig) {
        int start = src.indexOf(sig, s);
        if (start < 0) {
            return -1;
        }
        int nlIndex = src.indexOf(10);
        if (nlIndex >= 0 && nlIndex <= start) {
            return -1;
        }
        return start;
    }

    protected static int getSigOnSameLine(int s, String src, char sig) {
        int start = src.indexOf(sig, s);
        if (start < 0) {
            return -1;
        }
        int nlIndex = src.indexOf(10);
        if (nlIndex >= 0 && nlIndex <= start) {
            return -1;
        }
        return start;
    }

    public static int getAnnotationStart(String src) {
        return FreeFormAnnotationTemplate.getSigOnSameLine(0, src, ANNOTATION_START);
    }

    public static int getAnnotationArgStart(String src, int start) {
        try {
            start = src.indexOf("@jve:", start);
            if (start < 0) {
                return -1;
            }
            int end = src.indexOf("visual-info  decl-index=0", start);
            if (end < 0) {
                return -1;
            }
            if ((end = src.indexOf(VISUAL_CONTENT_TYPE, end)) < 0) {
                return -1;
            }
            if ((end = src.indexOf(34, end)) < 0) {
                return -1;
            }
            return end + 1;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public static int[] getAnnotationArgs(String src, int start) {
        int s = FreeFormAnnotationTemplate.getAnnotationArgStart(src, start);
        if (start < 0) {
            return null;
        }
        int sep = FreeFormAnnotationTemplate.getSigOnSameLine(s, src, ',');
        if (sep < 0) {
            return null;
        }
        int end = FreeFormAnnotationTemplate.getAnnotationEnd(src, start);
        int[] result = new int[]{Integer.parseInt(src.substring(s, sep)), Integer.parseInt(src.substring(sep + 1, end))};
        return result;
    }

    public static int getAnnotationEnd(String src, int start) {
        try {
            int end = FreeFormAnnotationTemplate.getAnnotationArgStart(src, start);
            if (end < 0) {
                return -1;
            }
            if ((end = FreeFormAnnotationTemplate.getSigOnSameLine(end, src, '\"')) < 0) {
                return -1;
            }
            return end;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public static String getCurrentAnnotation(String src) {
        int start = FreeFormAnnotationTemplate.getAnnotationStart(src);
        if (start < 0) {
            return null;
        }
        int end = FreeFormAnnotationTemplate.getAnnotationEnd(src, start);
        if (end < 0) {
            return null;
        }
        return src.substring(start, end);
    }

    public static String getAnnotationPrefix() {
        return ANNOTATION_PREFIX;
    }
}

