/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.wizards.NewClassCreationWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ve.internal.java.codegen.core.CodegenMessages;
import org.eclipse.ve.internal.java.codegen.wizards.NewVisualClassCreationWizard;
import org.eclipse.ve.internal.java.codegen.wizards.VisualClassExampleWizardPage;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class VisualClassExampleWizard
extends NewClassCreationWizard
implements IExecutableExtension {
    private VisualClassExampleWizardPage fPage;
    private String fExampleClassName;
    private String fPluginName = null;

    public VisualClassExampleWizard() {
        this.setDefaultPageImageDescriptor(JavaVEPlugin.getWizardTitleImageDescriptor());
        this.setDialogSettings(JavaVEPlugin.getPlugin().getDialogSettings());
        this.setWindowTitle(CodegenMessages.getPluginPropertyString("example.label"));
    }

    public void addPages() {
        this.fPage = new VisualClassExampleWizardPage();
        this.addPage((IWizardPage)this.fPage);
        this.fPage.init(this.getSelection());
        this.fPage.setSuperClass("javax.swing.JFrame", false);
        this.fPage.setTypeName(this.fExampleClassName, false);
        this.fPage.setPluginName(this.fPluginName);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fPage.createType(monitor);
        ICompilationUnit cu = JavaModelUtil.toOriginal((ICompilationUnit)this.fPage.getCreatedType().getCompilationUnit());
        if (cu != null) {
            IResource resource = cu.getResource();
            this.selectAndReveal(resource);
            this.openResource(resource);
        }
    }

    protected void openResource(IResource resource) {
        NewVisualClassCreationWizard.openResourceJVE(resource);
    }

    public void setInitializationData(IConfigurationElement element, String string, Object object) {
        if (object instanceof String) {
            this.fPluginName = element.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier();
            this.fExampleClassName = (String)object;
        }
    }
}

