/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.wizards;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class VisualClassExampleWizardPage
extends NewClassWizardPage {
    IType fCreatedType = null;
    String fPluginName = null;

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.setControl((Control)composite);
    }

    public void validateType() {
        this.updateStatus(this.typeNameChanged());
    }

    public IType getCreatedType() {
        return this.fCreatedType;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        block17: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(NewWizardMessages.getString((String)"NewTypeWizardPage.operationdesc"), 10);
            ICompilationUnit createdWorkingCopy = null;
            try {
                IType workingCopy;
                IType createdType;
                IPackageFragmentRoot root = this.getPackageFragmentRoot();
                IPackageFragment pack = this.getPackageFragment();
                if (pack == null) {
                    pack = root.getPackageFragment("");
                }
                if (!pack.exists()) {
                    String packName = pack.getElementName();
                    pack = root.createPackageFragment(packName, true, null);
                }
                monitor.worked(1);
                String clName = this.getTypeName();
                boolean isInnerClass = this.isEnclosingTypeSelected();
                int indent = 0;
                String lineDelimiter = null;
                if (!isInnerClass) {
                    lineDelimiter = System.getProperty("line.separator", "\n");
                    ICompilationUnit parentCU = pack.createCompilationUnit(String.valueOf(clName) + ".java", "", false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    createdWorkingCopy = (ICompilationUnit)parentCU.getSharedWorkingCopy(null, JavaUI.getBufferFactory(), null);
                    String typeContent = this.getExampleFileContents();
                    String cuContent = this.constructCUContent(parentCU, typeContent, lineDelimiter);
                    createdWorkingCopy.getBuffer().setContents(cuContent);
                    createdType = createdWorkingCopy.getType(clName);
                } else {
                    IType enclosingType = this.getEnclosingType();
                    workingCopy = (IType)EditorUtility.getWorkingCopy((IMember)enclosingType);
                    if (workingCopy != null) {
                        enclosingType = workingCopy;
                    }
                    ICompilationUnit parentCU = enclosingType.getCompilationUnit();
                    lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaElement)enclosingType);
                    StringBuffer content = new StringBuffer();
                    String comment = this.getTypeComment(parentCU);
                    if (comment != null) {
                        content.append(comment);
                        content.append(lineDelimiter);
                    }
                    content.append(this.getExampleFileContents());
                    IJavaElement[] elems = enclosingType.getChildren();
                    IJavaElement sibling = elems.length > 0 ? elems[0] : null;
                    createdType = enclosingType.createType(content.toString(), sibling, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    indent = StubUtility.getIndentUsed((IJavaElement)enclosingType) + 1;
                }
                this.fCreatedType = createdType;
                ICompilationUnit cu = createdType.getCompilationUnit();
                workingCopy = cu;
                synchronized (workingCopy) {
                    cu.reconcile();
                }
                ISourceRange range = createdType.getSourceRange();
                IBuffer buf = cu.getBuffer();
                String originalContent = buf.getText(range.getOffset(), range.getLength());
                String formattedContent = StubUtility.codeFormat((String)originalContent, (int)indent, (String)lineDelimiter);
                buf.replace(range.getOffset(), range.getLength(), formattedContent);
                ICompilationUnit iCompilationUnit = cu;
                synchronized (iCompilationUnit) {
                    cu.reconcile();
                }
                cu.commit(true, monitor);
                monitor.worked(1);
            }
            catch (Throwable throwable) {
                Object var17_18 = null;
                if (createdWorkingCopy != null) {
                    createdWorkingCopy.destroy();
                }
                monitor.done();
                throw throwable;
            }
            {
                Object var17_19 = null;
                if (createdWorkingCopy == null) break block17;
            }
            createdWorkingCopy.destroy();
        }
        monitor.done();
    }

    protected URL getFileLocation() {
        Plugin p = null;
        if (this.fPluginName != null) {
            p = Platform.getPlugin((String)this.fPluginName);
        }
        if (p == null) {
            p = JavaVEPlugin.getPlugin();
        }
        String fileLocation = "Examples/" + this.getTypeName() + ".java";
        URL result = null;
        try {
            result = new URL(p.getDescriptor().getInstallURL(), fileLocation);
        }
        catch (MalformedURLException malformedURLException) {}
        return result;
    }

    public String getExampleFileContents() {
        try {
            String line;
            URL toDoListFileURL = this.getFileLocation();
            if (toDoListFileURL == null) {
                return "Could not find example file";
            }
            InputStream stream = toDoListFileURL.openStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(stream));
            String lineSeparator = System.getProperty("line.separator");
            StringBuffer outputBuffer = new StringBuffer(1000);
            while ((line = in.readLine()) != null) {
                outputBuffer.append(line);
                outputBuffer.append(lineSeparator);
            }
            in.close();
            return outputBuffer.toString();
        }
        catch (Exception exc) {
            exc.toString();
            return null;
        }
    }

    public void setEnclosingType(IType type, boolean canBeModified) {
    }

    protected IStatus containerChanged() {
        IStatus status = super.containerChanged();
        if (status.getSeverity() == 2 && status instanceof StatusInfo) {
            ((StatusInfo)status).setError(status.getMessage());
        }
        return status;
    }

    public String getPluginName() {
        return this.fPluginName;
    }

    public void setPluginName(String string) {
        this.fPluginName = string;
    }
}

