/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.commands;

import java.util.ArrayList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.ve.internal.cde.commands.ApplyKeyedValueCommand;
import org.eclipse.ve.internal.cde.commands.ApplyVisualConstraintCommand;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.AnnotationPolicy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.cdm.CDMFactory;
import org.eclipse.ve.internal.cdm.Diagram;
import org.eclipse.ve.internal.cdm.KeyedValueHolder;
import org.eclipse.ve.internal.cdm.VisualInfo;
import org.eclipse.ve.internal.cdm.model.Dimension;
import org.eclipse.ve.internal.cdm.model.Point;
import org.eclipse.ve.internal.cdm.model.Rectangle;
import org.eclipse.ve.internal.propertysheet.common.commands.CommandWrapper;

public class ApplyVisualInfoCommand
extends CommandWrapper {
    protected Object modelObject;
    protected EditDomain domain;
    protected Diagram diagram;
    protected Object newSetting;

    public ApplyVisualInfoCommand(Object modelObject, EditDomain domain, Diagram diagram) {
        this.modelObject = modelObject;
        this.domain = domain;
        this.diagram = diagram;
    }

    public ApplyVisualInfoCommand(Object modelObject, Object newValue, EditDomain domain, Diagram diagram) {
        this(modelObject, domain, diagram);
        this.setValue(newValue);
    }

    public void setValue(Object newSetting) {
        if (newSetting instanceof BasicEMap.Entry || newSetting instanceof Point || newSetting instanceof Dimension || newSetting instanceof Rectangle) {
            this.newSetting = newSetting;
        }
    }

    protected boolean prepare() {
        return this.modelObject != null && this.domain != null && this.diagram != null && this.newSetting != null;
    }

    public void execute() {
        Object c;
        VisualInfo vi;
        if (this.command != null) {
            super.execute();
        }
        CommandBuilder cb = new CommandBuilder(null);
        Annotation annotation = this.domain.getAnnotationLinkagePolicy().getAnnotation(this.modelObject);
        boolean createdAnnotation = false;
        if (annotation == null) {
            createdAnnotation = true;
            annotation = AnnotationPolicy.createAnnotation(this.modelObject);
        }
        if ((vi = annotation.getVisualInfo(this.diagram)) == null) {
            CDMFactory fact = CDMFactory.eINSTANCE;
            vi = fact.createVisualInfo();
            cb.applyAttributeSetting((EObject)vi, (EStructuralFeature)fact.getCDMPackage().getVisualInfo_Diagram(), this.diagram);
            if (createdAnnotation) {
                annotation.getVisualInfos().add(vi);
            } else {
                cb.applyAttributeSetting((EObject)annotation, (EStructuralFeature)fact.getCDMPackage().getAnnotation_VisualInfos(), vi);
            }
        }
        if (this.newSetting instanceof BasicEMap.Entry) {
            c = new ApplyKeyedValueCommand();
            ((ApplyKeyedValueCommand)((Object)c)).setTarget((KeyedValueHolder)vi);
            ((ApplyKeyedValueCommand)((Object)c)).setValue((BasicEMap.Entry)this.newSetting);
            cb.append((Command)c);
        } else {
            c = new ApplyVisualConstraintCommand(null);
            ((ApplyVisualConstraintCommand)((Object)c)).setTarget((KeyedValueHolder)vi);
            ((ApplyVisualConstraintCommand)((Object)c)).setConstraint(this.newSetting);
            cb.append((Command)c);
        }
        if (createdAnnotation) {
            ArrayList<Annotation> a = new ArrayList<Annotation>(1);
            a.add(annotation);
            cb.append(AnnotationPolicy.getDefaultAddAnnotationsCommand(a, this.domain));
            cb.append(AnnotationPolicy.getApplyModelToAnnotationCommand(this.modelObject, annotation, this.domain.getAnnotationLinkagePolicy()));
        }
        this.command = cb.getCommand();
        this.command.execute();
    }
}

