/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.ForwardedRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.ve.internal.cde.core.EditDomain;

public abstract class ContainerPolicy {
    protected Object container;
    protected EditDomain domain;

    public ContainerPolicy(EditDomain domain) {
        this.domain = domain;
    }

    public Object getContainer() {
        return this.container;
    }

    public EditDomain getEditDomain() {
        return this.domain;
    }

    public void setContainer(Object container) {
        this.container = container;
    }

    public abstract Command getAddCommand(List var1, Object var2);

    public abstract Command getCreateCommand(Object var1, Object var2);

    public abstract Command getDeleteDependentCommand(Object var1);

    public abstract Command getOrphanChildrenCommand(List var1);

    public abstract Command getMoveChildrenCommand(List var1, Object var2);

    public static List getChildren(GroupRequest request) {
        List cEP = request.getEditParts();
        ArrayList<Object> children = new ArrayList<Object>(cEP.size());
        Iterator itr = cEP.iterator();
        while (itr.hasNext()) {
            Object child = ((EditPart)itr.next()).getModel();
            children.add(child);
        }
        return children;
    }

    public Command getCommand(Request request) {
        if (this.container == null) {
            return null;
        }
        if ("delete dependant".equals(request.getType())) {
            return this.getDeleteDependentCommand(((ForwardedRequest)request).getSender().getModel());
        }
        if ("create child".equals(request.getType())) {
            return this.getCreateCommand(((CreateRequest)request).getNewObject(), null);
        }
        if ("add children".equals(request.getType())) {
            return this.getAddCommand(ContainerPolicy.getChildren((GroupRequest)request), null);
        }
        if ("orphan children".equals(request.getType())) {
            return this.getOrphanChildrenCommand(ContainerPolicy.getChildren((GroupRequest)request));
        }
        return null;
    }
}

