/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ve.internal.cde.core.AnnotationLinkagePolicy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.IGridListener;
import org.eclipse.ve.internal.cdm.Annotation;

public class GridController {
    public static final String GRID_KEY = "org.eclipse.ve.internal.cde.core.gridkey";
    public static final String GRID_STATE_KEY = "org.eclipse.ve.internal.cde.core.gridstatekey";
    public static final String GRID_THIS_PART = "THIS_PART";
    protected List listeners = new ArrayList(5);
    protected HashMap registeredEPs = new HashMap(2);
    private boolean showGrid = false;
    private int gridWidth = 20;
    private int gridHeight = 20;
    private int gridMargin = 0;
    static /* synthetic */ Class class$0;

    public static GridController getGridController(IEditorPart activeEditor) {
        EditPartViewer viewer;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.gef.GraphicalViewer;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((viewer = (EditPartViewer)activeEditor.getAdapter((Class)clazz)) != null) {
            EditDomain dom = (EditDomain)viewer.getEditDomain();
            return (GridController)dom.getViewerData(viewer, GRID_KEY);
        }
        return null;
    }

    public static GridController getGridController(EditPart editPart) {
        EditPartViewer viewer = editPart.getRoot().getViewer();
        EditDomain dom = (EditDomain)viewer.getEditDomain();
        GridController gc = (GridController)dom.getViewerData(viewer, GRID_KEY);
        if (gc != null) {
            return (GridController)gc.registeredEPs.get(editPart);
        }
        return null;
    }

    public static void registerEditPart(EditPart ep, GridController newgc) {
        EditPartViewer viewer = ep.getRoot().getViewer();
        EditDomain dom = (EditDomain)viewer.getEditDomain();
        GridController gc = (GridController)dom.getViewerData(viewer, GRID_KEY);
        if (gc != null) {
            gc.registeredEPs.put(ep, newgc);
        }
    }

    public static void unregisterEditPart(EditPart ep) {
        EditPartViewer viewer = ep.getRoot().getViewer();
        EditDomain dom = (EditDomain)viewer.getEditDomain();
        GridController gc = (GridController)dom.getViewerData(viewer, GRID_KEY);
        if (gc != null && gc.registeredEPs.get(ep) != null) {
            gc.registeredEPs.remove(ep);
        }
    }

    public void addGridListener(IGridListener listener) {
        this.listeners.add(listener);
    }

    public void removeGridListener(IGridListener listener) {
        this.listeners.remove(listener);
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    public void setGridHeight(int gridHeight) {
        int oldGridHeight = this.gridHeight;
        this.gridHeight = gridHeight;
        int i = 0;
        while (i < this.listeners.size()) {
            ((IGridListener)this.listeners.get(i)).gridHeightChanged(gridHeight, oldGridHeight);
            ++i;
        }
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public void setGridWidth(int gridWidth) {
        int oldGridWidth = this.gridWidth;
        this.gridWidth = gridWidth;
        int i = 0;
        while (i < this.listeners.size()) {
            ((IGridListener)this.listeners.get(i)).gridWidthChanged(gridWidth, oldGridWidth);
            ++i;
        }
    }

    public int getGridMargin() {
        return this.gridMargin;
    }

    public void setGridMargin(int gridMargin) {
        int oldGridMargin = this.gridMargin;
        this.gridMargin = gridMargin;
        int i = 0;
        while (i < this.listeners.size()) {
            ((IGridListener)this.listeners.get(i)).gridMarginChanged(gridMargin, oldGridMargin);
            ++i;
        }
    }

    public boolean isGridShowing() {
        return this.showGrid;
    }

    public void setGridShowing(boolean showGrid) {
        this.showGrid = showGrid;
        int i = 0;
        while (i < this.listeners.size()) {
            ((IGridListener)this.listeners.get(i)).gridVisibilityChanged(showGrid);
            if (this.listeners.get(i) instanceof LayoutEditPolicy) {
                this.setGridState(((LayoutEditPolicy)this.listeners.get(i)).getHost(), showGrid);
            }
            ++i;
        }
    }

    protected void setGridState(EditPart ep, boolean showGrid) {
        AnnotationLinkagePolicy policy;
        Annotation ann;
        EditDomain domain = EditDomain.getEditDomain(ep);
        HashSet<String> gridStateData = (HashSet<String>)domain.getData(GRID_STATE_KEY);
        if (gridStateData == null) {
            gridStateData = new HashSet<String>(2);
        }
        if ((ann = (policy = domain.getAnnotationLinkagePolicy()).getAnnotation(ep.getModel())) != null) {
            String name = (String)ann.getKeyedValues().get((Object)"org.eclipse.ve.internal.cde.core.nameincomposition");
            if (name == null) {
                name = GRID_THIS_PART;
            }
            if (showGrid) {
                gridStateData.add(name);
            } else {
                gridStateData.remove(name);
            }
            domain.setData(GRID_STATE_KEY, gridStateData);
        }
    }
}

