/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class OutlineBorder
extends AbstractBorder {
    protected Color foreground = ColorConstants.black;
    protected Color background;
    private static final Insets insets = new Insets(0, 0, 0, 0);
    protected int lineStyle = 1;

    public OutlineBorder() {
    }

    public OutlineBorder(Color foreground, Color background) {
        this.foreground = foreground;
        this.background = background;
    }

    public OutlineBorder(Color foreground, Color background, int lineStyle) {
        this(foreground, background);
        this.lineStyle = lineStyle;
    }

    public void paint(IFigure aFigure, Graphics g, Insets insets) {
        Rectangle r = AbstractBorder.getPaintRectangle((IFigure)aFigure, (Insets)insets);
        r.resize(-1, -1);
        g.setForegroundColor(this.foreground);
        if (this.lineStyle != 1) {
            if (this.background != null) {
                g.setBackgroundColor(this.background);
            } else {
                g.setBackgroundColor(ColorConstants.black);
                g.setXORMode(true);
            }
        }
        g.setLineStyle(this.lineStyle);
        g.drawRectangle(r);
    }

    public void setColors(Color foreground, Color background) {
        this.foreground = foreground;
        this.background = background;
    }

    public void setLineStyle(int aStyle) {
        this.lineStyle = aStyle;
    }

    public Insets getInsets(IFigure aFigure) {
        return insets;
    }

    public boolean isOpaque() {
        return true;
    }
}

