/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.EditorPartAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.GridController;

public class ShowGridAction
extends EditorPartAction {
    public static final String ACTION_ID = "ocm.SHOWGRID";
    public static final String SHOW_GRID = "Show grid";

    public ShowGridAction(IEditorPart part) {
        super(part);
        this.setText(CDEMessages.getString("ShowGridAction.label"));
        this.setToolTipText(CDEMessages.getString("ShowGridAction.tooltip"));
        this.setId(ACTION_ID);
        this.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)CDEMessages.getString("ShowGridAction.image")));
        this.setChecked(false);
        this.setEnabled(true);
    }

    public void run() {
        EditPart ep = (EditPart)((IStructuredSelection)this.getEditorPart().getSite().getSelectionProvider().getSelection()).getFirstElement();
        if (ep == null) {
            return;
        }
        GridController gridController = GridController.getGridController(ep);
        if (gridController == null) {
            this.setEnabled(false);
            return;
        }
        gridController.setGridShowing(!gridController.isGridShowing());
        this.setChecked(gridController.isGridShowing());
        if (this.isChecked()) {
            this.setText(CDEMessages.getString("ShowGridAction.hide.label"));
            this.setToolTipText(CDEMessages.getString("ShowGridAction.hide.tooltip"));
        } else {
            this.setText(CDEMessages.getString("ShowGridAction.label"));
            this.setToolTipText(CDEMessages.getString("ShowGridAction.tooltip"));
        }
        this.firePropertyChange(SHOW_GRID, new Boolean(!gridController.isGridShowing()), new Boolean(gridController.isGridShowing()));
    }

    protected boolean calculateEnabled() {
        return false;
    }
}

