/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ve.internal.cde.commands.CancelVisualConstraintCommand;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.ContainerPolicy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.IConstraintHandler;
import org.eclipse.ve.internal.cde.core.IModelAdapterFactory;
import org.eclipse.ve.internal.cde.core.KeyedValueNotificationHelper;
import org.eclipse.ve.internal.cde.core.VisualInfoPolicy;
import org.eclipse.ve.internal.cde.core.XYLayoutEditPolicy;
import org.eclipse.ve.internal.cde.core.ZoomController;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.cdm.KeyedValueHolder;
import org.eclipse.ve.internal.cdm.VisualInfo;
import org.eclipse.ve.internal.cdm.model.Dimension;
import org.eclipse.ve.internal.cdm.model.Point;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class VisualInfoXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected ContainerPolicy containerPolicy;
    public static final String VISUAL_CONSTRAINT_REFRESH_POLICY = "org.eclipse.ve.internal.cde.core.visualConstraintRefreshPolicy";
    static /* synthetic */ Class class$0;

    public VisualInfoXYLayoutEditPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
    }

    public void activate() {
        super.activate();
        this.containerPolicy.setContainer(this.getHost().getModel());
    }

    public void deactivate() {
        super.deactivate();
        this.containerPolicy.setContainer(null);
    }

    protected Command createAddCommand(EditPart childEditPart, Object constraint) {
        Object child = childEditPart.getModel();
        GroupRequest grpReq = new GroupRequest((Object)"add children");
        grpReq.setEditParts(childEditPart);
        Command addContributionCmd = this.containerPolicy.getCommand((Request)grpReq);
        if (addContributionCmd == null || !addContributionCmd.canExecute()) {
            return UnexecutableCommand.INSTANCE;
        }
        ((org.eclipse.ve.internal.cdm.model.Rectangle)constraint).width = -1;
        ((org.eclipse.ve.internal.cdm.model.Rectangle)constraint).height = -1;
        IConstraintHandler handler = this.getChildConstraintHandler(child);
        CompoundCommand command = new CompoundCommand();
        command.append(addContributionCmd);
        command.append(this.primChangeConstraintCommand(child, handler, (org.eclipse.ve.internal.cdm.model.Rectangle)constraint, true, false));
        return command.unwrap();
    }

    protected Command createChangeConstraintCommand(EditPart childEditPart, Object constraint, boolean moved, boolean resized) {
        return this.primChangeConstraintCommand(childEditPart.getModel(), this.getConstraintHandler(childEditPart), (org.eclipse.ve.internal.cdm.model.Rectangle)constraint, moved, resized);
    }

    protected Command getCreateCommand(CreateRequest aRequest) {
        Object child = aRequest.getNewObject();
        Command createContributionCmd = this.containerPolicy.getCommand((Request)aRequest);
        if (createContributionCmd == null || !createContributionCmd.canExecute()) {
            return UnexecutableCommand.INSTANCE;
        }
        org.eclipse.ve.internal.cdm.model.Rectangle constraint = (org.eclipse.ve.internal.cdm.model.Rectangle)this.translateToModelConstraint(this.getConstraintFor(aRequest));
        CompoundCommand command = new CompoundCommand();
        command.append(createContributionCmd);
        IConstraintHandler constraintHandler = this.getChildConstraintHandler(child);
        command.append(this.primChangeConstraintCommand(child, constraintHandler, constraint, true, this.isChildResizeable(constraintHandler) && (constraint.width != -1 || constraint.height != -1)));
        return command.unwrap();
    }

    protected IConstraintHandler getChildConstraintHandler(Object child) {
        IConstraintHandler iConstraintHandler;
        IModelAdapterFactory factory = CDEUtilities.getModelAdapterFactory(this.getHost());
        if (factory != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.ve.internal.cde.core.IConstraintHandler;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iConstraintHandler = (IConstraintHandler)factory.getAdapter(child, clazz);
        } else {
            iConstraintHandler = null;
        }
        return iConstraintHandler;
    }

    protected IConstraintHandler getConstraintHandler(EditPart editpart) {
        IAdaptable iAdaptable = (IAdaptable)editpart;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ve.internal.cde.core.IConstraintHandler;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IConstraintHandler)iAdaptable.getAdapter((Class)clazz);
    }

    protected Command getDeleteDependantCommand(Request aRequest) {
        Command deleteContributionCmd = this.containerPolicy.getCommand(aRequest);
        if (deleteContributionCmd == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return deleteContributionCmd;
    }

    protected Command getOrphanChildrenCommand(Request aRequest) {
        Command orphanContributionCmd = this.containerPolicy.getCommand(aRequest);
        if (orphanContributionCmd == null || !orphanContributionCmd.canExecute()) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand command = new CompoundCommand("");
        command.append(orphanContributionCmd);
        GroupRequest gr = (GroupRequest)aRequest;
        Iterator children = gr.getEditParts().iterator();
        while (children.hasNext()) {
            IConstraintHandler constraintHandler;
            EditPart childEditPart = (EditPart)children.next();
            VisualInfo vi = VisualInfoPolicy.getVisualInfo(childEditPart);
            if (vi != null) {
                CancelVisualConstraintCommand delCommand = new CancelVisualConstraintCommand();
                delCommand.setTarget((KeyedValueHolder)vi);
                command.append((Command)delCommand);
            }
            if ((constraintHandler = this.getConstraintHandler(childEditPart)) == null) continue;
            command.append(constraintHandler.contributeOrphanChildCommand());
        }
        return command;
    }

    protected Command primChangeConstraintCommand(Object model, IConstraintHandler handler, org.eclipse.ve.internal.cdm.model.Rectangle constraint, boolean pointChanged, boolean sizeChanged) {
        EditPartViewer viewer = this.getHost().getRoot().getViewer();
        VisualInfo vi = VisualInfoPolicy.getVisualInfo(model, viewer);
        Object constraintKV = vi != null ? vi.getKeyedValues().get((Object)"org.eclipse.ve.internal.cdm.model.visualconstraintkey") : null;
        org.eclipse.ve.internal.cdm.model.Rectangle lConstraint = constraintKV instanceof org.eclipse.ve.internal.cdm.model.Rectangle ? (org.eclipse.ve.internal.cdm.model.Rectangle)constraintKV : null;
        if ((pointChanged |= lConstraint == null) || sizeChanged) {
            EditDomain dom = EditDomain.getEditDomain(this.getHost());
            org.eclipse.ve.internal.cdm.model.Rectangle newConstraint = null;
            Command sizeCommand = null;
            if (pointChanged && sizeChanged) {
                newConstraint = constraint;
                if (handler != null) {
                    sizeCommand = handler.contributeSizeCommand(constraint.width, constraint.height, dom);
                    if (sizeCommand != null) {
                        constraint.height = -1;
                        constraint.width = -1;
                    }
                } else {
                    constraint.height = -1;
                    constraint.width = -1;
                }
            } else if (pointChanged) {
                newConstraint = new Point(constraint.x, constraint.y);
            } else {
                if (handler != null && (sizeCommand = handler.contributeSizeCommand(constraint.width, constraint.height, dom)) != null) {
                    return sizeCommand;
                }
                newConstraint = new Dimension(constraint.width, constraint.height);
            }
            Command viCmd = VisualInfoPolicy.applyVisualInfoSetting(model, newConstraint, dom, dom.getDiagram(viewer));
            return sizeCommand == null ? viCmd : viCmd.chain(sizeCommand);
        }
        return null;
    }

    public Command getCommand(Request request) {
        if ("delete".equals(request.getType())) {
            return this.containerPolicy.getCommand(request);
        }
        return super.getCommand(request);
    }

    protected void refreshFromEditPart(EditPart child, Object constraintValue) {
        org.eclipse.ve.internal.cdm.model.Rectangle constraint = (org.eclipse.ve.internal.cdm.model.Rectangle)this.getChildConstraint(child, constraintValue);
        Rectangle rect = (Rectangle)this.modelToFigureConstraint(constraint);
        this.setConstraintToFigure(child, rect);
    }

    protected void setConstraintToFigure(EditPart child, Rectangle figureConstraint) {
        IConstraintHandler handler = this.getConstraintHandler(child);
        if (handler != null) {
            int x = figureConstraint.x;
            int y = figureConstraint.y;
            handler.contributeFigureSize(figureConstraint);
            figureConstraint.setLocation(x, y);
        }
        ((GraphicalEditPart)this.getHost()).setLayoutConstraint(child, ((GraphicalEditPart)child).getFigure(), (Object)figureConstraint);
    }

    private void setNewSize(EditPart child, int width, int height) {
        Rectangle rect = (Rectangle)((GraphicalEditPart)this.getHost()).getContentPane().getLayoutManager().getConstraint(((GraphicalEditPart)child).getFigure());
        rect = rect == null ? new Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, width, height) : rect.getCopy().setSize(width, height);
        this.setConstraintToFigure(child, rect);
    }

    protected Object translateToModelConstraint(Object figureConstraint) {
        Rectangle r = (Rectangle)figureConstraint;
        return new org.eclipse.ve.internal.cdm.model.Rectangle(r.x, r.y, r.width, r.height);
    }

    protected Object modelToFigureConstraint(Object modelConstraint) {
        if (modelConstraint == null) {
            modelConstraint = new org.eclipse.ve.internal.cdm.model.Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, -1, -1);
        }
        org.eclipse.ve.internal.cdm.model.Rectangle r = (org.eclipse.ve.internal.cdm.model.Rectangle)modelConstraint;
        Rectangle figureConstraint = new Rectangle(r.x, r.y, r.width, r.height);
        ZoomController zoomController = this.getZoomController();
        if (zoomController != null) {
            if (figureConstraint.x != Integer.MIN_VALUE) {
                figureConstraint.x = zoomController.zoomCoordinate(figureConstraint.x);
            }
            if (figureConstraint.y != Integer.MIN_VALUE) {
                figureConstraint.y = zoomController.zoomCoordinate(figureConstraint.y);
            }
        }
        return figureConstraint;
    }

    protected boolean isChildResizeable(EditPart childEditpart) {
        return this.isChildResizeable(this.getConstraintHandler(childEditpart));
    }

    protected boolean isChildResizeable(IConstraintHandler handler) {
        return handler != null ? handler.isResizeable() : false;
    }

    protected Object getChildConstraint(EditPart child) {
        VisualInfo vi = VisualInfoPolicy.getVisualInfo(child);
        if (vi == null) {
            return null;
        }
        return this.getChildConstraint(child, vi.getKeyedValues().get((Object)"org.eclipse.ve.internal.cdm.model.visualconstraintkey"));
    }

    protected Object getChildConstraint(EditPart child, Object kv) {
        org.eclipse.ve.internal.cdm.model.Rectangle constraint = kv instanceof org.eclipse.ve.internal.cdm.model.Rectangle ? new org.eclipse.ve.internal.cdm.model.Rectangle((org.eclipse.ve.internal.cdm.model.Rectangle)kv) : new org.eclipse.ve.internal.cdm.model.Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, -1, -1);
        IConstraintHandler handler = this.getConstraintHandler(child);
        if (handler != null) {
            int x = constraint.x;
            int y = constraint.y;
            handler.contributeModelSize(constraint);
            constraint.x = x;
            constraint.y = y;
        }
        return constraint;
    }

    protected void decorateChild(EditPart child) {
        super.decorateChild(child);
        child.installEditPolicy((Object)VISUAL_CONSTRAINT_REFRESH_POLICY, (EditPolicy)new VisualConstraintRefreshPolicy());
    }

    static /* synthetic */ void access$0(VisualInfoXYLayoutEditPolicy visualInfoXYLayoutEditPolicy, EditPart editPart, int n, int n2) {
        visualInfoXYLayoutEditPolicy.setNewSize(editPart, n, n2);
    }

    protected class VisualConstraintRefreshPolicy
    extends AbstractEditPolicy
    implements IConstraintHandler.IConstraintHandlerListener {
        private VisualInfoPolicy.VisualInfoListener viListener;
        private IConstraintHandler handler;
        private boolean deactivated;
        static /* synthetic */ Class class$0;

        protected VisualConstraintRefreshPolicy() {
        }

        public void activate() {
            this.deactivated = false;
            super.activate();
            EditPartViewer viewer = this.getHost().getRoot().getViewer();
            EditDomain dom = (EditDomain)viewer.getEditDomain();
            this.viListener = new VisualInfoPolicy.VisualInfoListener(this, this.getHost().getModel(), dom.getDiagram(viewer), dom){
                final /* synthetic */ VisualConstraintRefreshPolicy this$1;
                {
                    this.this$1 = visualConstraintRefreshPolicy;
                }

                public void notifyVisualInfoChanges(Notification msg) {
                    Notification kvMsg;
                    Class<?> clazz = VisualConstraintRefreshPolicy.class$0;
                    if (clazz == null) {
                        try {
                            clazz = VisualConstraintRefreshPolicy.class$0 = Class.forName("[Lorg.eclipse.ve.internal.cdm.VisualInfo;").getComponentType();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (msg.getFeatureID((Class)clazz) == 0 && (kvMsg = KeyedValueNotificationHelper.notifyChanged(msg, "org.eclipse.ve.internal.cdm.model.visualconstraintkey")) != null) {
                        switch (kvMsg.getEventType()) {
                            case 1: {
                                VisualConstraintRefreshPolicy.access$2(this.this$1).refreshFromEditPart(this.this$1.getHost(), ((BasicEMap.Entry)kvMsg.getNewValue()).getValue());
                                break;
                            }
                            case 2: {
                                VisualConstraintRefreshPolicy.access$2(this.this$1).refreshFromEditPart(this.this$1.getHost(), null);
                            }
                        }
                    }
                }

                public void notifyVisualInfo(int eventType, VisualInfo oldVI, VisualInfo newVI) {
                    VisualConstraintRefreshPolicy.access$0(this.this$1);
                }

                public void notifyAnnotation(int eventType, Annotation oldAnnotation, Annotation newAnnotation) {
                    super.notifyAnnotation(eventType, oldAnnotation, newAnnotation);
                    VisualConstraintRefreshPolicy.access$0(this.this$1);
                }
            };
            this.handler = VisualInfoXYLayoutEditPolicy.this.getConstraintHandler(this.getHost());
            if (this.handler != null) {
                this.handler.addConstraintHandlerListener(this);
            }
            this.signalRefresh();
        }

        private void signalRefresh() {
            Object kv = null;
            VisualInfo vi = VisualInfoPolicy.getVisualInfo(this.getHost());
            if (vi != null) {
                kv = vi.getKeyedValues().get((Object)"org.eclipse.ve.internal.cdm.model.visualconstraintkey");
            }
            VisualInfoXYLayoutEditPolicy.this.refreshFromEditPart(this.getHost(), kv);
        }

        public void deactivate() {
            this.deactivated = true;
            super.deactivate();
            if (this.viListener != null) {
                this.viListener.removeListening();
            }
            this.viListener = null;
            if (this.handler != null) {
                this.handler.removeConstraintHandlerListener(this);
            }
            this.handler = null;
        }

        public EditPart getTargetEditPart(Request request) {
            return null;
        }

        public void sizeChanged(int width, int height) {
            Display.getDefault().asyncExec(new Runnable(this, width, height){
                final /* synthetic */ VisualConstraintRefreshPolicy this$1;
                private final /* synthetic */ int val$width;
                private final /* synthetic */ int val$height;
                {
                    this.this$1 = visualConstraintRefreshPolicy;
                    this.val$width = n;
                    this.val$height = n2;
                }

                public void run() {
                    if (!VisualConstraintRefreshPolicy.access$1(this.this$1)) {
                        VisualInfoXYLayoutEditPolicy.access$0(VisualConstraintRefreshPolicy.access$2(this.this$1), this.this$1.getHost(), this.val$width, this.val$height);
                    }
                }
            });
        }

        static /* synthetic */ void access$0(VisualConstraintRefreshPolicy visualConstraintRefreshPolicy) {
            visualConstraintRefreshPolicy.signalRefresh();
        }

        static /* synthetic */ boolean access$1(VisualConstraintRefreshPolicy visualConstraintRefreshPolicy) {
            return visualConstraintRefreshPolicy.deactivated;
        }

        static /* synthetic */ VisualInfoXYLayoutEditPolicy access$2(VisualConstraintRefreshPolicy visualConstraintRefreshPolicy) {
            return visualConstraintRefreshPolicy.VisualInfoXYLayoutEditPolicy.this;
        }
    }
}

