/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.emf;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.ve.internal.cde.core.AnnotationPolicy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cdm.Annotation;

public class DefaultLabelProviderNotifier {
    protected EObject model;
    protected ILabelProvider labelProvider;
    protected IDefaultLabelProviderListener listener;
    protected AnnotationPolicy.AnnotationListener annotationListener;
    protected ILabelProviderListener labelProviderListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            DefaultLabelProviderNotifier.this.listener.refreshLabel(DefaultLabelProviderNotifier.this.labelProvider);
        }
    };
    protected EditDomain domain;

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(ILabelProvider provider) {
        if (this.model != null) {
            if (this.labelProvider != null) {
                this.labelProvider.removeListener(this.labelProviderListener);
            }
            this.labelProvider = provider;
            if (this.labelProvider != null) {
                this.labelProvider.addListener(this.labelProviderListener);
                if (this.annotationListener == null) {
                    this.annotationListener = new AnnotationPolicy.AnnotationListener(this.model, this.domain){

                        public void notifyAnnotation(int eventType, Annotation oldAnnotation, Annotation newAnnotation) {
                            DefaultLabelProviderNotifier.this.listener.refreshLabel(DefaultLabelProviderNotifier.this.labelProvider);
                        }

                        public void notifyAnnotationChanges(Notification msg) {
                            if (DefaultLabelProviderNotifier.this.labelProvider == null) {
                                return;
                            }
                            Object sf = msg.getFeature();
                            if (sf instanceof EStructuralFeature && DefaultLabelProviderNotifier.this.labelProvider.isLabelProperty((Object)DefaultLabelProviderNotifier.this.model, ((EStructuralFeature)sf).getName())) {
                                DefaultLabelProviderNotifier.this.listener.refreshLabel(DefaultLabelProviderNotifier.this.labelProvider);
                            }
                        }
                    };
                }
            }
        }
    }

    public void setModel(EObject model, EditDomain domain, IDefaultLabelProviderListener listener, ILabelProvider provider) {
        if (this.model != null) {
            if (this.labelProvider != null) {
                this.labelProvider.removeListener(this.labelProviderListener);
            }
            this.labelProvider = null;
            if (this.annotationListener != null) {
                this.annotationListener.removeListening();
            }
            this.annotationListener = null;
            this.model = null;
            this.domain = null;
        }
        if (model != null) {
            this.model = model;
            this.domain = domain;
            this.listener = listener;
            if (provider != null) {
                this.setLabelProvider(provider);
            }
        }
    }

    public interface IDefaultLabelProviderListener {
        public void refreshLabel(ILabelProvider var1);
    }
}

