/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.emf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.cde.emf.IDomainedFactory;

public class EMFPrototypeCreationFactory
implements CreationFactory,
IDomainedFactory {
    protected URI prototypeURI;
    protected List prototypes;
    protected EObject prototype;

    public EMFPrototypeCreationFactory(String prototypeURIString) {
        this.setPrototypeURI(URI.createURI((String)prototypeURIString));
    }

    public void setPrototypeURI(URI prototypeURI) {
        this.prototypeURI = prototypeURI;
    }

    public void setEditDomain(EditDomain domain) {
        ResourceSet rset;
        Resource res;
        this.prototype = null;
        this.prototypes = null;
        if (this.prototypeURI != null && (res = (rset = EMFEditDomainHelper.getResourceSet(domain)).getResource(this.prototypeURI.trimFragment(), true)) != null) {
            this.prototype = res.getEObject(this.prototypeURI.fragment());
            if (this.prototype != null) {
                if (this.prototype.eContainer() != null) {
                    this.prototype = null;
                    System.out.println("Prototype from URI is not contained directly by the Resource. URI=" + this.prototypeURI);
                } else {
                    this.prototypes = new ArrayList(res.getContents());
                }
            }
            rset.getResources().remove(res);
        }
    }

    public Object getNewObject() {
        if (this.prototype != null) {
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            copier.copyAll((Collection)this.prototypes);
            copier.copyReferences();
            return copier.get(this.prototype);
        }
        return null;
    }

    public Object getObjectType() {
        return this.prototype != null ? this.prototype.eClass() : null;
    }
}

