/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.utility;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Panel;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;

public class ToolTipContentHelper {
    public static IFigure createToolTip(ITextViewer v) {
        return new AssistedToolTipFigure(v);
    }

    public static IFigure createToolTip(ITextViewer v, IContentAssistProcessor[] p) {
        return new AssistedToolTipFigure(v, p);
    }

    public static class AssistedToolTipFigure
    extends Panel {
        ITextViewer fviewer;
        ArrayList fContentAssistProcessors = new ArrayList();
        HashMap fEntries = new HashMap();

        public AssistedToolTipFigure(ITextViewer v) {
            this.fviewer = v;
            FlowLayout layout = new FlowLayout(false);
            layout.setMajorSpacing(0);
            layout.setMinorSpacing(0);
            this.setLayoutManager((LayoutManager)layout);
        }

        public AssistedToolTipFigure(ITextViewer v, IContentAssistProcessor[] p) {
            this(v);
            int i = 0;
            while (i < p.length) {
                this.addContentProcessor(p[i]);
                ++i;
            }
        }

        public void addContentProcessor(IContentAssistProcessor p) {
            this.fContentAssistProcessors.add(p);
            Label l = new Label();
            this.add((IFigure)l);
            this.fEntries.put(p, l);
        }

        public void removeContentProcessor(IContentAssistProcessor p) {
            Label l = (Label)this.fEntries.remove(p);
            this.remove((IFigure)l);
            ((AbstractCollection)this.fContentAssistProcessors).remove(p);
        }

        public void addNotify() {
            super.addNotify();
            int i = 0;
            while (i < this.fContentAssistProcessors.size()) {
                IContentAssistProcessor p = (IContentAssistProcessor)this.fContentAssistProcessors.get(i);
                Label l = (Label)this.fEntries.get(p);
                int offset = this.fviewer != null ? this.fviewer.getSelectedRange().x : -1;
                ICompletionProposal[] props = p.computeCompletionProposals(this.fviewer, offset);
                if (props != null && props.length > 0) {
                    ICompletionProposal prop = props[0];
                    l.setText(prop.getDisplayString());
                    l.setIcon(prop.getImage());
                } else {
                    l.setText("");
                    l.setIcon(null);
                }
                ++i;
            }
        }
    }
}

