/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.propertysheet;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ve.internal.propertysheet.IDescriptorPropertySheetEntry;
import org.eclipse.ve.internal.propertysheet.SetToNullAction;
import org.eclipse.ve.internal.propertysheet.ShowNullsAction;
import org.eclipse.ve.internal.propertysheet.ShowReadOnlyAction;
import org.eclipse.ve.internal.propertysheet.ShowSetValuesAction;

public class EToolsPropertySheetPage
extends PropertySheetPage
implements ISelectionProvider {
    protected ShowNullsAction fShowNullsAction;
    protected ShowSetValuesAction fShowSetValuesAction;
    protected SetToNullAction fSetToNullAction;
    protected ShowReadOnlyAction fShowReadOnlyAction;
    protected ListenerList fSelectionListeners = new ListenerList(1);
    protected Viewer propertySheetViewer;
    protected Method deactivateCellEditorMethod;
    protected IDescriptorPropertySheetEntry rootEntry;
    protected ListenerList fListeners = new ListenerList(1);
    private ISelection selectionQueued;
    static /* synthetic */ Class class$0;

    public void addListener(Listener aListener) {
        this.fListeners.add((Object)aListener);
    }

    public void removeListener(Listener aListener) {
        this.fListeners.remove((Object)aListener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener selListener) {
        this.fSelectionListeners.add((Object)selListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener selListener) {
        this.fSelectionListeners.remove((Object)selListener);
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    public void handleEntrySelection(ISelection selection) {
        super.handleEntrySelection(selection);
        if (this.fSetToNullAction != null) {
            this.fSetToNullAction.selectionChanged(selection);
        }
        if (!this.fSelectionListeners.isEmpty()) {
            Object[] listeners = this.fSelectionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ISelectionChangedListener)listeners[i]).selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
                ++i;
            }
        }
    }

    public void setSelection(ISelection selection) {
    }

    public IPropertySheetEntry getRootEntry() {
        TableTree tree = (TableTree)this.getControl();
        return tree != null ? (IPropertySheetEntry)tree.getData() : null;
    }

    public ISelection getSelection() {
        TableTree tree = (TableTree)this.getControl();
        if (tree == null || tree.getSelectionCount() == 0) {
            return StructuredSelection.EMPTY;
        }
        TableTreeItem[] sel = tree.getSelection();
        ArrayList<Object> entries = new ArrayList<Object>(sel.length);
        int i = 0;
        while (i < sel.length) {
            TableTreeItem ti = sel[i];
            Object data = ti.getData();
            if (data instanceof IPropertySheetEntry) {
                entries.add(data);
            }
            ++i;
        }
        return new StructuredSelection(entries);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.ui.views.properties.PropertySheetPage;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field viewerField = clazz.getDeclaredField("viewer");
            ((AccessibleObject)viewerField).setAccessible(true);
            this.propertySheetViewer = (Viewer)viewerField.get((Object)this);
            this.deactivateCellEditorMethod = this.propertySheetViewer.getClass().getDeclaredMethod("deactivateCellEditor", null);
            ((AccessibleObject)this.deactivateCellEditorMethod).setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        TableTree tableTree = (TableTree)this.getControl();
        Table table = tableTree.getTable();
        TableLayout tableLayout = (TableLayout)table.getLayout();
        new TableColumn(table, 0);
        int width = table.getVerticalBar().getSize().x;
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(width, false));
        if (!this.fListeners.isEmpty()) {
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((Listener)listeners[i]).controlCreated((Control)tableTree);
                ++i;
            }
            this.fListeners.clear();
        }
    }

    public void deactivateCellEditor() {
        try {
            this.deactivateCellEditorMethod.invoke((Object)this.propertySheetViewer, null);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    protected void makeActions() {
        this.fShowNullsAction = new ShowNullsAction(this);
        this.fShowSetValuesAction = new ShowSetValuesAction(this, true);
        this.fSetToNullAction = new SetToNullAction(this);
        this.fShowReadOnlyAction = new ShowReadOnlyAction(this);
        this.fShowNullsAction.run();
        this.fShowSetValuesAction.run();
        this.fShowReadOnlyAction.run();
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
        this.makeActions();
        menuManager.add((IAction)this.fShowNullsAction);
        menuManager.add((IAction)this.fShowSetValuesAction);
        menuManager.add((IAction)this.fShowReadOnlyAction);
        toolBarManager.add((IAction)this.fSetToNullAction);
    }

    public void setRootEntry(IPropertySheetEntry entry) {
        super.setRootEntry(entry);
        IDescriptorPropertySheetEntry iDescriptorPropertySheetEntry = this.rootEntry = entry instanceof IDescriptorPropertySheetEntry ? (IDescriptorPropertySheetEntry)entry : null;
        if (this.fShowNullsAction != null) {
            this.fShowNullsAction.run();
        }
        if (this.fShowSetValuesAction != null) {
            this.fShowSetValuesAction.run();
        }
        if (this.fShowReadOnlyAction != null) {
            this.fShowReadOnlyAction.run();
        }
    }

    public void selectionChanged(final IWorkbenchPart part, final ISelection selection) {
        if (this.rootEntry == null || !(selection instanceof IStructuredSelection)) {
            super.selectionChanged(part, selection);
        } else {
            EToolsPropertySheetPage eToolsPropertySheetPage = this;
            synchronized (eToolsPropertySheetPage) {
                if (selection.equals(this.selectionQueued)) {
                    return;
                }
                this.selectionQueued = selection;
                this.rootEntry.markStale();
            }
            Display d = Display.getCurrent();
            if (d == null) {
                d = Display.getDefault();
            }
            d.asyncExec(new Runnable(){

                public void run() {
                    Control ctrl = EToolsPropertySheetPage.this.getControl();
                    if (ctrl != null && !ctrl.isDisposed()) {
                        EToolsPropertySheetPage eToolsPropertySheetPage = EToolsPropertySheetPage.this;
                        synchronized (eToolsPropertySheetPage) {
                            if (!selection.equals(EToolsPropertySheetPage.this.selectionQueued)) {
                                return;
                            }
                            EToolsPropertySheetPage.this.selectionQueued = null;
                        }
                        EToolsPropertySheetPage.this.superSelectionChanged(part, selection);
                    }
                }
            });
        }
    }

    private void superSelectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
    }

    public interface Listener {
        public void controlCreated(Control var1);
    }
}

