/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.propertysheet;

import java.text.MessageFormat;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class ObjectComboBoxCellEditor
extends CellEditor {
    private String[] items;
    private int selection = -1;
    private CCombo comboBox;
    private Object setValue;
    protected static final int sNoSelection = -1;

    public ObjectComboBoxCellEditor(Composite parent) {
        super(parent);
    }

    public ObjectComboBoxCellEditor(Composite parent, String[] items) {
        super(parent);
        this.items = items;
        if (items != null) {
            this.populateComboBoxItems();
        }
    }

    protected Control createControl(Composite parent) {
        this.comboBox = new CCombo(parent, this.getCComboStyle());
        this.comboBox.setFont(parent.getFont());
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ObjectComboBoxCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int newSelection = ObjectComboBoxCellEditor.this.comboBox.getSelectionIndex();
                if (newSelection == ObjectComboBoxCellEditor.this.selection) {
                    return;
                }
                ObjectComboBoxCellEditor.this.selection = newSelection;
                Object newValue = ObjectComboBoxCellEditor.this.doGetObject(ObjectComboBoxCellEditor.this.selection);
                boolean oldValidState = ObjectComboBoxCellEditor.this.isValueValid();
                boolean newValidState = ObjectComboBoxCellEditor.this.isCorrect(newValue);
                if (!newValidState) {
                    ObjectComboBoxCellEditor.this.setErrorMessage(MessageFormat.format(ObjectComboBoxCellEditor.this.getErrorMessage(), ObjectComboBoxCellEditor.this.items[ObjectComboBoxCellEditor.this.selection]));
                }
                ObjectComboBoxCellEditor.this.valueChanged(oldValidState, newValidState, newValue);
                ObjectComboBoxCellEditor.this.fireApplyEditorValue();
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        return this.comboBox;
    }

    protected int getCComboStyle() {
        return 8;
    }

    protected void fireApplyEditorValue() {
        super.fireApplyEditorValue();
    }

    protected void keyReleaseOccured(KeyEvent e) {
        super.keyReleaseOccured(e);
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    protected void setErrorMessage(String message) {
        super.setErrorMessage(message);
    }

    protected void valueChanged(boolean oldValidState, boolean newValidState, Object newValue) {
        super.valueChanged(oldValidState, newValidState);
        if (newValidState) {
            this.setValue = newValue;
        }
    }

    protected final int getSelectionIndex() {
        return this.selection;
    }

    protected final String[] getDisplayStrings() {
        return this.items;
    }

    protected boolean isCorrect(Object value) {
        String eMsg = this.isCorrectObject(value);
        if (eMsg == null || eMsg.length() == 0) {
            return super.isCorrect(value);
        }
        this.setErrorMessage(eMsg);
        return false;
    }

    protected abstract String isCorrectObject(Object var1);

    protected abstract Object doGetObject(int var1);

    protected Object doGetValue() {
        return this.setValue;
    }

    protected final Object getSetValue() {
        return this.setValue;
    }

    protected abstract int doGetIndex(Object var1);

    protected final void doSetEditorSelection(int selection) {
        this.selection = selection;
        this.comboBox.select(selection);
    }

    protected void doSetObject(Object value) {
    }

    protected void doSetValue(Object value) {
        this.setValue = value;
        this.doSetObject(value);
        this.doSetEditorSelection(this.doGetIndex(value));
    }

    protected void populateComboBoxItems() {
        if (this.comboBox != null && this.items != null) {
            if (this.comboBox.getItemCount() > 0) {
                this.comboBox.removeAll();
            }
            int i = 0;
            while (i < this.items.length) {
                this.comboBox.add(this.items[i], i);
                ++i;
            }
        }
    }

    protected void setItems(String[] items) {
        this.items = items;
        this.populateComboBoxItems();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData ld = super.getLayoutData();
        ld.minimumWidth = 50;
        return ld;
    }
}

