/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.ide;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBeanProxy;
import org.eclipse.jem.internal.proxy.ide.IDEMethodProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IDEStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IDEStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IDEThrowableProxy;
import org.eclipse.jem.internal.proxy.ide.IIDEBeanProxy;

public class IDEMethodProxy
extends IDEBeanProxy
implements IMethodProxy {
    protected Method fMethod;

    protected IDEMethodProxy(ProxyFactoryRegistry aRegistry, Method aMethod) {
        super(aRegistry);
        this.fMethod = aMethod;
    }

    public IBeanTypeProxy getClassType() {
        return ((IDEStandardBeanTypeProxyFactory)this.fProxyFactoryRegistry.getBeanTypeProxyFactory()).getBeanTypeProxy(this.fMethod.getDeclaringClass());
    }

    public IBeanTypeProxy getReturnType() {
        return ((IDEStandardBeanTypeProxyFactory)this.fProxyFactoryRegistry.getBeanTypeProxyFactory()).getBeanTypeProxy(this.fMethod.getReturnType());
    }

    public IBeanTypeProxy[] getParameterTypes() {
        Class<?>[] parmClasses = this.fMethod.getParameterTypes();
        IBeanTypeProxy[] parmTypes = new IBeanTypeProxy[parmClasses.length];
        IDEStandardBeanTypeProxyFactory factory = (IDEStandardBeanTypeProxyFactory)this.fProxyFactoryRegistry.getBeanTypeProxyFactory();
        int i = 0;
        while (i < parmClasses.length) {
            parmTypes[i] = factory.getBeanTypeProxy(parmClasses[i]);
            ++i;
        }
        return parmTypes;
    }

    public String getName() {
        return this.fMethod.getName();
    }

    public IBeanTypeProxy getTypeProxy() {
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).methodType;
    }

    public IBeanProxy invoke(IBeanProxy subject) throws ThrowableProxy {
        try {
            Object result = this.fMethod.invoke(subject != null ? ((IIDEBeanProxy)subject).getBean() : null, new Object[0]);
            if (result == null) {
                return null;
            }
            Class<?> returnType = this.fMethod.getReturnType();
            return this.getBeanProxy(returnType, result);
        }
        catch (InvocationTargetException e) {
            IBeanTypeProxy exceptionTypeProxy = ((IDEStandardBeanTypeProxyFactory)this.fProxyFactoryRegistry.getBeanTypeProxyFactory()).getBeanTypeProxy(e.getTargetException().getClass());
            throw new IDEThrowableProxy(e.getTargetException(), exceptionTypeProxy);
        }
        catch (Exception exc) {
            IBeanTypeProxy exceptionTypeProxy = ((IDEStandardBeanTypeProxyFactory)this.fProxyFactoryRegistry.getBeanTypeProxyFactory()).getBeanTypeProxy(exc.getClass());
            throw new IDEThrowableProxy(exc, exceptionTypeProxy);
        }
    }

    public IBeanProxy invokeCatchThrowableExceptions(IBeanProxy subject) {
        try {
            return this.invoke(subject);
        }
        catch (ThrowableProxy exc) {
            ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)exc));
            return null;
        }
    }

    public IBeanProxy invoke(IBeanProxy subject, IBeanProxy argument) throws ThrowableProxy {
        try {
            Object result = this.fMethod.invoke(subject != null ? ((IIDEBeanProxy)subject).getBean() : null, argument != null ? ((IIDEBeanProxy)argument).getBean() : null);
            if (result == null) {
                return null;
            }
            Class<?> returnType = this.fMethod.getReturnType();
            return this.getBeanProxy(returnType, result);
        }
        catch (InvocationTargetException e) {
            IBeanTypeProxy exceptionTypeProxy = ((IDEStandardBeanTypeProxyFactory)this.fProxyFactoryRegistry.getBeanTypeProxyFactory()).getBeanTypeProxy(e.getTargetException().getClass());
            throw new IDEThrowableProxy(e.getTargetException(), exceptionTypeProxy);
        }
        catch (Exception exc) {
            IBeanTypeProxy exceptionTypeProxy = ((IDEStandardBeanTypeProxyFactory)this.fProxyFactoryRegistry.getBeanTypeProxyFactory()).getBeanTypeProxy(exc.getClass());
            throw new IDEThrowableProxy(exc, exceptionTypeProxy);
        }
    }

    public IBeanProxy invokeCatchThrowableExceptions(IBeanProxy subject, IBeanProxy argument) {
        try {
            return this.invoke(subject, argument);
        }
        catch (ThrowableProxy exc) {
            ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)exc));
            return null;
        }
    }

    public IBeanProxy invoke(IBeanProxy subject, IBeanProxy[] arguments) throws ThrowableProxy {
        Object[] beanArguments = new Object[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            if (arguments[i] != null) {
                beanArguments[i] = ((IIDEBeanProxy)arguments[i]).getBean();
            }
            ++i;
        }
        try {
            Object result = this.fMethod.invoke(subject != null ? ((IIDEBeanProxy)subject).getBean() : null, beanArguments);
            if (result == null) {
                return null;
            }
            Class<?> returnType = this.fMethod.getReturnType();
            return this.getBeanProxy(returnType, result);
        }
        catch (InvocationTargetException e) {
            IBeanTypeProxy exceptionTypeProxy = ((IDEStandardBeanTypeProxyFactory)this.fProxyFactoryRegistry.getBeanTypeProxyFactory()).getBeanTypeProxy(e.getTargetException().getClass());
            throw new IDEThrowableProxy(e.getTargetException(), exceptionTypeProxy);
        }
        catch (Exception exc) {
            IBeanTypeProxy exceptionTypeProxy = ((IDEStandardBeanTypeProxyFactory)this.fProxyFactoryRegistry.getBeanTypeProxyFactory()).getBeanTypeProxy(exc.getClass());
            throw new IDEThrowableProxy(exc, exceptionTypeProxy);
        }
    }

    public IBeanProxy invokeCatchThrowableExceptions(IBeanProxy subject, IBeanProxy[] arguments) {
        try {
            return this.invoke(subject, arguments);
        }
        catch (ThrowableProxy exc) {
            ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)exc));
            return null;
        }
    }

    IBeanProxy getBeanProxy(Class returnType, Object bean) {
        return IDEMethodProxy.getBeanProxy(this.fProxyFactoryRegistry, returnType, bean);
    }

    static IBeanProxy getBeanProxy(ProxyFactoryRegistry aRegistry, Class returnType, Object bean) {
        IDEStandardBeanTypeProxyFactory proxyFactory = (IDEStandardBeanTypeProxyFactory)aRegistry.getBeanTypeProxyFactory();
        if (!returnType.isPrimitive()) {
            return IDEStandardBeanProxyFactory.createBeanProxy(aRegistry, bean);
        }
        if (returnType == Integer.TYPE) {
            return proxyFactory.intType.newBeanProxy(bean);
        }
        if (returnType == Boolean.TYPE) {
            return proxyFactory.booleanType.newBeanProxy(bean);
        }
        if (returnType == Float.TYPE) {
            return proxyFactory.floatType.newBeanProxy(bean);
        }
        if (returnType == Long.TYPE) {
            return proxyFactory.longType.newBeanProxy(bean);
        }
        if (returnType == Short.TYPE) {
            return proxyFactory.shortType.newBeanProxy(bean);
        }
        if (returnType == Double.TYPE) {
            return proxyFactory.doubleType.newBeanProxy(bean);
        }
        if (returnType == Byte.TYPE) {
            return proxyFactory.byteType.newBeanProxy(bean);
        }
        if (returnType == Character.TYPE) {
            return proxyFactory.charType.newBeanProxy(bean);
        }
        throw new RuntimeException("Unknown primitive type " + returnType.getName());
    }
}

