/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.ide;

import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.internal.proxy.core.ICallbackRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.ide.IDECallbackRegistry;

public class IDEProxyFactoryRegistry
extends ProxyFactoryRegistry {
    protected String fName;
    protected ClassLoader fClassLoader;
    protected IDECallbackRegistry fCallbackRegistry;

    public static ClassLoader createSpecialLoader(String pluginName, URL[] otherURLs) {
        IPluginRegistry registry = Platform.getPluginRegistry();
        ClassLoader loader = null;
        if (pluginName != null && registry.getPluginDescriptor(pluginName) != null) {
            loader = registry.getPluginDescriptor(pluginName).getPluginClassLoader();
        }
        URL[] mustHaveUrls = ProxyPlugin.getPlugin().urlLocalizeFromPluginDescriptorAndFragments(ProxyPlugin.getPlugin().getDescriptor(), "vm/remotevm.jar");
        URL[] urls = null;
        if (otherURLs != null) {
            urls = new URL[otherURLs.length + mustHaveUrls.length];
            System.arraycopy(mustHaveUrls, 0, urls, 0, mustHaveUrls.length);
            System.arraycopy(otherURLs, 0, urls, mustHaveUrls.length, otherURLs.length);
        } else {
            urls = mustHaveUrls;
        }
        loader = loader != null ? new URLClassLoader(urls, loader) : new URLClassLoader(urls);
        return loader;
    }

    public IDEProxyFactoryRegistry(String aName, ClassLoader loader) {
        this.fName = aName;
        this.fClassLoader = loader;
    }

    ClassLoader getPluginClassLoader() {
        return this.fClassLoader;
    }

    public void registryTerminated() {
    }

    Class loadClass(String aClassName) throws ClassNotFoundException, ExceptionInInitializerError, LinkageError {
        return this.fClassLoader.loadClass(aClassName);
    }

    public ICallbackRegistry getCallbackRegistry() {
        if (this.fCallbackRegistry == null) {
            this.fCallbackRegistry = new IDECallbackRegistry(this);
        }
        return this.fCallbackRegistry;
    }
}

