/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.ide;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jem.internal.proxy.core.IClasspathContributionController;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributor;
import org.eclipse.jem.internal.proxy.core.IRegistration;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.ide.IDEMethodProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IDEProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.ide.IDEStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IDEStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.ide.awt.IDERegisterAWT;

public class IDERegistration
implements IRegistration {
    private String pluginName;

    public static ProxyFactoryRegistry startAnImplementation(IConfigurationContributor[] contributors, boolean attachAWT, IProject project, String vmName, String pluginName, IProgressMonitor pm) throws CoreException {
        IDERegistration idereg = new IDERegistration(pluginName);
        return idereg.startImplementation(contributors, attachAWT, project, vmName, pm);
    }

    public IDERegistration() {
    }

    private IDERegistration(String pluginName) {
        this.pluginName = pluginName;
    }

    public ProxyFactoryRegistry startImplementation(IConfigurationContributor[] contributors, boolean attachAWT, IProject project, String vmName, IProgressMonitor pm) throws CoreException {
        ArrayList<Object> classPaths = null;
        if (project != null) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            classPaths = new ArrayList<String>(Arrays.asList(JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject)));
        } else {
            classPaths = new ArrayList();
        }
        IClasspathContributionController controller = new IClasspathContributionController(){

            public void contributeProject(IProject project, List classpaths, int insertBeforeIndex) throws CoreException {
                ArrayList<String> projectPaths = new ArrayList<String>(Arrays.asList(JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)JavaCore.create((IProject)project))));
                Iterator itr2 = projectPaths.iterator();
                while (itr2.hasNext()) {
                    Object path = itr2.next();
                    if (!classpaths.contains(path)) continue;
                    itr2.remove();
                }
                if (insertBeforeIndex == -1) {
                    classpaths.addAll(projectPaths);
                } else {
                    classpaths.addAll(insertBeforeIndex, projectPaths);
                }
            }

            public void contributeClasspath(String classpath, List classpaths, int insertBeforeIndex) {
                if (!classpaths.contains(classpath)) {
                    if (insertBeforeIndex == -1) {
                        classpaths.add(classpath);
                    } else {
                        classpaths.add(insertBeforeIndex, classpath);
                    }
                }
            }

            public void contributeClasspath(String[] classpathsToAdd, List classpaths, int insertBeforeIndex) {
                int i = 0;
                while (i < classpathsToAdd.length) {
                    this.contributeClasspath(classpathsToAdd[i], classpaths, insertBeforeIndex);
                    ++i;
                }
            }

            public void contributeClasspath(URL[] classpathsURLs, List classpaths, int insertBeforeIndex) {
                int i = 0;
                while (i < classpathsURLs.length) {
                    this.contributeClasspath(classpathsURLs[i].getFile(), classpaths, insertBeforeIndex);
                    ++i;
                }
            }
        };
        if (contributors != null) {
            int i = 0;
            while (i < contributors.length) {
                contributors[i].contributeClasspaths(classPaths, controller);
                ++i;
            }
        }
        URL[] othersURLs = new URL[classPaths.size()];
        int i = 0;
        while (i < othersURLs.length) {
            String path = (String)classPaths.get(i);
            try {
                othersURLs[i] = new URL("file:" + path);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            ++i;
        }
        ProxyFactoryRegistry registry = IDERegistration.createIDEProxyFactoryRegistry(vmName, this.pluginName, othersURLs);
        if (contributors != null) {
            int i2 = 0;
            while (i2 < contributors.length) {
                contributors[i2].contributeToRegistry(registry);
                ++i2;
            }
        }
        return registry;
    }

    public static ProxyFactoryRegistry createIDEProxyFactoryRegistry(String aName, String aPluginName, URL[] otherURLs) {
        IDEProxyFactoryRegistry registry = new IDEProxyFactoryRegistry(aName, IDEProxyFactoryRegistry.createSpecialLoader(aPluginName, otherURLs));
        IDERegistration.initRegistry(registry);
        return registry;
    }

    public static ProxyFactoryRegistry createIDEProxyFactoryRegistry(String aName, ClassLoader loader) {
        IDEProxyFactoryRegistry registry = new IDEProxyFactoryRegistry(aName, loader);
        IDERegistration.initRegistry(registry);
        return registry;
    }

    private static void initRegistry(IDEProxyFactoryRegistry registry) {
        new IDEStandardBeanTypeProxyFactory(registry);
        new IDEStandardBeanProxyFactory(registry);
        new IDEMethodProxyFactory(registry);
        IDERegisterAWT.registerAWT(registry);
    }
}

