/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.ide;

import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.ICharacterBeanProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.INumberBeanProxy;
import org.eclipse.jem.internal.proxy.core.IStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.ide.IDEArrayBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDENumberBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.ide.IDEStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IIDEBeanProxy;
import org.eclipse.jem.internal.proxy.initParser.InitializationStringParser;

public class IDEStandardBeanProxyFactory
implements IStandardBeanProxyFactory {
    protected IDEProxyFactoryRegistry fRegistry;
    protected IDEStandardBeanTypeProxyFactory fBeanTypeProxyFactory;

    static IIDEBeanProxy createBeanProxy(ProxyFactoryRegistry aRegistry, Object anObject) {
        return ((IDEStandardBeanProxyFactory)aRegistry.getBeanProxyFactory()).createIDEBeanProxyWith(anObject);
    }

    IDEStandardBeanProxyFactory(IDEProxyFactoryRegistry aRegistry) {
        this.fRegistry = aRegistry;
        this.fRegistry.registerBeanProxyFactory(this);
        this.fBeanTypeProxyFactory = (IDEStandardBeanTypeProxyFactory)aRegistry.getBeanTypeProxyFactory();
    }

    public IStringBeanProxy createBeanProxyWith(String aString) {
        return this.fBeanTypeProxyFactory.stringClass.createStringBeanProxy(aString);
    }

    public INumberBeanProxy createBeanProxyWith(float aFloat) {
        return this.fBeanTypeProxyFactory.floatType.createFloatBeanProxy(aFloat);
    }

    public INumberBeanProxy createBeanProxyWith(short aShort) {
        return this.fBeanTypeProxyFactory.shortType.createShortBeanProxy(aShort);
    }

    public ICharacterBeanProxy createBeanProxyWith(char aChar) {
        return this.fBeanTypeProxyFactory.charType.createCharBeanProxy(aChar);
    }

    public ICharacterBeanProxy createBeanProxyWith(Character aCharacter) {
        return this.fBeanTypeProxyFactory.charClass.createCharacterBeanProxy(aCharacter);
    }

    public IIntegerBeanProxy createBeanProxyWith(int anInt) {
        return this.fBeanTypeProxyFactory.intType.createIntegerBeanProxy(anInt);
    }

    public IIntegerBeanProxy createBeanProxyWith(Integer anInteger) {
        return this.fBeanTypeProxyFactory.integerClass.createIntegerBeanProxy(anInteger);
    }

    public INumberBeanProxy createBeanProxyWith(long aLong) {
        return this.fBeanTypeProxyFactory.longType.createLongBeanProxy(aLong);
    }

    public INumberBeanProxy createBeanProxyWith(Number aNumber) {
        IDENumberBeanTypeProxy numberTypeProxy = (IDENumberBeanTypeProxy)this.fBeanTypeProxyFactory.getBeanTypeProxy(aNumber.getClass());
        return numberTypeProxy.createNumberBeanProxy(aNumber);
    }

    public IBooleanBeanProxy createBeanProxyWith(boolean aBoolean) {
        return this.fBeanTypeProxyFactory.booleanType.createBooleanBeanProxy(aBoolean);
    }

    public IBooleanBeanProxy createBeanProxyWith(Boolean aBoolean) {
        return this.fBeanTypeProxyFactory.booleanClass.createBooleanBeanProxy(aBoolean);
    }

    public INumberBeanProxy createBeanProxyWith(byte aByte) {
        return this.fBeanTypeProxyFactory.byteType.createByteBeanProxy(aByte);
    }

    public INumberBeanProxy createBeanProxyWith(double aDouble) {
        return this.fBeanTypeProxyFactory.doubleType.createDoubleBeanProxy(aDouble);
    }

    public IArrayBeanProxy createBeanProxyWith(IBeanTypeProxy type, int dimension) throws ThrowableProxy {
        return this.createBeanProxyWith(type, new int[]{dimension});
    }

    public IArrayBeanProxy createBeanProxyWith(IBeanTypeProxy type, int[] dimensions) throws ThrowableProxy {
        if (type.isArray()) {
            return ((IDEArrayBeanTypeProxy)type).createBeanProxyWith(dimensions);
        }
        IDEArrayBeanTypeProxy arrayType = (IDEArrayBeanTypeProxy)this.fBeanTypeProxyFactory.getBeanTypeProxy(type.getTypeName(), dimensions.length);
        return arrayType.createBeanProxyWith(dimensions);
    }

    public void releaseProxy(IBeanProxy aProxy) {
    }

    public IIDEBeanProxy createIDEBeanProxyWith(Object anObject) {
        if (anObject == null) {
            return null;
        }
        return ((IDEBeanTypeProxy)this.fBeanTypeProxyFactory.getBeanTypeProxy(anObject.getClass())).newBeanProxy(anObject);
    }

    IBeanProxy createBeanProxy(IDEBeanTypeProxy aTypeProxy, String initializationString) {
        if (initializationString.equals("null")) {
            return null;
        }
        try {
            ClassLoader pluginClassLoader = this.fRegistry.getPluginClassLoader();
            Object newValue = InitializationStringParser.evaluate((String)initializationString, (ClassLoader)pluginClassLoader);
            return newValue != null ? aTypeProxy.newBeanProxy(newValue) : null;
        }
        catch (Exception exc) {
            ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)exc));
            return null;
        }
    }

    IBeanProxy createBeanProxy(IDEBeanTypeProxy aTypeProxy) {
        Class beanType = aTypeProxy.fClass;
        try {
            return aTypeProxy.newBeanProxy(!aTypeProxy.isPrimitive() ? beanType.newInstance() : null);
        }
        catch (Exception exc) {
            ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)exc));
            return null;
        }
    }

    public void terminateFactory() {
    }
}

