/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.ide;

import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.ide.IDEArrayBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBigDecimalBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBigIntegerBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBooleanClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBooleanTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEByteClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEByteTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDECharTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDECharacterClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEDoubleClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEDoubleTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEExtensionBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IDEFloatClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEFloatTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEInitErrorBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEIntegerClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEIntegerTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDELongClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDELongTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.ide.IDEShortClassBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEShortTypeBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEStringBeanTypeProxy;

public class IDEStandardBeanTypeProxyFactory
implements IStandardBeanTypeProxyFactory {
    protected final IDEProxyFactoryRegistry fFactoryRegistry;
    protected Map beanProxies;
    public static Map MAP_SHORTSIG_TO_TYPE = new HashMap(8);
    public static Map MAP_TYPENAME_TO_SHORTSIG = new HashMap(8);
    IDEBeanTypeProxy objectClass;
    IDEBooleanTypeBeanTypeProxy booleanType;
    IDEBooleanClassBeanTypeProxy booleanClass;
    IDEIntegerTypeBeanTypeProxy intType;
    IDEIntegerClassBeanTypeProxy integerClass;
    IDEFloatTypeBeanTypeProxy floatType;
    IDEFloatClassBeanTypeProxy floatClass;
    IDELongTypeBeanTypeProxy longType;
    IDELongClassBeanTypeProxy longClass;
    IDEShortTypeBeanTypeProxy shortType;
    IDEShortClassBeanTypeProxy shortClass;
    IDEByteTypeBeanTypeProxy byteType;
    IDEByteClassBeanTypeProxy byteClass;
    IDECharTypeBeanTypeProxy charType;
    IDECharacterClassBeanTypeProxy charClass;
    IDEDoubleTypeBeanTypeProxy doubleType;
    IDEDoubleClassBeanTypeProxy doubleClass;
    IDEStringBeanTypeProxy stringClass;
    IDEBeanTypeProxy classClass;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;

    static {
        MAP_SHORTSIG_TO_TYPE.put("B", Byte.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("C", Character.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("D", Double.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("F", Float.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("I", Integer.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("J", Long.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("S", Short.TYPE);
        MAP_SHORTSIG_TO_TYPE.put("Z", Boolean.TYPE);
        MAP_TYPENAME_TO_SHORTSIG.put("byte", "B");
        MAP_TYPENAME_TO_SHORTSIG.put("char", "C");
        MAP_TYPENAME_TO_SHORTSIG.put("double", "D");
        MAP_TYPENAME_TO_SHORTSIG.put("float", "F");
        MAP_TYPENAME_TO_SHORTSIG.put("int", "I");
        MAP_TYPENAME_TO_SHORTSIG.put("long", "J");
        MAP_TYPENAME_TO_SHORTSIG.put("short", "S");
        MAP_TYPENAME_TO_SHORTSIG.put("boolean", "Z");
    }

    public IDEStandardBeanTypeProxyFactory(IDEProxyFactoryRegistry aRegistry) {
        this.fFactoryRegistry = aRegistry;
        aRegistry.registerBeanTypeProxyFactory(this);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Ljava.lang.Object;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.objectClass = new IDEBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, clazz);
        this.booleanType = new IDEBooleanTypeBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, Boolean.TYPE);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Ljava.lang.Boolean;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.booleanClass = new IDEBooleanClassBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, clazz2);
        this.intType = new IDEIntegerTypeBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, Integer.TYPE);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("[Ljava.lang.Integer;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.integerClass = new IDEIntegerClassBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, clazz3);
        this.floatType = new IDEFloatTypeBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, Float.TYPE);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("[Ljava.lang.Float;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.floatClass = new IDEFloatClassBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, clazz4);
        this.longType = new IDELongTypeBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, Long.TYPE);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("[Ljava.lang.Long;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.longClass = new IDELongClassBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, clazz5);
        this.shortType = new IDEShortTypeBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, Short.TYPE);
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("[Ljava.lang.Short;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.shortClass = new IDEShortClassBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, clazz6);
        this.byteType = new IDEByteTypeBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, Byte.TYPE);
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("[Ljava.lang.Byte;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.byteClass = new IDEByteClassBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, clazz7);
        this.charType = new IDECharTypeBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, Character.TYPE);
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("[Ljava.lang.Character;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.charClass = new IDECharacterClassBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, clazz8);
        this.doubleType = new IDEDoubleTypeBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, Double.TYPE);
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("[Ljava.lang.Double;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.doubleClass = new IDEDoubleClassBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, clazz9);
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("[Ljava.lang.String;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.stringClass = new IDEStringBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, clazz10);
        Class<?> clazz11 = class$10;
        if (clazz11 == null) {
            try {
                clazz11 = class$10 = Class.forName("[Ljava.lang.Class;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.classClass = new IDEBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, clazz11);
        this.beanProxies = new HashMap(20);
        this.beanProxies.put("int", this.intType);
        this.beanProxies.put("boolean", this.booleanType);
        this.beanProxies.put("char", this.charType);
        this.beanProxies.put("byte", this.byteType);
        this.beanProxies.put("short", this.shortType);
        this.beanProxies.put("long", this.longType);
        this.beanProxies.put("float", this.floatType);
        this.beanProxies.put("double", this.doubleType);
        this.beanProxies.put("java.lang.Integer", this.integerClass);
        this.beanProxies.put("java.lang.Boolean", this.booleanClass);
        this.beanProxies.put("java.lang.Character", this.charClass);
        this.beanProxies.put("java.lang.Byte", this.byteClass);
        this.beanProxies.put("java.lang.Short", this.shortClass);
        this.beanProxies.put("java.lang.Long", this.longClass);
        this.beanProxies.put("java.lang.Float", this.floatClass);
        this.beanProxies.put("java.lang.Double", this.doubleClass);
        Class<?> clazz12 = class$11;
        if (clazz12 == null) {
            try {
                clazz12 = class$11 = Class.forName("[Ljava.math.BigDecimal;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.beanProxies.put("java.math.BigDecimal", new IDEBigDecimalBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, clazz12));
        Class<?> clazz13 = class$12;
        if (clazz13 == null) {
            try {
                clazz13 = class$12 = Class.forName("[Ljava.math.BigInteger;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.beanProxies.put("java.math.BigInteger", new IDEBigIntegerBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, clazz13));
        this.beanProxies.put("java.lang.String", this.stringClass);
        this.beanProxies.put("java.lang.Class", this.classClass);
    }

    IBeanTypeProxy getBeanTypeProxy(Class anIDEClass) {
        return this.getBeanTypeProxy(anIDEClass.getName());
    }

    public synchronized IBeanTypeProxy getBeanTypeProxy(String typeName) {
        IBeanTypeProxy beanTypeProxy = (IBeanTypeProxy)this.beanProxies.get(typeName = this.getJNIFormatName(typeName));
        if (beanTypeProxy != null) {
            return beanTypeProxy;
        }
        if (typeName.charAt(0) != '[') {
            String msg;
            String packageName;
            IDEExtensionBeanTypeProxyFactory packageFactory;
            int packageIndex = typeName.lastIndexOf(46);
            if (packageIndex != -1 && (packageFactory = (IDEExtensionBeanTypeProxyFactory)this.fFactoryRegistry.getBeanTypeProxyFactoryExtension(packageName = typeName.substring(0, packageIndex))) != null && (beanTypeProxy = packageFactory.getExtensionBeanTypeProxy(typeName)) != null) {
                this.registerBeanTypeProxy(beanTypeProxy, false);
                return beanTypeProxy;
            }
            try {
                Class ideClass = this.fFactoryRegistry.loadClass(typeName);
                IDEBeanTypeProxy superTypeProxy = null;
                if (ideClass.getSuperclass() != null) {
                    superTypeProxy = (IDEBeanTypeProxy)this.getBeanTypeProxy(ideClass.getSuperclass());
                }
                if (superTypeProxy != null) {
                    beanTypeProxy = superTypeProxy.newBeanTypeForClass(ideClass);
                }
                if (beanTypeProxy == null) {
                    beanTypeProxy = new IDEBeanTypeProxy((ProxyFactoryRegistry)this.fFactoryRegistry, ideClass);
                }
            }
            catch (ClassNotFoundException e) {
                ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)e));
                msg = MessageFormat.format("{0}({1})", e.getClass(), e.getMessage());
                beanTypeProxy = new IDEInitErrorBeanTypeProxy(this.fFactoryRegistry, typeName, msg);
            }
            catch (ExceptionInInitializerError e) {
                ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)e));
                msg = MessageFormat.format("{0}({1})", e.getClass(), e.getMessage());
                beanTypeProxy = new IDEInitErrorBeanTypeProxy(this.fFactoryRegistry, typeName, msg);
            }
            catch (LinkageError e) {
                ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)e));
                msg = MessageFormat.format("{0}({1})", e.getClass(), e.getMessage());
                beanTypeProxy = new IDEInitErrorBeanTypeProxy(this.fFactoryRegistry, typeName, msg);
            }
            this.beanProxies.put(typeName, beanTypeProxy);
            return beanTypeProxy;
        }
        int dims = typeName.lastIndexOf(91) + 1;
        Class finalComponentType = null;
        if (typeName.charAt(dims) == 'L') {
            IDEBeanTypeProxy finalType = (IDEBeanTypeProxy)this.getBeanTypeProxy(typeName.substring(dims + 1, typeName.length() - 1));
            if (finalType != null) {
                finalComponentType = finalType.fClass;
            }
        } else {
            finalComponentType = (Class)MAP_SHORTSIG_TO_TYPE.get(typeName.substring(dims, dims + 1));
        }
        if (finalComponentType != null) {
            Object dummyArray = Array.newInstance(finalComponentType, new int[dims]);
            beanTypeProxy = new IDEArrayBeanTypeProxy(this.fFactoryRegistry, typeName, dummyArray.getClass());
            this.beanProxies.put(typeName, beanTypeProxy);
        }
        return beanTypeProxy;
    }

    public IBeanTypeProxy getBeanTypeProxy(String componentClassName, int dimensions) {
        String jniComponentTypeName;
        String compType = jniComponentTypeName = this.getJNIFormatName(componentClassName);
        if (jniComponentTypeName.charAt(0) != '[' && (compType = (String)MAP_TYPENAME_TO_SHORTSIG.get(componentClassName)) == null) {
            compType = "L" + jniComponentTypeName + ";";
        }
        StringBuffer buffer = new StringBuffer(dimensions + compType.length());
        int i = 0;
        while (i < dimensions) {
            buffer.append('[');
            ++i;
        }
        buffer.append(compType);
        return this.getBeanTypeProxy(buffer.toString());
    }

    protected String getJNIFormatName(String classname) {
        int firstOpenBracket;
        if (classname.length() == 0 || !classname.endsWith("]")) {
            return classname;
        }
        StringBuffer jni = new StringBuffer(classname.length());
        int ob = firstOpenBracket = classname.indexOf(91);
        while (ob > -1) {
            int cb = classname.indexOf(93, ob);
            if (cb == -1) break;
            jni.append('[');
            ob = classname.indexOf(91, cb);
        }
        IBeanTypeProxy finalType = this.getBeanTypeProxy(classname.substring(0, firstOpenBracket).trim());
        if (finalType != null) {
            if (!finalType.isPrimitive()) {
                jni.append('L');
                jni.append(finalType.getTypeName());
                jni.append(';');
            } else {
                jni.append(MAP_TYPENAME_TO_SHORTSIG.get(finalType.getTypeName()));
            }
        }
        return jni.toString();
    }

    public void terminateFactory() {
    }

    public synchronized void registerBeanTypeProxy(IBeanTypeProxy aBeanTypeProxy, boolean permanent) {
        this.beanProxies.put(aBeanTypeProxy.getTypeName(), aBeanTypeProxy);
    }

    public synchronized boolean isBeanTypeRegistered(String className) {
        return this.beanProxies.containsKey(this.getJNIFormatName(className));
    }

    public Set registeredTypes() {
        return this.beanProxies.keySet();
    }

    public boolean isBeanTypeNotFound(String className) {
        return false;
    }

    public boolean isMaintainNotFoundTypes() {
        return false;
    }

    public void setMaintainNotFoundTypes(boolean maintain) {
    }
}

