/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.ide;

import java.io.OutputStream;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.ICallbackHandler;
import org.eclipse.jem.internal.proxy.common.ICallbackRunnable;
import org.eclipse.jem.internal.proxy.common.IVMServer;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.ide.IDECallbackRegistry;
import org.eclipse.jem.internal.proxy.ide.IDEStandardBeanProxyFactory;

public class IDEVMServer
implements IVMServer {
    IDECallbackRegistry fCallbackRegistry;
    IDEStandardBeanProxyFactory fBeanProxyFactory;

    IDEVMServer(IDECallbackRegistry aCallbackRegistry) {
        this.fCallbackRegistry = aCallbackRegistry;
        this.fBeanProxyFactory = (IDEStandardBeanProxyFactory)this.fCallbackRegistry.fProxyFactoryRegistry.getBeanProxyFactory();
    }

    public Object doCallback(ICallbackRunnable aRunnable) {
        try {
            return aRunnable.run(new ICallbackHandler(){

                public Object callbackWithParms(int callbackID, int msgID, Object[] parms) {
                    Object[] proxyParms = null;
                    if (parms != null) {
                        proxyParms = new IBeanProxy[parms.length];
                        int i = 0;
                        while (i < parms.length) {
                            proxyParms[i] = IDEVMServer.this.fBeanProxyFactory.createIDEBeanProxyWith(parms[i]);
                            ++i;
                        }
                    }
                    return IDEVMServer.this.fCallbackRegistry.vmCallback(callbackID, msgID, proxyParms);
                }
            });
        }
        catch (CommandException commandException) {
            return null;
        }
    }

    public OutputStream requestStream(int callbackID, int msgID) throws CommandException {
        return this.fCallbackRegistry.requestStream(callbackID, msgID);
    }
}

