/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.ecore.utilities.copy;

import com.ibm.etools.emf.ecore.utilities.copy.CopyGroup;
import com.ibm.etools.emf.ecore.utilities.copy.EtoolsCopyUtility;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class EtoolsCopySession
extends EtoolsCopyUtility {
    public static final int RESOURCE_COPIED = 500;
    private EtoolsCopyUtility parentCopyUtility;
    private XMLResource currentResource;
    private XMLResource currentCopyResource;

    public EtoolsCopySession(EtoolsCopyUtility aCopyUtility) {
        this.parentCopyUtility = aCopyUtility;
        this.setPreserveIds(aCopyUtility.preserveIds());
    }

    public void copy(CopyGroup aGroup) {
        if (aGroup != null) {
            this.copyResources(aGroup);
            this.copyRefObjects(aGroup);
            this.executeDeferredCopyActions();
            this.notifyNewResourcesCopied(aGroup);
        }
    }

    public EObject copy(EObject aRefObject, String idSuffix) {
        EObject copied = this.containmentCopy(aRefObject, idSuffix);
        this.executeDeferredCopyActions();
        return copied;
    }

    public EObject copyObject(EObject aRefObject, String idSuffix) {
        EObject copied = this.containmentCopyObject(aRefObject, idSuffix);
        this.executeDeferredCopyActions();
        return copied;
    }

    public Resource copy(Resource aResource, String newUri) {
        Resource copied = this.containmentCopy(aResource, newUri);
        this.executeDeferredCopyActions();
        this.copyModificationFlag(aResource, copied);
        this.notifyNewResourceCopied(copied);
        return copied;
    }

    protected void notifyNewResourcesCopied(CopyGroup group) {
        List copied = group.getCopiedResources();
        int i = 0;
        while (i < copied.size()) {
            this.notifyNewResourceCopied((Resource)copied.get(i));
            ++i;
        }
    }

    protected void notifyNewResourceCopied(Resource copied) {
        copied.eNotify((Notification)new NotificationImpl(500, null, null));
    }

    protected EObject primCopyObject(EObject aRefObject, String idSuffix) {
        EObject copy = super.primCopyObject(aRefObject, idSuffix);
        this.copyIdIfNecessary(aRefObject, copy, idSuffix);
        return copy;
    }

    protected void copyIdIfNecessary(EObject obj, EObject copy, String idSuffix) {
        if (idSuffix == null && !this.preserveIds || this.currentResource == null) {
            return;
        }
        String id = this.currentResource.getID(obj);
        if (id == null) {
            return;
        }
        id = idSuffix == null ? id : id + idSuffix;
        this.currentCopyResource.setID(copy, id);
    }

    public void flush() {
        Iterator it = this.getCopiedObjects().entrySet().iterator();
        HashMap parentCopies = this.getParentCopyUtility().getCopiedObjects();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            EObject copy = (EObject)entry.getValue();
            copy.eSetDeliver(true);
            parentCopies.put(entry.getKey(), copy);
        }
        this.copiedObjects = null;
    }

    public EObject getCopy(EObject anObject) {
        EObject copied = super.getCopy(anObject);
        if (copied == null) {
            copied = this.getParentCopyUtility().getCopy(anObject);
        }
        return copied;
    }

    protected EtoolsCopyUtility getParentCopyUtility() {
        return this.parentCopyUtility;
    }

    public EObject newInstance(EObject aRefObject) {
        EObject newType = super.newInstance(aRefObject);
        newType.eSetDeliver(false);
        return newType;
    }

    public Resource newInstance(Resource aResource, String newUri) {
        Resource copy = super.newInstance(aResource, newUri);
        if (aResource instanceof XMLResource) {
            this.currentResource = (XMLResource)aResource;
            this.currentCopyResource = (XMLResource)copy;
        } else {
            this.currentResource = null;
            this.currentCopyResource = null;
        }
        return copy;
    }
}

