/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf2xml.impl;

import com.ibm.etools.emf.ecore.utilities.ExtendedEcoreUtil;
import com.ibm.etools.emf2xml.impl.GenericTranslator;
import com.ibm.etools.emf2xml.impl.ReadAheadHelper;
import com.ibm.etools.emf2xml.impl.TranslatorPath;
import com.ibm.etools.emf2xml.util.DOMUtilities;
import com.ibm.etools.emf2xml.util.FeatureValueConverter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;

public class Translator {
    public static final int NO_STYLE = 0;
    public static final int DOM_ATTRIBUTE = 1;
    public static final int EMPTY_TAG = 2;
    public static final int CDATA_CONTENT = 4;
    public static final int END_TAG_NO_INDENT = 8;
    public static final int BOOLEAN_LOWERCASE = 16;
    public static final int ENUM_FEATURE_WITH_HYPHENS = 32;
    protected static final int OBJECT_MAP = 64;
    private static final int BOOLEAN_FEATURE = 128;
    private static Class EOBJECT_CLASS = class$org$eclipse$emf$ecore$EObject == null ? (class$org$eclipse$emf$ecore$EObject = Translator.class$("org.eclipse.emf.ecore.EObject")) : class$org$eclipse$emf$ecore$EObject;
    protected String[] fDOMNames;
    protected String fDOMPath = "";
    protected Map readAheadNames;
    protected int fStyle = 0;
    protected EStructuralFeature feature;
    protected TranslatorPath[] fTranslatorPaths;
    protected EClass emfClass;
    protected String fNameSpace = "";
    protected Boolean isDependencyParent;
    protected EStructuralFeature dependencyFeature;
    public static final String TEXT_ATTRIBUTE_VALUE = "$TEXT_ATTRIBUTE_VALUE";
    public static final EStructuralFeature CONTAINER_FEATURE = new ContainerFeature();
    public static final EStructuralFeature ROOT_FEATURE = new RootFeature();
    static /* synthetic */ Class class$org$eclipse$emf$ecore$EObject;

    public static Object[] concat(Object[] array1, Object[] array2) {
        Object[] result = (Object[])Array.newInstance(array1.getClass().getComponentType(), array1.length + array2.length);
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    public static Object[] concat(Object[] array1, Object object2) {
        Object[] newArray = new Object[]{object2};
        return Translator.concat(array1, newArray);
    }

    public static Translator createParentAndTextAttributeTranslator(String domName, EStructuralFeature parentFeature, EStructuralFeature childFeature) {
        GenericTranslator parent = new GenericTranslator(domName, parentFeature, 8);
        parent.setChildren(new Translator[]{new Translator(TEXT_ATTRIBUTE_VALUE, childFeature)});
        return parent;
    }

    public Translator(String domNameAndPath, EClass eClass) {
        this.initializeDOMNameAndPath(domNameAndPath);
        this.emfClass = eClass;
    }

    public Translator(String domNameAndPath, EStructuralFeature aFeature) {
        this.initializeDOMNameAndPath(domNameAndPath);
        this.setFeature(aFeature);
    }

    public Translator(String domNameAndPath, EStructuralFeature aFeature, EClass eClass) {
        this(domNameAndPath, aFeature);
        this.emfClass = eClass;
    }

    public Translator(String domNameAndPath, EStructuralFeature aFeature, TranslatorPath path) {
        this(domNameAndPath, aFeature, new TranslatorPath[]{path});
    }

    public Translator(String domNameAndPath, EStructuralFeature aFeature, TranslatorPath[] paths) {
        this.initializeDOMNameAndPath(domNameAndPath);
        this.fTranslatorPaths = paths;
        this.setFeature(aFeature);
    }

    public Translator(String domNameAndPath, EStructuralFeature aFeature, int style) {
        this.initializeDOMNameAndPath(domNameAndPath);
        this.fStyle = style;
        this.setFeature(aFeature);
    }

    public static EcorePackage getEcorePackage() {
        return EcorePackage.eINSTANCE;
    }

    public String getDOMName(Object value) {
        return this.fDOMNames[0];
    }

    public String[] getDOMNames() {
        return this.fDOMNames;
    }

    public String getDOMPath() {
        return this.fDOMPath;
    }

    public boolean hasDOMPath() {
        return this.fDOMPath != null && this.fDOMPath.length() != 0;
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    protected void initializeDOMNameAndPath(String domNameAndPath) {
        if (domNameAndPath == null) {
            return;
        }
        int inx = domNameAndPath.lastIndexOf(47);
        if (inx != -1) {
            this.fDOMNames = this.parseDOMNames(domNameAndPath.substring(inx + 1));
            this.fDOMPath = domNameAndPath.substring(0, inx);
        } else {
            this.fDOMNames = this.parseDOMNames(domNameAndPath);
            this.fDOMPath = "";
        }
    }

    public boolean isCDATAContent() {
        return (this.fStyle & 4) != 0;
    }

    public boolean isDOMAttribute() {
        return (this.fStyle & 1) != 0;
    }

    public boolean isEmptyTag() {
        return (this.fStyle & 2) != 0;
    }

    public boolean isBooleanUppercase() {
        return (this.fStyle & 0x80) != 0 && (this.fStyle & 0x10) == 0;
    }

    public boolean isBooleanFeature() {
        return (this.fStyle & 0x80) != 0;
    }

    public boolean shouldIndentEndTag() {
        return (this.fStyle & 8) == 0;
    }

    public boolean isObjectMap() {
        return (this.fStyle & 0x40) != 0;
    }

    public boolean isEnumWithHyphens() {
        return (this.fStyle & 0x20) != 0;
    }

    public boolean isDOMTextValue() {
        return this.fDOMNames[0] == TEXT_ATTRIBUTE_VALUE;
    }

    public boolean isIDMap() {
        return false;
    }

    public boolean isLinkMap() {
        return this.fTranslatorPaths != null;
    }

    public boolean isTargetLinkMap() {
        return this.isLinkMap() && !this.isObjectMap();
    }

    public boolean isMapFor(String domName) {
        Iterator iter = DOMUtilities.createPathIterator(this.getDOMPath());
        while (iter.hasNext()) {
            String pathSegment = (String)iter.next();
            if (!pathSegment.equals(domName)) continue;
            return true;
        }
        int i = 0;
        while (i < this.fDOMNames.length) {
            String mapName = this.fDOMNames[i];
            if (domName.equals(mapName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isMultiValued() {
        if (this.feature != null) {
            return this.feature.isMany();
        }
        return false;
    }

    protected String[] parseDOMNames(String domNamesString) {
        int startInx = 0;
        int inx = domNamesString.indexOf(44);
        ArrayList<String> results = new ArrayList<String>(1);
        while (inx != -1) {
            results.add(domNamesString.substring(startInx, inx));
            startInx = inx + 1;
            inx = domNamesString.indexOf(44, startInx);
        }
        results.add(domNamesString.substring(startInx));
        return results.toArray(new String[results.size()]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String cn = this.getClass().getName();
        int i = cn.lastIndexOf(46);
        cn = cn.substring(++i, cn.length());
        sb.append(cn);
        sb.append('(');
        sb.append(this.fDOMNames[0]);
        int j = 1;
        while (j < this.fDOMNames.length) {
            sb.append('|');
            sb.append(this.fDOMNames[j]);
            ++j;
        }
        sb.append(',');
        sb.append(this.hashCode());
        sb.append(')');
        return sb.toString();
    }

    public TranslatorPath[] getTranslatorPaths() {
        return this.fTranslatorPaths;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Translator)) {
            return false;
        }
        Translator mapInfo = (Translator)object;
        return this.fDOMNames.equals(mapInfo.getDOMNames()) && this.feature.equals(mapInfo.getFeature());
    }

    public boolean isManagedByParent() {
        return this.getChildren(null, -1) == null;
    }

    public EObject createEMFObject(String nodeName, String readAheadName) {
        if (this.emfClass == null) {
            if (this.feature == null) {
                return null;
            }
            if (this.isObjectMap()) {
                return Translator.createEMFObject(this.feature);
            }
        }
        return Translator.createEMFObject(this.emfClass);
    }

    public static EObject createEMFObject(EStructuralFeature aFeature) {
        if (aFeature == null) {
            return null;
        }
        return Translator.createEMFObject(((EReference)aFeature).getEReferenceType());
    }

    public static EObject createEMFObject(EClass anEClass) {
        if (anEClass == null) {
            return null;
        }
        return anEClass.getEPackage().getEFactoryInstance().create(anEClass);
    }

    public boolean featureExists(EObject emfObject) {
        if (this.feature == null) {
            return false;
        }
        return emfObject.eClass().getEStructuralFeature(this.feature.getName()) != null;
    }

    public String extractStringValue(EObject emfObject) {
        if (this.isEmptyTag() && this.feature == null) {
            return "";
        }
        return null;
    }

    public Object convertStringToValue(String strValue, EObject owner) {
        Object value;
        if (this.feature == null) {
            return null;
        }
        if (strValue != null) {
            if (this.isEnumWithHyphens()) {
                strValue = strValue.replace('_', '-');
            }
            if (!this.isCDATAContent()) {
                strValue = strValue.trim();
            }
        }
        if ((value = FeatureValueConverter.DEFAULT.convertValue(strValue, this.feature)) == null) {
            EClassifier convertToType = this.feature.getEType();
            if (convertToType == null) {
                value = strValue;
            } else if (convertToType.equals(Translator.getEcorePackage().getEString())) {
                value = "";
            }
        }
        return value;
    }

    public String convertValueToString(Object value, EObject owner) {
        if (this.isEmptyTag() || value == null) {
            return null;
        }
        if (this.isEnumWithHyphens()) {
            return value.toString().replace('_', '-');
        }
        if (this.isBooleanUppercase()) {
            return (Boolean)value != false ? "True" : "False";
        }
        return value.toString();
    }

    public Translator[] getChildren(Object o, int versionID) {
        return this.getChildren();
    }

    protected Translator[] getChildren() {
        return null;
    }

    public List getMOFChildren(EObject mofObject) {
        if (this.feature == null) {
            return Collections.EMPTY_LIST;
        }
        Object value = mofObject.eGet(this.feature);
        if (this.isMultiValued()) {
            return (List)value;
        }
        Object attrValue = mofObject.eGet(this.feature);
        if (attrValue != null) {
            return Collections.singletonList(value);
        }
        return Collections.EMPTY_LIST;
    }

    public Object getMOFValue(EObject mofObject) {
        if (this.feature == null) {
            return null;
        }
        return mofObject.eGet(this.feature);
    }

    public void setMOFValue(Notifier owner, Object value, int newIndex) {
        if (this.feature != null) {
            ExtendedEcoreUtil.eSetOrAdd((EObject)owner, this.feature, value, newIndex);
        }
    }

    public void setMOFValue(EObject emfObject, Object value) {
        if (this.feature != null) {
            emfObject.eSet(this.feature, value);
        }
    }

    public void removeMOFValue(Notifier owner, Object value) {
        if (this.feature != null) {
            ExtendedEcoreUtil.eUnsetOrRemove((EObject)owner, this.feature, value);
        }
    }

    public boolean isSetMOFValue(EObject emfObject) {
        boolean isSet;
        boolean bl = isSet = this.feature != null && emfObject.eIsSet(this.feature);
        if (this.isEmptyTag()) {
            return isSet && (Boolean)emfObject.eGet(this.feature) != false;
        }
        return isSet;
    }

    public void unSetMOFValue(EObject emfObject) {
        if (this.feature != null) {
            emfObject.eUnset(this.feature);
        }
    }

    public void clearList(EObject mofObject) {
        if (this.feature != null) {
            ((List)mofObject.eGet(this.feature)).clear();
        }
    }

    protected void setFeature(EStructuralFeature aFeature) {
        this.feature = aFeature;
        if (this.feature == null) {
            return;
        }
        if (aFeature instanceof EReference) {
            this.fStyle |= 0x40;
        }
        if (Translator.getEcorePackage().getEBoolean() == this.feature.getEType()) {
            this.fStyle |= 0x80;
        }
    }

    public boolean hasReadAheadNames() {
        return this.readAheadNames != null && !this.readAheadNames.isEmpty();
    }

    public ReadAheadHelper getReadAheadHelper(String parentName) {
        if (this.readAheadNames == null) {
            return null;
        }
        return (ReadAheadHelper)this.readAheadNames.get(parentName);
    }

    public void addReadAheadHelper(ReadAheadHelper helper) {
        if (this.readAheadNames == null) {
            this.readAheadNames = new HashMap(3);
        }
        this.readAheadNames.put(helper.getParentDOMName(), helper);
    }

    public boolean isDependencyChild() {
        return false;
    }

    public boolean isDependencyParent() {
        if (this.isDependencyParent == null) {
            this.isDependencyParent = Boolean.FALSE;
            Translator[] theChildren = this.getChildren(null, -1);
            if (theChildren != null) {
                int i = 0;
                while (i < theChildren.length) {
                    if (theChildren[i].isDependencyChild()) {
                        this.isDependencyParent = Boolean.TRUE;
                        this.dependencyFeature = theChildren[i].getDependencyFeature();
                    }
                    ++i;
                }
            }
        }
        return this.isDependencyParent;
    }

    public EStructuralFeature getDependencyFeature() {
        return this.dependencyFeature;
    }

    public EObject basicGetDependencyObject(EObject parent) {
        return (EObject)parent.eGet(this.dependencyFeature);
    }

    public boolean shouldRenderEmptyDOMPath(EObject eObject) {
        return false;
    }

    public void setMOFValueFromEmptyDOMPath(EObject eObject) {
    }

    public String getNameSpace() {
        return this.fNameSpace;
    }

    public void setNameSpace(String string) {
        this.fNameSpace = string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class RootFeature
    extends EStructuralFeatureImpl {
        protected RootFeature() {
        }
    }

    protected static class ContainerFeature
    extends EStructuralFeatureImpl {
        protected ContainerFeature() {
        }
    }
}

