/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf2xml.impl;

import com.ibm.etools.emf2xml.Renderer;
import com.ibm.etools.emf2xml.TranslatorResource;
import com.ibm.etools.emf2xml.impl.Translator;
import com.ibm.etools.wft.util.StringUtil;
import com.ibm.etools.xmi.helpers.CompatibilityXMIResourceImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.xml.sax.EntityResolver;

public abstract class TranslatorResourceImpl
extends CompatibilityXMIResourceImpl
implements TranslatorResource {
    public static final EStructuralFeature ID_FEATURE = EcorePackage.eINSTANCE.getEClass_EIDAttribute();
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected static final String DEFAULT_VERSION = "1.0";
    protected static final String TO_STRING = ", file = ";
    protected Renderer renderer;
    protected String publicId;
    protected String systemId;
    protected String xmlVersion;
    protected int versionID;

    public TranslatorResourceImpl() {
    }

    public TranslatorResourceImpl(URI uri) {
        super(uri);
    }

    public TranslatorResourceImpl(URI uri, Renderer aRenderer) {
        super(uri);
        this.setRenderer(aRenderer);
        this.versionID = this.getDefaultVersionID();
    }

    public TranslatorResourceImpl(Renderer aRenderer) {
        this.setRenderer(aRenderer);
    }

    public String getEncoding() {
        if (super.getEncoding() == null) {
            this.setEncoding(DEFAULT_ENCODING);
        }
        return super.getEncoding();
    }

    public String getPublicId() {
        return this.publicId;
    }

    public EObject getRootObject() {
        return (EObject)this.getContents().get(0);
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setDoctypeValues(String aPublicId, String aSystemId) {
        boolean changed = !StringUtil.stringsEqual(this.publicId, aPublicId) || !StringUtil.stringsEqual(this.systemId, aSystemId);
        this.publicId = aPublicId;
        this.systemId = aSystemId;
        if (changed) {
            this.eNotify((Notification)new NotificationImpl(1, null, null){

                public Object getFeature() {
                    return TranslatorResource.DOC_TYPE_FEATURE;
                }

                public Object getNotifier() {
                    return TranslatorResourceImpl.this;
                }
            });
        }
    }

    public String getXMLVersion() {
        if (this.xmlVersion == null) {
            this.xmlVersion = DEFAULT_VERSION;
        }
        return this.xmlVersion;
    }

    public void setXMLVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void basicDoLoad(InputStream inputStream, Map options) throws IOException {
        boolean isTrackingMods = this.isTrackingModification();
        try {
            if (isTrackingMods) {
                this.setTrackingModification(false);
            }
            this.renderer.doLoad(inputStream, options);
            Object var5_4 = null;
            if (!isTrackingMods) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!isTrackingMods) throw throwable;
            this.setTrackingModification(true);
            throw throwable;
        }
        this.setTrackingModification(true);
    }

    public void doSave(OutputStream outputStream, Map options) throws IOException {
        this.renderer.doSave(outputStream, options);
        this.setModified(false);
    }

    protected void doUnload() {
        if (this.isTrackingModification()) {
            this.setTrackingModification(false);
        }
        super.doUnload();
    }

    public String toString() {
        return this.getClass().getName() + this.getURI().toString();
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    protected void setRenderer(Renderer renderer) {
        this.renderer = renderer;
        if (renderer.getResource() != this) {
            renderer.setResource(this);
        }
    }

    protected EList primGetContents() {
        return super.getContents();
    }

    public EList getContents() {
        if (((ResourceImpl)this).contents == null) {
            ((ResourceImpl)this).contents = new ResourceImpl.ContentsEList(){

                public boolean add(Object object) {
                    TranslatorResourceImpl.this.renderer.prepareToAddContents();
                    return super.add(object);
                }

                public boolean addAll(Collection collection) {
                    TranslatorResourceImpl.this.renderer.prepareToAddContents();
                    return super.addAll(collection);
                }
            };
        }
        return ((ResourceImpl)this).contents;
    }

    public void setDefaults() {
        if (this.systemId != null && this.publicId != null) {
            return;
        }
        String pubId = this.publicId == null ? this.getDefaultPublicId() : this.publicId;
        String sysId = this.systemId == null ? this.getDefaultSystemId() : this.systemId;
        this.setDoctypeValues(pubId, sysId);
    }

    protected void init() {
        super.init();
        this.setEncoding(DEFAULT_ENCODING);
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    protected abstract String getDefaultPublicId();

    protected abstract String getDefaultSystemId();

    protected abstract int getDefaultVersionID();

    public int getVersionID() {
        return this.versionID;
    }

    public void setVersionID(int i) {
        this.versionID = i;
    }

    public boolean usesDTD() {
        return this.getPublicId() != null && this.getSystemId() != null;
    }

    public void setID(EObject eObject, String id) {
        String oldId = this.getID(eObject);
        super.setID(eObject, id);
        eObject.eNotify((Notification)new ENotificationImpl((InternalEObject)eObject, 1, ID_FEATURE, (Object)oldId, (Object)id));
    }

    public abstract Translator getRootTranslator();

    public abstract String getDoctype();
}

