/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.encoders;

import com.ibm.etools.encoders.InvalidPasswordCipherException;
import com.ibm.etools.encoders.UnsupportedCryptoAlgorithmException;

public class PasswordCipherUtil {
    private static final byte XOR_MASK = 95;
    private static final String[] DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS = new String[]{"xor"};
    private static String[] _supported_crypto_algorithms = null;

    public static byte[] decipher(byte[] abyte0, String s) throws InvalidPasswordCipherException, UnsupportedCryptoAlgorithmException {
        if (s == null) {
            throw new UnsupportedCryptoAlgorithmException();
        }
        byte[] abyte1 = null;
        if (!s.equalsIgnoreCase(DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[0])) {
            throw new UnsupportedCryptoAlgorithmException();
        }
        abyte1 = PasswordCipherUtil.xor(abyte0);
        if (abyte1 == null) {
            throw new InvalidPasswordCipherException();
        }
        return abyte1;
    }

    public static byte[] encipher(byte[] abyte0, String s) throws InvalidPasswordCipherException, UnsupportedCryptoAlgorithmException {
        if (s == null) {
            throw new UnsupportedCryptoAlgorithmException();
        }
        byte[] abyte1 = null;
        if (!s.equalsIgnoreCase(DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS[0])) {
            throw new UnsupportedCryptoAlgorithmException();
        }
        abyte1 = PasswordCipherUtil.xor(abyte0);
        if (abyte1 == null) {
            throw new InvalidPasswordCipherException();
        }
        return abyte1;
    }

    public static String[] getSupportedCryptoAlgorithms() {
        return _supported_crypto_algorithms;
    }

    private static byte[] xor(byte[] abyte0) {
        byte[] abyte1 = null;
        if (abyte0 != null) {
            abyte1 = new byte[abyte0.length];
            int i = 0;
            while (i < abyte0.length) {
                abyte1[i] = (byte)(0x5F ^ abyte0[i]);
                ++i;
            }
        }
        return abyte1;
    }

    static {
        if (_supported_crypto_algorithms == null) {
            _supported_crypto_algorithms = DEFAULT_SUPPORTED_CRYPTO_ALGORITHMS;
        }
    }
}

