/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.encoders;

import com.ibm.etools.wft.nls.ResourceHandler;
import com.ibm.etools.wft.util.Revisit;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class WriteBackHelper {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private Set dirtyObjects = new HashSet();
    private boolean trackingChanges = false;
    private static WriteBackHelper _instance;

    private WriteBackHelper() {
    }

    public void addDirtyObject(EObject dirtyObject) {
        this.dirtyObjects.add(dirtyObject);
    }

    public void begin() {
        this.trackingChanges = true;
    }

    public void end() {
        this.saveDirtyResources();
        this.reset();
        this.trackingChanges = false;
    }

    public boolean isActive() {
        return this.trackingChanges;
    }

    protected void reset() {
        this.dirtyObjects.clear();
    }

    protected void saveDirtyResources() {
        HashSet<Resource> dirtyResources = new HashSet<Resource>();
        Iterator dirtyObjIter = this.dirtyObjects.iterator();
        while (dirtyObjIter.hasNext()) {
            EObject dirtyObject = (EObject)dirtyObjIter.next();
            if (dirtyObject.eResource() == null || dirtyResources.contains(dirtyObject)) continue;
            dirtyResources.add(dirtyObject.eResource());
        }
        Iterator dirtyIter = dirtyResources.iterator();
        while (dirtyIter.hasNext()) {
            Resource dirtyResource = (Resource)dirtyIter.next();
            try {
                dirtyResource.save(Collections.EMPTY_MAP);
            }
            catch (Exception e) {
                this.warn(dirtyResource, e);
            }
        }
    }

    public static WriteBackHelper singleton() {
        if (_instance == null) {
            _instance = new WriteBackHelper();
        }
        return _instance;
    }

    protected void warn(Resource res, Exception e) {
        System.err.println(ResourceHandler.getString("Warning__Could_not_write_b_WARN_", new Object[]{res.getURI()}));
    }

    static {
        Revisit.deleteMe();
    }
}

