/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.logger.proxy;

import com.ibm.etools.logger.proxy.ILogRenderer;
import com.ibm.etools.logger.proxy.JDKConsoleRenderer;
import com.ibm.etools.wft.util.WorkbenchUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Logger {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private boolean fTraceMode = false;
    private String fPluginID;
    private ILogRenderer fRenderer = null;
    private String fClassName = this.getClass().getName();
    private String fLineSeperator;
    private static final String DefaultUIRenderer = "com.ibm.etools.logger.proxyrenderer.DefaultUILogRenderer";
    private static final String DefaultLoggerPlugin = "com.ibm.etools.j2ee";
    private static Hashtable Loggers = new Hashtable();
    protected static final String[] LogMark = new String[]{"*** ERROR *** ", "[Trace] ", "+++ Warning +++ ", "Info: "};
    protected static final String Filler = "    ";
    static /* synthetic */ Class class$com$ibm$etools$logger$proxy$Logger;

    protected Logger() {
        this.fPluginID = DefaultLoggerPlugin;
    }

    protected Logger(String pluginID) {
        this.fPluginID = pluginID;
    }

    public String exceptionToString(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private String getCallerString() {
        Throwable e = new Throwable();
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        String stackTrace = stringWriter.toString();
        String Caller = "";
        int Skip = 4;
        StringTokenizer tokenizer = new StringTokenizer(stackTrace, "\n");
        while (tokenizer.hasMoreTokens()) {
            String St = tokenizer.nextToken();
            if (St.indexOf(this.fClassName) > 0 && --Skip == 0) break;
        }
        if (tokenizer.hasMoreTokens()) {
            Caller = tokenizer.nextToken();
        }
        return Caller;
    }

    public static Logger getLogger() {
        Logger defaultLogger = (Logger)Loggers.get(DefaultLoggerPlugin);
        if (defaultLogger == null) {
            defaultLogger = new Logger();
            defaultLogger.init();
            Loggers.put(DefaultLoggerPlugin, defaultLogger);
        }
        return defaultLogger;
    }

    public static Logger getLogger(String pluginId) {
        if (pluginId == null) {
            return Logger.getLogger();
        }
        Logger Logger2 = (Logger)Loggers.get(pluginId);
        if (Logger2 == null) {
            Logger2 = new Logger(pluginId);
            Logger2.init();
            Loggers.put(pluginId, Logger2);
        }
        return Logger2;
    }

    public String getPluginID() {
        return this.fPluginID;
    }

    public boolean getTraceMode() {
        return this.fTraceMode;
    }

    private void indentMsg(String msg, StringBuffer logMsg) {
        String sep = this.fLineSeperator;
        if (msg.indexOf("\r\n") != -1) {
            sep = "\r\n";
        } else if (msg.indexOf("\n") != -1) {
            sep = "\n";
        } else if (msg.indexOf("\r") != -1) {
            sep = "\r";
        }
        StringTokenizer tokenizer = new StringTokenizer(msg, sep);
        while (tokenizer.hasMoreTokens()) {
            logMsg.append(Filler + tokenizer.nextToken() + this.fLineSeperator);
        }
    }

    private void init() {
        if (System.getProperty("debug") != null) {
            this.fTraceMode = true;
        }
        try {
            this.fLineSeperator = System.getProperty("line.separator");
        }
        catch (Throwable e) {
            this.fLineSeperator = "\n";
        }
    }

    private String logAny(String msg, int type) {
        StringBuffer logMsg = new StringBuffer();
        logMsg.append(this.fLineSeperator);
        logMsg.append(LogMark[type]);
        return this.punchLog(this.logRest(msg, logMsg), type);
    }

    public String logError(String msg) {
        return this.logAny(msg, 0);
    }

    public String logError(Throwable e) {
        String stackTrace = this.exceptionToString(e);
        return this.logAny(stackTrace, 0);
    }

    public String logInfo(String msg) {
        return this.logAny(msg, 3);
    }

    public String logInfo(Throwable e) {
        String stackTrace = this.exceptionToString(e);
        return this.logAny(stackTrace, 3);
    }

    protected String logRest(String msg, StringBuffer logMsg) {
        logMsg.append(new Date());
        logMsg.append("    caller: ");
        logMsg.append(this.getCallerString() + this.fLineSeperator);
        this.indentMsg(msg, logMsg);
        return logMsg.toString();
    }

    public String logTrace(String msg) {
        if (this.fTraceMode) {
            return this.logAny(msg, 1);
        }
        return "";
    }

    public String logTrace(Throwable e) {
        String stackTrace = this.exceptionToString(e);
        return this.logAny(stackTrace, 1);
    }

    public String logWarning(String msg) {
        return this.logAny(msg, 2);
    }

    public String logWarning(Throwable e) {
        String stackTrace = this.exceptionToString(e);
        return this.logAny(stackTrace, 2);
    }

    protected synchronized String punchLog(String msg, int type) {
        if (this.fRenderer == null) {
            if (WorkbenchUtil.workbenchIsRunning()) {
                try {
                    Class<?> clazz = Class.forName(DefaultUIRenderer);
                    Class[] params = new Class[]{class$com$ibm$etools$logger$proxy$Logger == null ? (class$com$ibm$etools$logger$proxy$Logger = Logger.class$("com.ibm.etools.logger.proxy.Logger")) : class$com$ibm$etools$logger$proxy$Logger};
                    Constructor<?> renderCons = clazz.getConstructor(params);
                    this.fRenderer = (ILogRenderer)renderCons.newInstance(this);
                }
                catch (Exception e) {
                    this.fRenderer = new JDKConsoleRenderer(this);
                }
            } else {
                this.fRenderer = new JDKConsoleRenderer(this);
            }
        }
        return this.fRenderer.log(msg, type);
    }

    public void setRenderer(ILogRenderer renderer) {
        this.fRenderer = renderer;
    }

    public void setTraceMode(boolean flag) {
        this.fTraceMode = flag;
        if (this.fRenderer != null) {
            this.fRenderer.setTraceMode(flag);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

