/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.wft.nls;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class AbstractResourceHandler {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected Locale locale = null;
    protected ResourceBundle bundle = null;
    protected String bundleName = null;

    public AbstractResourceHandler() {
        this.setLocale(Locale.getDefault());
    }

    public AbstractResourceHandler(Locale locale) {
        this.setLocale(locale);
    }

    public ResourceBundle getBundle() {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle(this.getBundleName(), this.getLocale());
            }
            catch (MissingResourceException e) {
                System.out.println("Exception retrieving bundle: " + this.getBundleName() + " using locale: " + this.getLocale().toString());
                e.printStackTrace();
            }
        }
        return this.bundle;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public String getMessage(String key) {
        String temp = null;
        try {
            temp = this.getBundle().getString(key);
        }
        catch (MissingResourceException ex) {
            System.out.println("Resource Exception: " + ex);
            temp = "<<Key: " + key + " not found in resource: " + this.getBundleName() + ">>";
        }
        return temp;
    }

    public String getMessage(String key, Object[] arg) {
        String temp = null;
        try {
            temp = MessageFormat.format(this.getBundle().getString(key), arg);
        }
        catch (MissingResourceException ex) {
            System.out.println("Resource Exception: " + ex);
            temp = "<<Key: " + key + " not found in resource: " + this.getBundleName() + ">>";
        }
        return temp;
    }

    public String getMessage(String key, String arg1) {
        String temp = null;
        try {
            if (arg1 != null) {
                Object[] msgobj = new Object[]{arg1};
                temp = this.getMessage(key, msgobj);
            } else {
                temp = this.getMessage(key);
            }
        }
        catch (MissingResourceException ex) {
            System.out.println("Resource Exception: " + ex);
            temp = "<<Key: " + key + " not found in resource: " + this.getBundleName() + ">>";
        }
        return temp;
    }

    public String getMessage(String key, String arg1, String arg2) {
        String temp = null;
        try {
            if (arg1 != null && arg2 != null) {
                Object[] msgobj = new Object[]{arg1, arg2};
                temp = this.getMessage(key, msgobj);
            } else {
                temp = this.getMessage(key);
            }
        }
        catch (MissingResourceException ex) {
            System.out.println("Resource Exception: " + ex);
            temp = "<<Key: " + key + " not found in resource: " + this.getBundleName() + ">>";
        }
        return temp;
    }

    public String getMessage(String key, String arg1, String arg2, String arg3) {
        String temp = null;
        try {
            if (arg1 != null && arg2 != null && arg3 != null) {
                Object[] msgobj = new Object[]{arg1, arg2, arg3};
                temp = this.getMessage(key, msgobj);
            } else {
                temp = this.getMessage(key);
            }
        }
        catch (MissingResourceException ex) {
            System.out.println("Resource Exception: " + ex);
            temp = "<<Key: " + key + " not found in resource: " + this.getBundleName() + ">>";
        }
        return temp;
    }

    public String getMessage(String key, String arg1, String arg2, String arg3, String arg4) {
        String temp = null;
        try {
            if (arg1 != null && arg2 != null && arg3 != null && arg4 != null) {
                Object[] msgobj = new Object[]{arg1, arg2, arg3, arg4};
                temp = this.getMessage(key, msgobj);
            } else {
                temp = this.getMessage(key);
            }
        }
        catch (MissingResourceException ex) {
            System.out.println("Resource Exception: " + ex);
            temp = "<<Key: " + key + " not found in resource: " + this.getBundleName() + ">>";
        }
        return temp;
    }

    public String getMessage(String key, String arg1, String arg2, String arg3, String arg4, String arg5) {
        String temp = null;
        try {
            if (arg1 != null && arg2 != null && arg3 != null && arg4 != null && arg5 != null) {
                Object[] msgobj = new Object[]{arg1, arg2, arg3, arg4, arg5};
                temp = this.getMessage(key, msgobj);
            } else {
                temp = this.getMessage(key);
            }
        }
        catch (MissingResourceException ex) {
            System.out.println("Resource Exception: " + ex);
            temp = "<<Key: " + key + " not found in resource: " + this.getBundleName() + ">>";
        }
        return temp;
    }

    public void setBundleName(String newBundleName) {
        this.bundleName = newBundleName;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

